/*
 * Decompiled with CFR 0.152.
 */
package com.eorion.bo.enhancement.processdraft.config;

import com.eorion.bo.enhancement.processdraft.domain.commom.ErrorMessage;
import lombok.Generated;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.springframework.beans.BeanInstantiationException;
import org.springframework.http.HttpStatus;
import org.springframework.http.converter.HttpMessageConversionException;
import org.springframework.validation.BindException;
import org.springframework.validation.ObjectError;
import org.springframework.web.HttpMediaTypeNotSupportedException;
import org.springframework.web.HttpRequestMethodNotSupportedException;
import org.springframework.web.bind.MissingServletRequestParameterException;
import org.springframework.web.bind.annotation.ExceptionHandler;
import org.springframework.web.bind.annotation.ResponseBody;
import org.springframework.web.bind.annotation.ResponseStatus;
import org.springframework.web.bind.annotation.RestControllerAdvice;
import org.springframework.web.servlet.NoHandlerFoundException;

@RestControllerAdvice
public class ProcessDraftRestControllerAdvice {
    @Generated
    private static final Logger log = LogManager.getLogger(ProcessDraftRestControllerAdvice.class);

    @ExceptionHandler(value={HttpMessageConversionException.class})
    @ResponseStatus(value=HttpStatus.BAD_REQUEST)
    @ResponseBody
    public ErrorMessage wrongFormat(HttpMessageConversionException e) {
        log.error(e.getLocalizedMessage());
        return new ErrorMessage("\u53c2\u6570\u683c\u5f0f\u9519\u8bef");
    }

    @ExceptionHandler(value={BeanInstantiationException.class})
    @ResponseStatus(value=HttpStatus.BAD_REQUEST)
    @ResponseBody
    public ErrorMessage requestParameterError(BeanInstantiationException e) {
        log.error(e.getLocalizedMessage());
        return new ErrorMessage("\u8bf7\u6c42\u4f53\u683c\u5f0f\u9519\u8bef");
    }

    @ExceptionHandler(value={HttpMediaTypeNotSupportedException.class})
    @ResponseStatus(value=HttpStatus.BAD_REQUEST)
    @ResponseBody
    public ErrorMessage wrongMediaType(HttpMediaTypeNotSupportedException e) {
        log.error(e.getLocalizedMessage());
        return new ErrorMessage("\u8d44\u6e90\u7c7b\u578b\u4e0d\u652f\u6301");
    }

    @ExceptionHandler(value={HttpRequestMethodNotSupportedException.class})
    @ResponseStatus(value=HttpStatus.BAD_REQUEST)
    @ResponseBody
    public ErrorMessage wrongRequestMethod(HttpRequestMethodNotSupportedException e) {
        log.error(e.getLocalizedMessage());
        return new ErrorMessage("\u8bf7\u6c42\u65b9\u5f0f\u4e0d\u652f\u6301");
    }

    @ExceptionHandler(value={MissingServletRequestParameterException.class})
    @ResponseStatus(value=HttpStatus.BAD_REQUEST)
    @ResponseBody
    public ErrorMessage missParam(MissingServletRequestParameterException e) {
        log.error(e.getLocalizedMessage());
        return new ErrorMessage("\u53c2\u6570\u7f3a\u5931");
    }

    @ExceptionHandler(value={NoHandlerFoundException.class})
    @ResponseStatus(value=HttpStatus.NOT_FOUND)
    @ResponseBody
    public ErrorMessage notFound(NoHandlerFoundException e) {
        log.error(e.getLocalizedMessage());
        return new ErrorMessage("\u8bf7\u6c42\u8d44\u6e90\u4e0d\u5b58\u5728");
    }

    @ExceptionHandler(value={Throwable.class})
    @ResponseStatus(value=HttpStatus.INTERNAL_SERVER_ERROR)
    @ResponseBody
    public ErrorMessage throwable(Throwable e) {
        log.error(e.getLocalizedMessage());
        return new ErrorMessage("\u670d\u52a1\u5668\u672a\u77e5\u9519\u8bef");
    }

    @ExceptionHandler(value={BindException.class})
    @ResponseStatus(value=HttpStatus.BAD_REQUEST)
    public ErrorMessage bindFailedException(BindException e) {
        log.error(e.getMessage());
        ObjectError objectError = (ObjectError)e.getAllErrors().get(0);
        return new ErrorMessage(-2, objectError.getDefaultMessage());
    }

    @ExceptionHandler(value={RuntimeException.class})
    @ResponseStatus(value=HttpStatus.INTERNAL_SERVER_ERROR)
    @ResponseBody
    public ErrorMessage runtimeException(Throwable e) {
        log.error(e.getLocalizedMessage());
        return new ErrorMessage(e.getMessage());
    }
}

