/*
 * Decompiled with CFR 0.152.
 */
package com.eorion.bo.enhancement.processdraft.service;

import com.baomidou.mybatisplus.core.conditions.query.LambdaQueryWrapper;
import com.baomidou.mybatisplus.extension.plugins.pagination.Page;
import com.eorion.bo.enhancement.processdraft.adapter.outbound.ProcessDraftRepository;
import com.eorion.bo.enhancement.processdraft.domain.ProcessDraftStructureMapper;
import com.eorion.bo.enhancement.processdraft.domain.commom.PageInfo;
import com.eorion.bo.enhancement.processdraft.domain.dto.inbound.ProcessDraftQueryDTO;
import com.eorion.bo.enhancement.processdraft.domain.dto.inbound.ProcessDraftSaveDTO;
import com.eorion.bo.enhancement.processdraft.domain.dto.inbound.ProcessDraftUpdateDTO;
import com.eorion.bo.enhancement.processdraft.domain.dto.outbound.IdDTO;
import com.eorion.bo.enhancement.processdraft.domain.dto.outbound.ProcessDraftListDTO;
import com.eorion.bo.enhancement.processdraft.domain.entity.ProcessDraft;
import com.eorion.bo.enhancement.processdraft.domain.exception.DataNotExistException;
import com.eorion.bo.enhancement.processdraft.domain.exception.InsertFailedException;
import java.util.Objects;
import java.util.stream.Collectors;
import lombok.Generated;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.stereotype.Service;

@Service
public class ProcessDraftService {
    @Generated
    private static final Logger log = LoggerFactory.getLogger(ProcessDraftService.class);
    private final ProcessDraftRepository repository;
    private final ProcessDraftStructureMapper structureMapper;

    public IdDTO<Integer> saveProcessDraft(ProcessDraftSaveDTO saveDTO) throws InsertFailedException {
        ProcessDraft applicationDraft = this.structureMapper.saveDtoToEntity(saveDTO);
        applicationDraft.setFormDraft(saveDTO.getFormDraft());
        try {
            this.repository.save(applicationDraft);
        }
        catch (Exception e) {
            log.error("save applicationDraft error: {}", (Object)e.getMessage());
            throw new InsertFailedException("\u4fdd\u5b58\u5931\u8d25\uff01");
        }
        return new IdDTO<Integer>(applicationDraft.getId());
    }

    public void updatedProcessDraft(Integer id, ProcessDraftUpdateDTO updateDTO) throws DataNotExistException {
        if (!Objects.nonNull(this.repository.getById(id))) {
            throw new DataNotExistException("\u5bf9\u5e94\u7684\u8d44\u6e90\u4e0d\u5b58\u5728");
        }
        ProcessDraft applicationDraft = this.structureMapper.updateDtoToEntity(updateDTO);
        applicationDraft.setFormDraft(updateDTO.getFormDraft());
        applicationDraft.setId(id);
        this.repository.updateById(applicationDraft);
    }

    public void deleteProcessDraft(Integer id) {
        this.repository.removeById(id);
    }

    public PageInfo<ProcessDraftListDTO> getProcessDraftPageList(Integer firstResult, Integer maxResults, ProcessDraftQueryDTO queryDTO) {
        LambdaQueryWrapper queryWrapper = new LambdaQueryWrapper();
        Page page = new Page((long)firstResult.intValue(), (long)maxResults.intValue());
        if (Objects.nonNull(queryDTO)) {
            ((LambdaQueryWrapper)((LambdaQueryWrapper)((LambdaQueryWrapper)((LambdaQueryWrapper)((LambdaQueryWrapper)((LambdaQueryWrapper)((LambdaQueryWrapper)((LambdaQueryWrapper)((LambdaQueryWrapper)queryWrapper.eq(StringUtils.isNotEmpty((CharSequence)queryDTO.getTenant()), ProcessDraft::getTenant, (Object)queryDTO.getTenant())).eq(StringUtils.isNotEmpty((CharSequence)queryDTO.getUserId()), ProcessDraft::getUserId, (Object)queryDTO.getUserId())).eq(Objects.nonNull((Object)queryDTO.getType()), ProcessDraft::getType, (Object)queryDTO.getType())).eq(Objects.nonNull((Object)queryDTO.getResourceType()), ProcessDraft::getResourceType, (Object)queryDTO.getResourceType())).eq(StringUtils.isNotEmpty((CharSequence)queryDTO.getProcessDefinitionKey()), ProcessDraft::getProcessDefinitionKey, (Object)queryDTO.getProcessDefinitionKey())).like(StringUtils.isNotEmpty((CharSequence)queryDTO.getProcessDefinitionNameLike()), ProcessDraft::getProcessDefinitionName, (Object)queryDTO.getProcessDefinitionNameLike())).like(StringUtils.isNotEmpty((CharSequence)queryDTO.getTaskDefinitionNameLike()), ProcessDraft::getTaskDefinitionName, (Object)queryDTO.getTaskDefinitionNameLike())).like(StringUtils.isNotEmpty((CharSequence)queryDTO.getDraftNameLike()), ProcessDraft::getDraftName, (Object)queryDTO.getDraftNameLike())).eq(StringUtils.isNotEmpty((CharSequence)queryDTO.getTaskDefinitionKey()), ProcessDraft::getTaskDefinitionKey, (Object)queryDTO.getTaskDefinitionKey())).eq(StringUtils.isNotEmpty((CharSequence)queryDTO.getTaskInstanceId()), ProcessDraft::getTaskInstanceId, (Object)queryDTO.getTaskInstanceId());
            queryWrapper.and(StringUtils.isNotEmpty((CharSequence)queryDTO.getResourceNameLike()), wrapper -> ((LambdaQueryWrapper)((LambdaQueryWrapper)((LambdaQueryWrapper)((LambdaQueryWrapper)wrapper.like(ProcessDraft::getProcessDefinitionName, (Object)queryDTO.getResourceNameLike())).or()).like(ProcessDraft::getTaskDefinitionName, (Object)queryDTO.getResourceNameLike())).or()).like(ProcessDraft::getDraftName, (Object)queryDTO.getResourceNameLike()));
            if (StringUtils.isNotEmpty((CharSequence)queryDTO.getSort()) && "asc".equals(queryDTO.getSort())) {
                queryWrapper.orderByAsc(ProcessDraft::getCreatedTs);
            } else {
                queryWrapper.orderByDesc(ProcessDraft::getCreatedTs);
            }
        }
        Page<ProcessDraft> draftPage = this.repository.selectPageList((Page<ProcessDraft>)page, (LambdaQueryWrapper<ProcessDraft>)queryWrapper);
        return new PageInfo<ProcessDraftListDTO>(draftPage.getTotal(), draftPage.getRecords().stream().map(this.structureMapper::entityToListDto).collect(Collectors.toList()));
    }

    @Generated
    public ProcessDraftService(ProcessDraftRepository repository, ProcessDraftStructureMapper structureMapper) {
        this.repository = repository;
        this.structureMapper = structureMapper;
    }
}

