/*
 * Decompiled with CFR 0.152.
 */
package com.eorion.bo.enhancement.usersetting.service;

import com.baomidou.mybatisplus.core.conditions.Wrapper;
import com.baomidou.mybatisplus.core.conditions.query.LambdaQueryWrapper;
import com.eorion.bo.enhancement.usersetting.adapter.outbound.UserSettingRepository;
import com.eorion.bo.enhancement.usersetting.domain.dto.inbound.UserSettingSaveDTO;
import com.eorion.bo.enhancement.usersetting.domain.dto.outbound.IdDTO;
import com.eorion.bo.enhancement.usersetting.domain.dto.outbound.UserSettingDTO;
import com.eorion.bo.enhancement.usersetting.domain.entity.UserSetting;
import com.eorion.bo.enhancement.usersetting.domain.exception.InsertFailedException;
import com.eorion.bo.enhancement.usersetting.domain.exception.UpdateFailedException;
import java.util.Objects;
import lombok.Generated;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.http.HttpStatus;
import org.springframework.http.HttpStatusCode;
import org.springframework.http.ResponseEntity;
import org.springframework.stereotype.Service;

@Service
public class UserSettingService {
    @Generated
    private static final Logger log = LoggerFactory.getLogger(UserSettingService.class);
    private final UserSettingRepository repository;

    public ResponseEntity<UserSettingDTO> getByUserId(String userId) {
        UserSetting userSetting = (UserSetting)this.repository.getOne((Wrapper)new LambdaQueryWrapper().eq(UserSetting::getUserId, (Object)userId));
        if (Objects.nonNull(userSetting)) {
            return ResponseEntity.ok((Object)UserSettingDTO.fromEntity(userSetting));
        }
        return ResponseEntity.status((HttpStatusCode)HttpStatus.NOT_FOUND).build();
    }

    public ResponseEntity<?> saveOrUpdate(UserSettingSaveDTO saveDto) throws UpdateFailedException, InsertFailedException {
        UserSetting dbSetting = (UserSetting)this.repository.getOne((Wrapper)new LambdaQueryWrapper().eq(UserSetting::getUserId, (Object)saveDto.getUserId()));
        IdDTO<Integer> idDTO = new IdDTO<Integer>();
        if (dbSetting != null) {
            try {
                this.repository.updateByUserId(saveDto);
                idDTO.setId(dbSetting.getId());
            }
            catch (RuntimeException e) {
                log.error("update setting error: {}", (Object)e.getMessage());
                throw new UpdateFailedException("\u66f4\u65b0\u5931\u8d25\uff01");
            }
        }
        try {
            this.repository.saveUserSetting(saveDto);
            idDTO.setId(saveDto.getId());
        }
        catch (RuntimeException e) {
            log.error("save setting error {}", (Object)e.getMessage());
            throw new InsertFailedException("\u4fdd\u5b58\u5931\u8d25\uff01");
        }
        return ResponseEntity.ok(idDTO);
    }

    @Generated
    public UserSettingService(UserSettingRepository repository) {
        this.repository = repository;
    }
}

