/*
 * Decompiled with CFR 0.152.
 */
package com.epages.restdocs.apispec.jsonschema;

import com.epages.restdocs.apispec.jsonschema.JsonSchemaFromFieldDescriptorsGenerator;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.ListIterator;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import kotlin.Metadata;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.text.Regex;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={1, 7, 1}, k=1, xi=48, d1={"\u0000\u001c\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0010 \n\u0002\u0010\u000e\n\u0000\n\u0002\u0018\u0002\n\u0002\b\b\b\u0000\u0018\u0000 \r2\u00020\u0001:\u0001\rB\u001d\b\u0002\u0012\f\u0010\u0002\u001a\b\u0012\u0004\u0012\u00020\u00040\u0003\u0012\u0006\u0010\u0005\u001a\u00020\u0006\u00a2\u0006\u0002\u0010\u0007J\u001a\u0010\n\u001a\b\u0012\u0004\u0012\u00020\u00040\u00032\f\u0010\u000b\u001a\b\u0012\u0004\u0012\u00020\u00040\u0003J\b\u0010\f\u001a\u00020\u0004H\u0016R\u0011\u0010\u0005\u001a\u00020\u0006\u00a2\u0006\b\n\u0000\u001a\u0004\b\b\u0010\tR\u0014\u0010\u0002\u001a\b\u0012\u0004\u0012\u00020\u00040\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u000e"}, d2={"Lcom/epages/restdocs/apispec/jsonschema/JsonFieldPath;", "", "segments", "", "", "fieldDescriptor", "Lcom/epages/restdocs/apispec/jsonschema/JsonSchemaFromFieldDescriptorsGenerator$FieldDescriptorWithSchemaType;", "(Ljava/util/List;Lcom/epages/restdocs/apispec/jsonschema/JsonSchemaFromFieldDescriptorsGenerator$FieldDescriptorWithSchemaType;)V", "getFieldDescriptor", "()Lcom/epages/restdocs/apispec/jsonschema/JsonSchemaFromFieldDescriptorsGenerator$FieldDescriptorWithSchemaType;", "remainingSegments", "traversedSegments", "toString", "Companion", "restdocs-api-spec-jsonschema"})
public final class JsonFieldPath {
    @NotNull
    public static final Companion Companion = new Companion(null);
    @NotNull
    private final List<String> segments;
    @NotNull
    private final JsonSchemaFromFieldDescriptorsGenerator.FieldDescriptorWithSchemaType fieldDescriptor;
    private static final Pattern BRACKETS_AND_ARRAY_PATTERN = Pattern.compile("\\['(.+?)'\\]|\\[([0-9]+|\\*){0,1}\\]");
    private static final Pattern ARRAY_INDEX_PATTERN = Pattern.compile("\\[([0-9]+|\\*){0,1}\\]");

    private JsonFieldPath(List<String> segments, JsonSchemaFromFieldDescriptorsGenerator.FieldDescriptorWithSchemaType fieldDescriptor) {
        this.segments = segments;
        this.fieldDescriptor = fieldDescriptor;
    }

    @NotNull
    public final JsonSchemaFromFieldDescriptorsGenerator.FieldDescriptorWithSchemaType getFieldDescriptor() {
        return this.fieldDescriptor;
    }

    @NotNull
    public final List<String> remainingSegments(@NotNull List<String> traversedSegments) {
        Intrinsics.checkNotNullParameter(traversedSegments, (String)"traversedSegments");
        List result = new ArrayList();
        int i = 0;
        int n = this.segments.size();
        if (i <= n) {
            while (true) {
                if (traversedSegments.size() <= i || !Intrinsics.areEqual((Object)traversedSegments.get(i), (Object)this.segments.get(i))) {
                    return this.segments.subList(i, this.segments.size());
                }
                if (i == n) break;
                ++i;
            }
        }
        return result;
    }

    @NotNull
    public String toString() {
        return this.fieldDescriptor.getPath();
    }

    public /* synthetic */ JsonFieldPath(List segments, JsonSchemaFromFieldDescriptorsGenerator.FieldDescriptorWithSchemaType fieldDescriptor, DefaultConstructorMarker $constructor_marker) {
        this(segments, fieldDescriptor);
    }

    @Metadata(mv={1, 7, 1}, k=1, xi=48, d1={"\u00004\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010 \n\u0002\u0010\u000e\n\u0002\b\u0003\n\u0002\u0010\u000b\n\u0002\b\u0002\b\u0086\u0003\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002J\u000e\u0010\u0007\u001a\u00020\b2\u0006\u0010\t\u001a\u00020\nJ\u0016\u0010\u000b\u001a\b\u0012\u0004\u0012\u00020\r0\f2\u0006\u0010\u000e\u001a\u00020\rH\u0002J\u0016\u0010\u000f\u001a\b\u0012\u0004\u0012\u00020\r0\f2\u0006\u0010\u000e\u001a\u00020\rH\u0002J\u000e\u0010\u0010\u001a\u00020\u00112\u0006\u0010\u0012\u001a\u00020\rR\u0016\u0010\u0003\u001a\n \u0005*\u0004\u0018\u00010\u00040\u0004X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0016\u0010\u0006\u001a\n \u0005*\u0004\u0018\u00010\u00040\u0004X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0013"}, d2={"Lcom/epages/restdocs/apispec/jsonschema/JsonFieldPath$Companion;", "", "()V", "ARRAY_INDEX_PATTERN", "Ljava/util/regex/Pattern;", "kotlin.jvm.PlatformType", "BRACKETS_AND_ARRAY_PATTERN", "compile", "Lcom/epages/restdocs/apispec/jsonschema/JsonFieldPath;", "descriptor", "Lcom/epages/restdocs/apispec/jsonschema/JsonSchemaFromFieldDescriptorsGenerator$FieldDescriptorWithSchemaType;", "extractDotSeparatedSegments", "", "", "path", "extractSegments", "isArraySegment", "", "segment", "restdocs-api-spec-jsonschema"})
    public static final class Companion {
        private Companion() {
        }

        @NotNull
        public final JsonFieldPath compile(@NotNull JsonSchemaFromFieldDescriptorsGenerator.FieldDescriptorWithSchemaType descriptor) {
            Intrinsics.checkNotNullParameter((Object)((Object)descriptor), (String)"descriptor");
            List<String> segments = this.extractSegments(descriptor.getPath());
            return new JsonFieldPath(segments, descriptor, null);
        }

        public final boolean isArraySegment(@NotNull String segment) {
            Intrinsics.checkNotNullParameter((Object)segment, (String)"segment");
            return ARRAY_INDEX_PATTERN.matcher(segment).find();
        }

        private final List<String> extractSegments(String path) {
            Matcher matcher = BRACKETS_AND_ARRAY_PATTERN.matcher(path);
            int previous = 0;
            ArrayList<String> segments = new ArrayList<String>();
            while (matcher.find()) {
                if (previous != matcher.start()) {
                    String string = path.substring(previous, matcher.start());
                    Intrinsics.checkNotNullExpressionValue((Object)string, (String)"this as java.lang.String\u2026ing(startIndex, endIndex)");
                    segments.addAll((Collection)this.extractDotSeparatedSegments(string));
                }
                if (matcher.group(1) != null) {
                    segments.add(matcher.group(1));
                } else {
                    segments.add(matcher.group());
                }
                previous = matcher.end(0);
            }
            if (previous < path.length()) {
                String string = path.substring(previous);
                Intrinsics.checkNotNullExpressionValue((Object)string, (String)"this as java.lang.String).substring(startIndex)");
                segments.addAll((Collection)this.extractDotSeparatedSegments(string));
            }
            return segments;
        }

        /*
         * WARNING - void declaration
         */
        private final List<String> extractDotSeparatedSegments(String path) {
            List list;
            void $this$dropLastWhile$iv;
            List segments = new ArrayList();
            Object object = path;
            Regex regex = new Regex("\\.");
            int n = 0;
            object = regex.split((CharSequence)object, n);
            boolean $i$f$dropLastWhile = false;
            if (!$this$dropLastWhile$iv.isEmpty()) {
                ListIterator iterator$iv = $this$dropLastWhile$iv.listIterator($this$dropLastWhile$iv.size());
                while (iterator$iv.hasPrevious()) {
                    String it = (String)iterator$iv.previous();
                    boolean bl = false;
                    if (((CharSequence)it).length() == 0) continue;
                    list = CollectionsKt.take((Iterable)((Iterable)$this$dropLastWhile$iv), (int)(iterator$iv.nextIndex() + 1));
                    break;
                }
            } else {
                list = CollectionsKt.emptyList();
            }
            for (String segment : list) {
                if (!(((CharSequence)segment).length() > 0)) continue;
                segments.add(segment);
            }
            return segments;
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

