/*
 * Decompiled with CFR 0.152.
 */
package com.epages.restdocs.apispec.openapi3;

import io.swagger.v3.core.util.Json;
import io.swagger.v3.core.util.Yaml;
import io.swagger.v3.oas.models.OpenAPI;
import java.util.Set;
import kotlin.Metadata;
import kotlin.collections.SetsKt;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={1, 4, 1}, bv={1, 0, 3}, k=1, d1={"\u0000&\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0010\"\n\u0002\u0010\u000e\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u0002\n\u0000\b\u00c0\u0002\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002J\u0016\u0010\u0007\u001a\u00020\u00052\u0006\u0010\b\u001a\u00020\u00052\u0006\u0010\t\u001a\u00020\nJ\f\u0010\u000b\u001a\b\u0012\u0004\u0012\u00020\u00050\u0004J\u000e\u0010\f\u001a\u00020\r2\u0006\u0010\b\u001a\u00020\u0005R\u0014\u0010\u0003\u001a\b\u0012\u0004\u0012\u00020\u00050\u0004X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0014\u0010\u0006\u001a\b\u0012\u0004\u0012\u00020\u00050\u0004X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u000e"}, d2={"Lcom/epages/restdocs/apispec/openapi3/ApiSpecificationWriter;", "", "()V", "jsonFormats", "", "", "yamlFormats", "serialize", "format", "openApi", "Lio/swagger/v3/oas/models/OpenAPI;", "supportedFormats", "validateFormat", "", "restdocs-api-spec-openapi3-generator"})
public final class ApiSpecificationWriter {
    private static final Set<String> yamlFormats;
    private static final Set<String> jsonFormats;
    @NotNull
    public static final ApiSpecificationWriter INSTANCE;

    @NotNull
    public final String serialize(@NotNull String format, @NotNull OpenAPI openApi) {
        String string;
        Intrinsics.checkNotNullParameter((Object)format, (String)"format");
        Intrinsics.checkNotNullParameter((Object)openApi, (String)"openApi");
        this.validateFormat(format);
        if (yamlFormats.contains(format)) {
            String string2 = Yaml.pretty().writeValueAsString((Object)openApi);
            string = string2;
            Intrinsics.checkNotNullExpressionValue((Object)string2, (String)"Yaml.pretty().writeValueAsString(openApi)");
        } else {
            String string3 = Json.pretty().writeValueAsString((Object)openApi);
            string = string3;
            Intrinsics.checkNotNullExpressionValue((Object)string3, (String)"Json.pretty().writeValueAsString(openApi)");
        }
        return string;
    }

    @NotNull
    public final Set<String> supportedFormats() {
        return SetsKt.plus(yamlFormats, (Iterable)jsonFormats);
    }

    public final void validateFormat(@NotNull String format) {
        Intrinsics.checkNotNullParameter((Object)format, (String)"format");
        if (!this.supportedFormats().contains(format)) {
            throw (Throwable)new IllegalArgumentException("Format '" + format + "' is invalid - supported formats are '" + this.supportedFormats() + '\'');
        }
    }

    private ApiSpecificationWriter() {
    }

    static {
        ApiSpecificationWriter apiSpecificationWriter;
        INSTANCE = apiSpecificationWriter = new ApiSpecificationWriter();
        yamlFormats = SetsKt.setOf((Object[])new String[]{"yaml", "yml"});
        jsonFormats = SetsKt.setOf((Object)"json");
    }
}

