/*
 * Decompiled with CFR 0.152.
 */
package com.epages.restdocs.apispec.openapi3;

import com.epages.restdocs.apispec.model.Oauth2Configuration;
import com.epages.restdocs.apispec.model.SecurityRequirements;
import com.epages.restdocs.apispec.model.SecurityType;
import com.epages.restdocs.apispec.openapi3.SecuritySchemeGenerator$WhenMappings;
import io.swagger.v3.oas.models.Components;
import io.swagger.v3.oas.models.OpenAPI;
import io.swagger.v3.oas.models.Operation;
import io.swagger.v3.oas.models.PathItem;
import io.swagger.v3.oas.models.Paths;
import io.swagger.v3.oas.models.security.OAuthFlow;
import io.swagger.v3.oas.models.security.OAuthFlows;
import io.swagger.v3.oas.models.security.Scopes;
import io.swagger.v3.oas.models.security.SecurityRequirement;
import io.swagger.v3.oas.models.security.SecurityScheme;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import kotlin.Metadata;
import kotlin.Unit;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.internal.Intrinsics;
import kotlin.text.StringsKt;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 4, 1}, bv={1, 0, 3}, k=1, d1={"\u0000R\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0010\u000e\n\u0002\b\u0003\n\u0002\u0010\u000b\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010 \n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\"\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010$\n\u0000\b\u00c0\u0002\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002J\u0018\u0010\u0007\u001a\u00020\b2\u0006\u0010\t\u001a\u00020\n2\u0006\u0010\u000b\u001a\u00020\u0004H\u0002J\u0016\u0010\f\u001a\b\u0012\u0004\u0012\u00020\u00040\r2\u0006\u0010\u000e\u001a\u00020\u000fH\u0002J\u0014\u0010\u0010\u001a\u00020\u0011*\u00020\n2\b\u0010\u0012\u001a\u0004\u0018\u00010\u0013J\u001e\u0010\u0014\u001a\u00020\u0011*\u00020\u00152\b\u0010\u000e\u001a\u0004\u0018\u00010\u000f2\b\u0010\u0012\u001a\u0004\u0018\u00010\u0013J\u0012\u0010\u0016\u001a\b\u0012\u0004\u0012\u00020\u00040\u0017*\u00020\nH\u0002J.\u0010\u0018\u001a\u00020\u0019*\u00020\u00192\f\u0010\u0018\u001a\b\u0012\u0004\u0012\u00020\u00040\u00172\u0012\u0010\u001a\u001a\u000e\u0012\u0004\u0012\u00020\u0004\u0012\u0004\u0012\u00020\u00040\u001bH\u0002R\u000e\u0010\u0003\u001a\u00020\u0004X\u0082T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0005\u001a\u00020\u0004X\u0082T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0006\u001a\u00020\u0004X\u0082T\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u001c"}, d2={"Lcom/epages/restdocs/apispec/openapi3/SecuritySchemeGenerator;", "", "()V", "API_KEY_SECURITY_NAME", "", "BASIC_SECURITY_NAME", "JWT_BEARER_SECURITY_NAME", "hasAnyOperationWithSecurityName", "", "openApi", "Lio/swagger/v3/oas/models/OpenAPI;", "name", "securityRequirements2ScopesList", "", "securityRequirements", "Lcom/epages/restdocs/apispec/model/SecurityRequirements;", "addSecurityDefinitions", "", "oauth2SecuritySchemeDefinition", "Lcom/epages/restdocs/apispec/model/Oauth2Configuration;", "addSecurityItemFromSecurityRequirements", "Lio/swagger/v3/oas/models/Operation;", "collectScopesFromOperations", "", "scopes", "Lio/swagger/v3/oas/models/security/OAuthFlow;", "scopeAndDescriptions", "", "restdocs-api-spec-openapi3-generator"})
public final class SecuritySchemeGenerator {
    private static final String API_KEY_SECURITY_NAME = "api_key";
    private static final String BASIC_SECURITY_NAME = "basic";
    private static final String JWT_BEARER_SECURITY_NAME = "bearerAuthJWT";
    @NotNull
    public static final SecuritySchemeGenerator INSTANCE;

    /*
     * WARNING - void declaration
     */
    public final void addSecurityDefinitions(@NotNull OpenAPI $this$addSecurityDefinitions, @Nullable Oauth2Configuration oauth2SecuritySchemeDefinition) {
        Unit unit;
        Components components;
        String string;
        boolean bl;
        SecurityScheme securityScheme;
        Intrinsics.checkNotNullParameter((Object)$this$addSecurityDefinitions, (String)"$this$addSecurityDefinitions");
        SecurityScheme securityScheme2 = oauth2SecuritySchemeDefinition;
        if (securityScheme2 != null && (securityScheme2 = securityScheme2.getFlows()) != null) {
            securityScheme = securityScheme2;
            bl = false;
            SecurityScheme securityScheme3 = securityScheme;
            boolean bl2 = false;
            if (!(((String[])securityScheme3).length == 0)) {
                void $this$apply22;
                OAuthFlows flows = new OAuthFlows();
                SecurityScheme securityScheme4 = new SecurityScheme();
                boolean bl3 = false;
                bl2 = false;
                SecurityScheme securityScheme5 = securityScheme4;
                string = "oauth2";
                components = $this$addSecurityDefinitions.getComponents();
                boolean bl4 = false;
                $this$apply22.setType(SecurityScheme.Type.OAUTH2);
                $this$apply22.setFlows(flows);
                unit = Unit.INSTANCE;
                components.addSecuritySchemes(string, securityScheme4);
                String[] $this$forEach$iv = oauth2SecuritySchemeDefinition.getFlows();
                boolean $i$f$forEach = false;
                String[] stringArray = $this$forEach$iv;
                int $this$apply22 = stringArray.length;
                for (int i = 0; i < $this$apply22; ++i) {
                    String element$iv;
                    String flow = element$iv = stringArray[i];
                    boolean bl5 = false;
                    Map scopeAndDescriptions = oauth2SecuritySchemeDefinition.getScopes();
                    Set<String> allScopes = INSTANCE.collectScopesFromOperations($this$addSecurityDefinitions);
                    switch (flow) {
                        case "authorizationCode": {
                            OAuthFlow oAuthFlow = new OAuthFlow().authorizationUrl(oauth2SecuritySchemeDefinition.getAuthorizationUrl()).tokenUrl(oauth2SecuritySchemeDefinition.getTokenUrl());
                            Intrinsics.checkNotNullExpressionValue((Object)oAuthFlow, (String)"OAuthFlow()\n            \u2026chemeDefinition.tokenUrl)");
                            flows.authorizationCode(INSTANCE.scopes(oAuthFlow, allScopes, scopeAndDescriptions));
                            break;
                        }
                        case "clientCredentials": {
                            OAuthFlow oAuthFlow = new OAuthFlow().tokenUrl(oauth2SecuritySchemeDefinition.getTokenUrl());
                            Intrinsics.checkNotNullExpressionValue((Object)oAuthFlow, (String)"OAuthFlow()\n            \u2026chemeDefinition.tokenUrl)");
                            flows.clientCredentials(INSTANCE.scopes(oAuthFlow, allScopes, scopeAndDescriptions));
                            break;
                        }
                        case "password": {
                            OAuthFlow oAuthFlow = new OAuthFlow().tokenUrl(oauth2SecuritySchemeDefinition.getTokenUrl());
                            Intrinsics.checkNotNullExpressionValue((Object)oAuthFlow, (String)"OAuthFlow()\n            \u2026chemeDefinition.tokenUrl)");
                            flows.password(INSTANCE.scopes(oAuthFlow, allScopes, scopeAndDescriptions));
                            break;
                        }
                        case "implicit": {
                            OAuthFlow oAuthFlow = new OAuthFlow().authorizationUrl(oauth2SecuritySchemeDefinition.getAuthorizationUrl());
                            Intrinsics.checkNotNullExpressionValue((Object)oAuthFlow, (String)"OAuthFlow()\n            \u2026inition.authorizationUrl)");
                            flows.implicit(INSTANCE.scopes(oAuthFlow, allScopes, scopeAndDescriptions));
                            break;
                        }
                        default: {
                            throw (Throwable)new IllegalArgumentException("Unknown flow '" + flow + "' in oauth2SecuritySchemeDefinition");
                        }
                    }
                }
            }
        }
        if (this.hasAnyOperationWithSecurityName($this$addSecurityDefinitions, BASIC_SECURITY_NAME)) {
            void $this$apply;
            securityScheme = new SecurityScheme();
            bl = false;
            boolean bl6 = false;
            SecurityScheme securityScheme6 = securityScheme;
            string = BASIC_SECURITY_NAME;
            components = $this$addSecurityDefinitions.getComponents();
            boolean bl7 = false;
            $this$apply.setType(SecurityScheme.Type.HTTP);
            $this$apply.setScheme(BASIC_SECURITY_NAME);
            unit = Unit.INSTANCE;
            components.addSecuritySchemes(string, securityScheme);
        }
        if (this.hasAnyOperationWithSecurityName($this$addSecurityDefinitions, API_KEY_SECURITY_NAME)) {
            securityScheme = new SecurityScheme();
            bl = false;
            boolean bl8 = false;
            SecurityScheme $this$apply = securityScheme;
            string = API_KEY_SECURITY_NAME;
            components = $this$addSecurityDefinitions.getComponents();
            boolean bl9 = false;
            $this$apply.setType(SecurityScheme.Type.APIKEY);
            $this$apply.setIn(SecurityScheme.In.HEADER);
            $this$apply.setName("Authorization");
            unit = Unit.INSTANCE;
            components.addSecuritySchemes(string, securityScheme);
        }
        if (this.hasAnyOperationWithSecurityName($this$addSecurityDefinitions, JWT_BEARER_SECURITY_NAME)) {
            securityScheme = new SecurityScheme();
            bl = false;
            boolean bl10 = false;
            SecurityScheme $this$apply = securityScheme;
            string = JWT_BEARER_SECURITY_NAME;
            components = $this$addSecurityDefinitions.getComponents();
            boolean bl11 = false;
            $this$apply.setType(SecurityScheme.Type.HTTP);
            $this$apply.setScheme("bearer");
            $this$apply.setBearerFormat("JWT");
            unit = Unit.INSTANCE;
            components.addSecuritySchemes(string, securityScheme);
        }
    }

    /*
     * WARNING - void declaration
     */
    public final void addSecurityItemFromSecurityRequirements(@NotNull Operation $this$addSecurityItemFromSecurityRequirements, @Nullable SecurityRequirements securityRequirements, @Nullable Oauth2Configuration oauth2SecuritySchemeDefinition) {
        Intrinsics.checkNotNullParameter((Object)$this$addSecurityItemFromSecurityRequirements, (String)"$this$addSecurityItemFromSecurityRequirements");
        if (securityRequirements != null) {
            switch (SecuritySchemeGenerator$WhenMappings.$EnumSwitchMapping$0[securityRequirements.getType().ordinal()]) {
                case 1: {
                    String[] stringArray = oauth2SecuritySchemeDefinition;
                    if (oauth2SecuritySchemeDefinition != null && (stringArray = stringArray.getFlows()) != null) {
                        void $this$mapTo$iv$iv;
                        String[] $this$map$iv = stringArray;
                        boolean $i$f$map = false;
                        String[] stringArray2 = $this$map$iv;
                        Collection destination$iv$iv = new ArrayList($this$map$iv.length);
                        boolean $i$f$mapTo = false;
                        void var9_9 = $this$mapTo$iv$iv;
                        int n = ((void)var9_9).length;
                        for (int i = 0; i < n; ++i) {
                            void it;
                            void item$iv$iv;
                            void var13_13 = item$iv$iv = var9_9[i];
                            Collection collection = destination$iv$iv;
                            boolean bl = false;
                            Operation operation = $this$addSecurityItemFromSecurityRequirements.addSecurityItem(new SecurityRequirement().addList(oauth2SecuritySchemeDefinition.securitySchemeName((String)it), INSTANCE.securityRequirements2ScopesList(securityRequirements)));
                            collection.add(operation);
                        }
                        List cfr_ignored_0 = (List)destination$iv$iv;
                    }
                    break;
                }
                case 2: {
                    $this$addSecurityItemFromSecurityRequirements.addSecurityItem(new SecurityRequirement().addList(BASIC_SECURITY_NAME));
                    break;
                }
                case 3: {
                    $this$addSecurityItemFromSecurityRequirements.addSecurityItem(new SecurityRequirement().addList(API_KEY_SECURITY_NAME));
                    break;
                }
                case 4: {
                    $this$addSecurityItemFromSecurityRequirements.addSecurityItem(new SecurityRequirement().addList(JWT_BEARER_SECURITY_NAME));
                    break;
                }
            }
        }
    }

    private final List<String> securityRequirements2ScopesList(SecurityRequirements securityRequirements) {
        List list;
        if (securityRequirements.getType() == SecurityType.OAUTH2 && securityRequirements.getRequiredScopes() != null) {
            List list2 = securityRequirements.getRequiredScopes();
            list = list2;
            Intrinsics.checkNotNull((Object)list2);
        } else {
            boolean bl = false;
            list = CollectionsKt.emptyList();
        }
        return list;
    }

    private final OAuthFlow scopes(OAuthFlow $this$scopes, Set<String> scopes, Map<String, String> scopeAndDescriptions) {
        Scopes scopes2 = new Scopes();
        boolean bl = false;
        boolean bl2 = false;
        Scopes $this$apply = scopes2;
        boolean bl3 = false;
        Iterable $this$forEach$iv = scopes;
        boolean $i$f$forEach = false;
        for (Object element$iv : $this$forEach$iv) {
            String it = (String)element$iv;
            boolean bl4 = false;
            $this$apply.addString(it, scopeAndDescriptions.getOrDefault(it, "No description"));
        }
        bl = false;
        bl2 = false;
        Scopes it = scopes2;
        boolean bl5 = false;
        $this$scopes.scopes(it);
        bl = false;
        bl2 = false;
        it = scopes2;
        boolean bl6 = false;
        return $this$scopes;
    }

    private final boolean hasAnyOperationWithSecurityName(OpenAPI openApi, String name) {
        boolean bl;
        block7: {
            Iterable list$iv$iv;
            List it;
            Object $this$mapNotNullTo$iv$iv;
            Object $this$flatMapTo$iv$iv;
            Paths paths = openApi.getPaths();
            Intrinsics.checkNotNullExpressionValue((Object)paths, (String)"openApi.paths");
            Object $this$flatMap$iv = (Map)paths;
            boolean $i$f$flatMap = false;
            Object object = $this$flatMap$iv;
            Collection destination$iv$iv = new ArrayList();
            boolean $i$f$flatMapTo = false;
            void var8_9 = $this$flatMapTo$iv$iv;
            boolean bl2 = false;
            Iterator iterator = var8_9.entrySet().iterator();
            while (iterator.hasNext()) {
                Map.Entry element$iv$iv;
                Map.Entry it2 = element$iv$iv = iterator.next();
                boolean bl3 = false;
                Iterable list$iv$iv2 = ((PathItem)it2.getValue()).readOperations();
                CollectionsKt.addAll((Collection)destination$iv$iv, (Iterable)list$iv$iv2);
            }
            Iterable $this$mapNotNull$iv = (List)destination$iv$iv;
            boolean $i$f$mapNotNull = false;
            $this$flatMapTo$iv$iv = $this$mapNotNull$iv;
            destination$iv$iv = new ArrayList();
            boolean $i$f$mapNotNullTo = false;
            Iterator $this$forEach$iv$iv$iv = $this$mapNotNullTo$iv$iv;
            boolean $i$f$forEach = false;
            iterator = $this$forEach$iv$iv$iv.iterator();
            while (iterator.hasNext()) {
                List list;
                Map.Entry element$iv$iv$iv;
                Map.Entry element$iv$iv = element$iv$iv$iv = iterator.next();
                boolean bl4 = false;
                Operation it3 = (Operation)element$iv$iv;
                boolean bl5 = false;
                Operation operation = it3;
                Intrinsics.checkNotNullExpressionValue((Object)operation, (String)"it");
                if (operation.getSecurity() == null) continue;
                boolean bl6 = false;
                boolean bl7 = false;
                List it$iv$iv = list;
                boolean bl8 = false;
                destination$iv$iv.add(it$iv$iv);
            }
            $this$flatMap$iv = (List)destination$iv$iv;
            $i$f$flatMap = false;
            $this$mapNotNullTo$iv$iv = $this$flatMap$iv;
            destination$iv$iv = new ArrayList();
            $i$f$flatMapTo = false;
            $this$forEach$iv$iv$iv = $this$flatMapTo$iv$iv.iterator();
            while ($this$forEach$iv$iv$iv.hasNext()) {
                Object element$iv$iv = $this$forEach$iv$iv$iv.next();
                it = (List)element$iv$iv;
                boolean bl9 = false;
                list$iv$iv = it;
                CollectionsKt.addAll((Collection)destination$iv$iv, (Iterable)list$iv$iv);
            }
            $this$flatMap$iv = (List)destination$iv$iv;
            $i$f$flatMap = false;
            $this$flatMapTo$iv$iv = $this$flatMap$iv;
            destination$iv$iv = new ArrayList();
            $i$f$flatMapTo = false;
            $this$forEach$iv$iv$iv = $this$flatMapTo$iv$iv.iterator();
            while ($this$forEach$iv$iv$iv.hasNext()) {
                Object element$iv$iv = $this$forEach$iv$iv$iv.next();
                it = (SecurityRequirement)element$iv$iv;
                boolean bl10 = false;
                list$iv$iv = it.keySet();
                CollectionsKt.addAll((Collection)destination$iv$iv, (Iterable)list$iv$iv);
            }
            Iterable $this$any$iv = (List)destination$iv$iv;
            boolean $i$f$any = false;
            if ($this$any$iv instanceof Collection && ((Collection)$this$any$iv).isEmpty()) {
                bl = false;
            } else {
                for (Object element$iv : $this$any$iv) {
                    String it4 = (String)element$iv;
                    boolean bl11 = false;
                    if (!Intrinsics.areEqual((Object)it4, (Object)name)) continue;
                    bl = true;
                    break block7;
                }
                bl = false;
            }
        }
        return bl;
    }

    /*
     * WARNING - void declaration
     */
    private final Set<String> collectScopesFromOperations(OpenAPI $this$collectScopesFromOperations) {
        void $this$flatMapTo$iv$iv;
        Paths paths = $this$collectScopesFromOperations.getPaths();
        Intrinsics.checkNotNullExpressionValue((Object)paths, (String)"paths");
        Map $this$flatMap$iv = (Map)paths;
        boolean $i$f$flatMap = false;
        Map map = $this$flatMap$iv;
        Collection destination$iv$iv = new ArrayList();
        boolean $i$f$flatMapTo = false;
        void var7_7 = $this$flatMapTo$iv$iv;
        boolean bl = false;
        Iterator iterator = var7_7.entrySet().iterator();
        while (iterator.hasNext()) {
            void $this$flatMapTo$iv$iv2;
            Map.Entry element$iv$iv;
            Map.Entry path = element$iv$iv = iterator.next();
            boolean bl2 = false;
            List list = ((PathItem)path.getValue()).readOperations();
            Intrinsics.checkNotNullExpressionValue((Object)list, (String)"path.value.readOperations()");
            Iterable $this$flatMap$iv2 = list;
            boolean $i$f$flatMap2 = false;
            Iterable iterable = $this$flatMap$iv2;
            Collection destination$iv$iv2 = new ArrayList();
            boolean $i$f$flatMapTo2 = false;
            for (Object element$iv$iv2 : $this$flatMapTo$iv$iv2) {
                List list2;
                Operation operation = (Operation)element$iv$iv2;
                boolean bl3 = false;
                Object object = operation;
                if (object != null && (object = object.getSecurity()) != null) {
                    void $this$flatMapTo$iv$iv3;
                    Object it;
                    Object result$iv;
                    Iterable $this$filterTo$iv$iv;
                    Iterable $this$filter$iv = (Iterable)object;
                    boolean $i$f$filter = false;
                    Iterable iterable2 = $this$filter$iv;
                    Collection destination$iv$iv3 = new ArrayList();
                    boolean $i$f$filterTo = false;
                    for (Object element$iv$iv3 : $this$filterTo$iv$iv) {
                        SecurityRequirement s = (SecurityRequirement)element$iv$iv3;
                        boolean bl4 = false;
                        SecurityRequirement securityRequirement = s;
                        Intrinsics.checkNotNullExpressionValue((Object)securityRequirement, (String)"s");
                        Map $this$filterKeys$iv = (Map)securityRequirement;
                        boolean $i$f$filterKeys = false;
                        result$iv = new LinkedHashMap();
                        Map map2 = $this$filterKeys$iv;
                        boolean bl5 = false;
                        for (Map.Entry entry$iv : map2.entrySet()) {
                            it = (String)entry$iv.getKey();
                            boolean bl6 = false;
                            String string = it;
                            Intrinsics.checkNotNullExpressionValue((Object)string, (String)"it");
                            if (!StringsKt.startsWith$default((String)string, (String)"oauth2", (boolean)false, (int)2, null)) continue;
                            ((HashMap)result$iv).put(entry$iv.getKey(), entry$iv.getValue());
                        }
                        $this$filterKeys$iv = (Map)result$iv;
                        $i$f$filterKeys = false;
                        if (!(!$this$filterKeys$iv.isEmpty())) continue;
                        destination$iv$iv3.add(element$iv$iv3);
                    }
                    Iterable $this$flatMap$iv3 = (List)destination$iv$iv3;
                    boolean $i$f$flatMap3 = false;
                    $this$filterTo$iv$iv = $this$flatMap$iv3;
                    destination$iv$iv3 = new ArrayList();
                    boolean $i$f$flatMapTo3 = false;
                    for (Object element$iv$iv3 : $this$flatMapTo$iv$iv3) {
                        void $this$flatMapTo$iv$iv4;
                        SecurityRequirement oauthSecurity = (SecurityRequirement)element$iv$iv3;
                        boolean bl7 = false;
                        Collection collection = oauthSecurity.values();
                        Intrinsics.checkNotNullExpressionValue((Object)collection, (String)"oauthSecurity.values");
                        Iterable $this$flatMap$iv4 = collection;
                        boolean $i$f$flatMap4 = false;
                        result$iv = $this$flatMap$iv4;
                        Collection destination$iv$iv4 = new ArrayList();
                        boolean $i$f$flatMapTo4 = false;
                        for (Map.Entry element$iv$iv4 : $this$flatMapTo$iv$iv4) {
                            it = (List)((Object)element$iv$iv4);
                            boolean bl8 = false;
                            Iterable list$iv$iv = (Iterable)it;
                            CollectionsKt.addAll((Collection)destination$iv$iv4, (Iterable)list$iv$iv);
                        }
                        Iterable list$iv$iv = (List)destination$iv$iv4;
                        CollectionsKt.addAll((Collection)destination$iv$iv3, (Iterable)list$iv$iv);
                    }
                    list2 = (List)destination$iv$iv3;
                } else {
                    boolean bl9 = false;
                    list2 = CollectionsKt.emptyList();
                }
                Iterable list$iv$iv = list2;
                CollectionsKt.addAll((Collection)destination$iv$iv2, (Iterable)list$iv$iv);
            }
            Iterable list$iv$iv = (List)destination$iv$iv2;
            CollectionsKt.addAll((Collection)destination$iv$iv, (Iterable)list$iv$iv);
        }
        return CollectionsKt.toSet((Iterable)((List)destination$iv$iv));
    }

    private SecuritySchemeGenerator() {
    }

    static {
        SecuritySchemeGenerator securitySchemeGenerator;
        INSTANCE = securitySchemeGenerator = new SecuritySchemeGenerator();
    }
}

