/*
 * Decompiled with CFR 0.152.
 */
package com.epages.restdocs.apispec.openapi3;

import com.epages.restdocs.apispec.model.Oauth2Configuration;
import com.epages.restdocs.apispec.model.SecurityRequirements;
import com.epages.restdocs.apispec.model.SecurityType;
import io.swagger.v3.oas.models.Components;
import io.swagger.v3.oas.models.OpenAPI;
import io.swagger.v3.oas.models.Operation;
import io.swagger.v3.oas.models.PathItem;
import io.swagger.v3.oas.models.Paths;
import io.swagger.v3.oas.models.security.OAuthFlow;
import io.swagger.v3.oas.models.security.OAuthFlows;
import io.swagger.v3.oas.models.security.Scopes;
import io.swagger.v3.oas.models.security.SecurityRequirement;
import io.swagger.v3.oas.models.security.SecurityScheme;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import kotlin.Metadata;
import kotlin.Unit;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.internal.Intrinsics;
import kotlin.text.StringsKt;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 7, 1}, k=1, xi=48, d1={"\u0000R\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0010\u000e\n\u0002\b\u0004\n\u0002\u0010\u000b\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010 \n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\"\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010$\n\u0000\b\u00c0\u0002\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002J\u0018\u0010\b\u001a\u00020\t2\u0006\u0010\n\u001a\u00020\u000b2\u0006\u0010\f\u001a\u00020\u0004H\u0002J\u0016\u0010\r\u001a\b\u0012\u0004\u0012\u00020\u00040\u000e2\u0006\u0010\u000f\u001a\u00020\u0010H\u0002J\u0014\u0010\u0011\u001a\u00020\u0012*\u00020\u000b2\b\u0010\u0013\u001a\u0004\u0018\u00010\u0014J\u0014\u0010\u0015\u001a\u00020\u0012*\u00020\u00162\b\u0010\u000f\u001a\u0004\u0018\u00010\u0010J\u0012\u0010\u0017\u001a\b\u0012\u0004\u0012\u00020\u00040\u0018*\u00020\u000bH\u0002J.\u0010\u0019\u001a\u00020\u001a*\u00020\u001a2\f\u0010\u0019\u001a\b\u0012\u0004\u0012\u00020\u00040\u00182\u0012\u0010\u001b\u001a\u000e\u0012\u0004\u0012\u00020\u0004\u0012\u0004\u0012\u00020\u00040\u001cH\u0002R\u000e\u0010\u0003\u001a\u00020\u0004X\u0082T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0005\u001a\u00020\u0004X\u0082T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0006\u001a\u00020\u0004X\u0082T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0007\u001a\u00020\u0004X\u0082T\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u001d"}, d2={"Lcom/epages/restdocs/apispec/openapi3/SecuritySchemeGenerator;", "", "()V", "API_KEY_SECURITY_NAME", "", "BASIC_SECURITY_NAME", "JWT_BEARER_SECURITY_NAME", "OAUTH2_SECURITY_NAME", "hasAnyOperationWithSecurityName", "", "openApi", "Lio/swagger/v3/oas/models/OpenAPI;", "name", "securityRequirements2ScopesList", "", "securityRequirements", "Lcom/epages/restdocs/apispec/model/SecurityRequirements;", "addSecurityDefinitions", "", "oauth2SecuritySchemeDefinition", "Lcom/epages/restdocs/apispec/model/Oauth2Configuration;", "addSecurityItemFromSecurityRequirements", "Lio/swagger/v3/oas/models/Operation;", "collectScopesFromOperations", "", "scopes", "Lio/swagger/v3/oas/models/security/OAuthFlow;", "scopeAndDescriptions", "", "restdocs-api-spec-openapi3-generator"})
public final class SecuritySchemeGenerator {
    @NotNull
    public static final SecuritySchemeGenerator INSTANCE = new SecuritySchemeGenerator();
    @NotNull
    private static final String API_KEY_SECURITY_NAME = "api_key";
    @NotNull
    private static final String BASIC_SECURITY_NAME = "basic";
    @NotNull
    private static final String JWT_BEARER_SECURITY_NAME = "bearerAuthJWT";
    @NotNull
    private static final String OAUTH2_SECURITY_NAME = "oauth2";

    private SecuritySchemeGenerator() {
    }

    /*
     * WARNING - void declaration
     */
    public final void addSecurityDefinitions(@NotNull OpenAPI $this$addSecurityDefinitions, @Nullable Oauth2Configuration oauth2SecuritySchemeDefinition) {
        String[] $this$addSecurityDefinitions_u24lambda_u243;
        String[] $this$addSecurityDefinitions_u24lambda_u242;
        String[] stringArray;
        String[] $this$forEach$iv;
        Unit unit;
        Components components;
        String string;
        block20: {
            void $this$addSecurityDefinitions_u24lambda_u240;
            SecurityScheme securityScheme;
            Intrinsics.checkNotNullParameter((Object)$this$addSecurityDefinitions, (String)"<this>");
            String[] stringArray2 = oauth2SecuritySchemeDefinition;
            boolean bl = oauth2SecuritySchemeDefinition != null && (stringArray2 = stringArray2.getFlows()) != null ? !(stringArray2.length == 0) : false;
            if (!bl) break block20;
            OAuthFlows flows = new OAuthFlows();
            SecurityScheme securityScheme2 = securityScheme = new SecurityScheme();
            string = OAUTH2_SECURITY_NAME;
            components = $this$addSecurityDefinitions.getComponents();
            boolean bl2 = false;
            $this$addSecurityDefinitions_u24lambda_u240.setType(SecurityScheme.Type.OAUTH2);
            $this$addSecurityDefinitions_u24lambda_u240.setFlows(flows);
            unit = Unit.INSTANCE;
            components.addSecuritySchemes(string, securityScheme);
            $this$forEach$iv = oauth2SecuritySchemeDefinition.getFlows();
            boolean $i$f$forEach = false;
            int n = $this$forEach$iv.length;
            for (int i = 0; i < n; ++i) {
                String element$iv;
                String flow = element$iv = $this$forEach$iv[i];
                boolean bl3 = false;
                Map scopeAndDescriptions = oauth2SecuritySchemeDefinition.getScopes();
                Set<String> allScopes = INSTANCE.collectScopesFromOperations($this$addSecurityDefinitions);
                switch (flow) {
                    case "authorizationCode": {
                        OAuthFlow oAuthFlow = new OAuthFlow().authorizationUrl(oauth2SecuritySchemeDefinition.getAuthorizationUrl()).tokenUrl(oauth2SecuritySchemeDefinition.getTokenUrl());
                        Intrinsics.checkNotNullExpressionValue((Object)oAuthFlow, (String)"OAuthFlow()\n            \u2026chemeDefinition.tokenUrl)");
                        flows.authorizationCode(INSTANCE.scopes(oAuthFlow, allScopes, scopeAndDescriptions));
                        break;
                    }
                    case "clientCredentials": {
                        OAuthFlow oAuthFlow = new OAuthFlow().tokenUrl(oauth2SecuritySchemeDefinition.getTokenUrl());
                        Intrinsics.checkNotNullExpressionValue((Object)oAuthFlow, (String)"OAuthFlow()\n            \u2026chemeDefinition.tokenUrl)");
                        flows.clientCredentials(INSTANCE.scopes(oAuthFlow, allScopes, scopeAndDescriptions));
                        break;
                    }
                    case "password": {
                        OAuthFlow oAuthFlow = new OAuthFlow().tokenUrl(oauth2SecuritySchemeDefinition.getTokenUrl());
                        Intrinsics.checkNotNullExpressionValue((Object)oAuthFlow, (String)"OAuthFlow()\n            \u2026chemeDefinition.tokenUrl)");
                        flows.password(INSTANCE.scopes(oAuthFlow, allScopes, scopeAndDescriptions));
                        break;
                    }
                    case "implicit": {
                        OAuthFlow oAuthFlow = new OAuthFlow().authorizationUrl(oauth2SecuritySchemeDefinition.getAuthorizationUrl());
                        Intrinsics.checkNotNullExpressionValue((Object)oAuthFlow, (String)"OAuthFlow()\n            \u2026inition.authorizationUrl)");
                        flows.implicit(INSTANCE.scopes(oAuthFlow, allScopes, scopeAndDescriptions));
                        break;
                    }
                    default: {
                        throw new IllegalArgumentException("Unknown flow '" + flow + "' in oauth2SecuritySchemeDefinition");
                    }
                }
            }
        }
        if (this.hasAnyOperationWithSecurityName($this$addSecurityDefinitions, BASIC_SECURITY_NAME)) {
            $this$forEach$iv = stringArray = new SecurityScheme();
            string = BASIC_SECURITY_NAME;
            components = $this$addSecurityDefinitions.getComponents();
            boolean bl = false;
            $this$addSecurityDefinitions_u24lambda_u242.setType(SecurityScheme.Type.HTTP);
            $this$addSecurityDefinitions_u24lambda_u242.setScheme(BASIC_SECURITY_NAME);
            unit = Unit.INSTANCE;
            components.addSecuritySchemes(string, (SecurityScheme)stringArray);
        }
        if (this.hasAnyOperationWithSecurityName($this$addSecurityDefinitions, API_KEY_SECURITY_NAME)) {
            $this$addSecurityDefinitions_u24lambda_u242 = stringArray = new SecurityScheme();
            string = API_KEY_SECURITY_NAME;
            components = $this$addSecurityDefinitions.getComponents();
            boolean bl = false;
            $this$addSecurityDefinitions_u24lambda_u243.setType(SecurityScheme.Type.APIKEY);
            $this$addSecurityDefinitions_u24lambda_u243.setIn(SecurityScheme.In.HEADER);
            $this$addSecurityDefinitions_u24lambda_u243.setName("Authorization");
            unit = Unit.INSTANCE;
            components.addSecuritySchemes(string, (SecurityScheme)stringArray);
        }
        if (this.hasAnyOperationWithSecurityName($this$addSecurityDefinitions, JWT_BEARER_SECURITY_NAME)) {
            void $this$addSecurityDefinitions_u24lambda_u244;
            $this$addSecurityDefinitions_u24lambda_u243 = stringArray = new SecurityScheme();
            string = JWT_BEARER_SECURITY_NAME;
            components = $this$addSecurityDefinitions.getComponents();
            boolean bl = false;
            $this$addSecurityDefinitions_u24lambda_u244.setType(SecurityScheme.Type.HTTP);
            $this$addSecurityDefinitions_u24lambda_u244.setScheme("bearer");
            $this$addSecurityDefinitions_u24lambda_u244.setBearerFormat("JWT");
            unit = Unit.INSTANCE;
            components.addSecuritySchemes(string, (SecurityScheme)stringArray);
        }
    }

    public final void addSecurityItemFromSecurityRequirements(@NotNull Operation $this$addSecurityItemFromSecurityRequirements, @Nullable SecurityRequirements securityRequirements) {
        Intrinsics.checkNotNullParameter((Object)$this$addSecurityItemFromSecurityRequirements, (String)"<this>");
        if (securityRequirements != null) {
            switch (WhenMappings.$EnumSwitchMapping$0[securityRequirements.getType().ordinal()]) {
                case 1: {
                    $this$addSecurityItemFromSecurityRequirements.addSecurityItem(new SecurityRequirement().addList(OAUTH2_SECURITY_NAME, this.securityRequirements2ScopesList(securityRequirements)));
                    break;
                }
                case 2: {
                    $this$addSecurityItemFromSecurityRequirements.addSecurityItem(new SecurityRequirement().addList(BASIC_SECURITY_NAME));
                    break;
                }
                case 3: {
                    $this$addSecurityItemFromSecurityRequirements.addSecurityItem(new SecurityRequirement().addList(API_KEY_SECURITY_NAME));
                    break;
                }
                case 4: {
                    $this$addSecurityItemFromSecurityRequirements.addSecurityItem(new SecurityRequirement().addList(JWT_BEARER_SECURITY_NAME));
                }
            }
        }
    }

    private final List<String> securityRequirements2ScopesList(SecurityRequirements securityRequirements) {
        List list;
        if (securityRequirements.getType() == SecurityType.OAUTH2 && securityRequirements.getRequiredScopes() != null) {
            List list2 = securityRequirements.getRequiredScopes();
            list = list2;
            Intrinsics.checkNotNull((Object)list2);
        } else {
            list = CollectionsKt.emptyList();
        }
        return list;
    }

    private final OAuthFlow scopes(OAuthFlow $this$scopes, Set<String> scopes, Map<String, String> scopeAndDescriptions) {
        Scopes scopes2;
        Scopes $this$scopes_u24lambda_u246 = scopes2 = new Scopes();
        boolean bl = false;
        Iterable $this$forEach$iv = scopes;
        boolean $i$f$forEach = false;
        for (Object element$iv : $this$forEach$iv) {
            String it = (String)element$iv;
            boolean bl2 = false;
            $this$scopes_u24lambda_u246.addString(it, scopeAndDescriptions.getOrDefault(it, "No description"));
        }
        Scopes it = scopes2;
        boolean bl3 = false;
        $this$scopes.scopes(it);
        it = scopes2;
        boolean bl4 = false;
        return $this$scopes;
    }

    private final boolean hasAnyOperationWithSecurityName(OpenAPI openApi, String name) {
        boolean bl;
        block7: {
            Object $this$mapNotNullTo$iv$iv;
            Object list$iv$iv;
            Object it;
            Object $this$flatMapTo$iv$iv;
            Paths paths = openApi.getPaths();
            Intrinsics.checkNotNullExpressionValue((Object)paths, (String)"openApi.paths");
            Object $this$flatMap$iv = (Map)paths;
            boolean $i$f$flatMap = false;
            Object object = $this$flatMap$iv;
            Collection destination$iv$iv = new ArrayList();
            boolean $i$f$flatMapTo = false;
            for (Map.Entry element$iv$iv : $this$flatMapTo$iv$iv.entrySet()) {
                it = element$iv$iv;
                boolean bl2 = false;
                List list = ((PathItem)it.getValue()).readOperations();
                Intrinsics.checkNotNullExpressionValue((Object)list, (String)"it.value.readOperations()");
                list$iv$iv = list;
                CollectionsKt.addAll((Collection)destination$iv$iv, (Iterable)list$iv$iv);
            }
            Iterable $this$mapNotNull$iv = (List)destination$iv$iv;
            boolean $i$f$mapNotNull = false;
            $this$flatMapTo$iv$iv = $this$mapNotNull$iv;
            destination$iv$iv = new ArrayList();
            boolean $i$f$mapNotNullTo = false;
            Iterator $this$forEach$iv$iv$iv = $this$mapNotNullTo$iv$iv;
            boolean $i$f$forEach = false;
            list$iv$iv = $this$forEach$iv$iv$iv.iterator();
            while (list$iv$iv.hasNext()) {
                List it$iv$iv;
                Object element$iv$iv$iv;
                Object element$iv$iv = element$iv$iv$iv = list$iv$iv.next();
                boolean bl3 = false;
                Operation it2 = (Operation)element$iv$iv;
                boolean bl4 = false;
                if (it2.getSecurity() == null) continue;
                boolean bl5 = false;
                destination$iv$iv.add(it$iv$iv);
            }
            $this$flatMap$iv = (List)destination$iv$iv;
            $i$f$flatMap = false;
            $this$mapNotNullTo$iv$iv = $this$flatMap$iv;
            destination$iv$iv = new ArrayList();
            $i$f$flatMapTo = false;
            $this$forEach$iv$iv$iv = $this$flatMapTo$iv$iv.iterator();
            while ($this$forEach$iv$iv$iv.hasNext()) {
                Object element$iv$iv = $this$forEach$iv$iv$iv.next();
                it = (List)element$iv$iv;
                boolean bl6 = false;
                list$iv$iv = (Iterable)it;
                CollectionsKt.addAll((Collection)destination$iv$iv, (Iterable)list$iv$iv);
            }
            $this$flatMap$iv = (List)destination$iv$iv;
            $i$f$flatMap = false;
            $this$flatMapTo$iv$iv = $this$flatMap$iv;
            destination$iv$iv = new ArrayList();
            $i$f$flatMapTo = false;
            $this$forEach$iv$iv$iv = $this$flatMapTo$iv$iv.iterator();
            while ($this$forEach$iv$iv$iv.hasNext()) {
                Object element$iv$iv = $this$forEach$iv$iv$iv.next();
                it = (SecurityRequirement)element$iv$iv;
                boolean bl7 = false;
                Set set = it.keySet();
                Intrinsics.checkNotNullExpressionValue((Object)set, (String)"it.keys");
                list$iv$iv = set;
                CollectionsKt.addAll((Collection)destination$iv$iv, (Iterable)list$iv$iv);
            }
            Iterable $this$any$iv = (List)destination$iv$iv;
            boolean $i$f$any = false;
            if ($this$any$iv instanceof Collection && ((Collection)$this$any$iv).isEmpty()) {
                bl = false;
            } else {
                for (Object element$iv : $this$any$iv) {
                    String it3 = (String)element$iv;
                    boolean bl8 = false;
                    if (!Intrinsics.areEqual((Object)it3, (Object)name)) continue;
                    bl = true;
                    break block7;
                }
                bl = false;
            }
        }
        return bl;
    }

    /*
     * WARNING - void declaration
     */
    private final Set<String> collectScopesFromOperations(OpenAPI $this$collectScopesFromOperations) {
        void $this$flatMapTo$iv$iv;
        Paths paths = $this$collectScopesFromOperations.getPaths();
        Intrinsics.checkNotNullExpressionValue((Object)paths, (String)"paths");
        Map $this$flatMap$iv = (Map)paths;
        boolean $i$f$flatMap = false;
        Map map = $this$flatMap$iv;
        Collection destination$iv$iv = new ArrayList();
        boolean $i$f$flatMapTo = false;
        Iterator iterator = $this$flatMapTo$iv$iv.entrySet().iterator();
        while (iterator.hasNext()) {
            void $this$flatMapTo$iv$iv2;
            void $this$flatMap$iv2;
            Map.Entry element$iv$iv;
            Map.Entry path = element$iv$iv = iterator.next();
            boolean bl = false;
            List list = ((PathItem)path.getValue()).readOperations();
            Intrinsics.checkNotNullExpressionValue((Object)list, (String)"path.value.readOperations()");
            Iterable iterable = list;
            boolean $i$f$flatMap2 = false;
            void var13_13 = $this$flatMap$iv2;
            Collection destination$iv$iv2 = new ArrayList();
            boolean $i$f$flatMapTo2 = false;
            for (Object element$iv$iv2 : $this$flatMapTo$iv$iv2) {
                List list2;
                List list3;
                Operation operation = (Operation)element$iv$iv2;
                boolean bl2 = false;
                if (operation != null && (list3 = operation.getSecurity()) != null) {
                    void $this$flatMapTo$iv$iv3;
                    void $this$flatMap$iv3;
                    void $this$filterTo$iv$iv;
                    void $this$filter$iv;
                    Iterable iterable2 = list3;
                    boolean $i$f$filter22 = false;
                    void var23_25 = $this$filter$iv;
                    Collection destination$iv$iv3 = new ArrayList();
                    boolean $i$f$filterTo = false;
                    for (Object element$iv$iv3 : $this$filterTo$iv$iv) {
                        SecurityRequirement s = (SecurityRequirement)element$iv$iv3;
                        boolean bl3 = false;
                        Intrinsics.checkNotNullExpressionValue((Object)s, (String)"s");
                        Map $this$filterKeys$iv = (Map)s;
                        boolean $i$f$filterKeys = false;
                        LinkedHashMap result$iv = new LinkedHashMap();
                        for (Map.Entry entry$iv : $this$filterKeys$iv.entrySet()) {
                            String it = (String)entry$iv.getKey();
                            boolean bl4 = false;
                            Intrinsics.checkNotNullExpressionValue((Object)it, (String)"it");
                            if (!StringsKt.startsWith$default((String)it, (String)OAUTH2_SECURITY_NAME, (boolean)false, (int)2, null)) continue;
                            result$iv.put(entry$iv.getKey(), entry$iv.getValue());
                        }
                        boolean bl5 = !((Map)result$iv).isEmpty();
                        if (!bl5) continue;
                        destination$iv$iv3.add(element$iv$iv3);
                    }
                    Iterable $i$f$filter22 = (List)destination$iv$iv3;
                    boolean $i$f$flatMap3 = false;
                    destination$iv$iv3 = $this$flatMap$iv3;
                    Collection destination$iv$iv4 = new ArrayList();
                    boolean $i$f$flatMapTo3 = false;
                    for (Object element$iv$iv4 : $this$flatMapTo$iv$iv3) {
                        void $this$flatMapTo$iv$iv4;
                        SecurityRequirement oauthSecurity = (SecurityRequirement)element$iv$iv4;
                        boolean bl6 = false;
                        Collection collection = oauthSecurity.values();
                        Intrinsics.checkNotNullExpressionValue((Object)collection, (String)"oauthSecurity.values");
                        Iterable $this$flatMap$iv4 = collection;
                        boolean $i$f$flatMap4 = false;
                        Iterable iterable3 = $this$flatMap$iv4;
                        Collection destination$iv$iv5 = new ArrayList();
                        boolean $i$f$flatMapTo4 = false;
                        for (Object element$iv$iv5 : $this$flatMapTo$iv$iv4) {
                            List it = (List)element$iv$iv5;
                            boolean bl7 = false;
                            Intrinsics.checkNotNullExpressionValue((Object)it, (String)"it");
                            Iterable list$iv$iv = it;
                            CollectionsKt.addAll((Collection)destination$iv$iv5, (Iterable)list$iv$iv);
                        }
                        Iterable list$iv$iv = (List)destination$iv$iv5;
                        CollectionsKt.addAll((Collection)destination$iv$iv4, (Iterable)list$iv$iv);
                    }
                    list2 = (List)destination$iv$iv4;
                } else {
                    list2 = CollectionsKt.emptyList();
                }
                Iterable list$iv$iv = list2;
                CollectionsKt.addAll((Collection)destination$iv$iv2, (Iterable)list$iv$iv);
            }
            Iterable list$iv$iv = (List)destination$iv$iv2;
            CollectionsKt.addAll((Collection)destination$iv$iv, (Iterable)list$iv$iv);
        }
        return CollectionsKt.toSet((Iterable)((List)destination$iv$iv));
    }

    @Metadata(mv={1, 7, 1}, k=3, xi=48)
    public final class WhenMappings {
        public static final /* synthetic */ int[] $EnumSwitchMapping$0;

        static {
            int[] nArray = new int[SecurityType.values().length];
            try {
                nArray[SecurityType.OAUTH2.ordinal()] = 1;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            try {
                nArray[SecurityType.BASIC.ordinal()] = 2;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            try {
                nArray[SecurityType.API_KEY.ordinal()] = 3;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            try {
                nArray[SecurityType.JWT_BEARER.ordinal()] = 4;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            $EnumSwitchMapping$0 = nArray;
        }
    }
}

