/*
 * Decompiled with CFR 0.152.
 */
package com.epages.restdocs.apispec;

import com.epages.restdocs.apispec.JWTBearer;
import com.epages.restdocs.apispec.Oauth2;
import com.epages.restdocs.apispec.SecurityRequirements;
import com.epages.restdocs.apispec.SecurityRequirementsExtractor;
import com.fasterxml.jackson.core.type.TypeReference;
import com.fasterxml.jackson.databind.ObjectMapper;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Base64;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.ListIterator;
import java.util.Map;
import kotlin.Metadata;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.internal.Intrinsics;
import kotlin.text.Charsets;
import kotlin.text.Regex;
import kotlin.text.StringsKt;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.springframework.http.HttpHeaders;
import org.springframework.restdocs.operation.Operation;
import org.springframework.restdocs.operation.OperationRequest;

@Metadata(mv={1, 4, 1}, bv={1, 0, 3}, k=1, d1={"\u0000,\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010 \n\u0002\u0010\u000e\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u000b\n\u0002\b\u0004\b\u0000\u0018\u00002\u00020\u0001B\u0005\u00a2\u0006\u0002\u0010\u0002J\u0016\u0010\u0003\u001a\b\u0012\u0004\u0012\u00020\u00050\u00042\u0006\u0010\u0006\u001a\u00020\u0007H\u0002J\u0012\u0010\b\u001a\u0004\u0018\u00010\t2\u0006\u0010\u0006\u001a\u00020\u0007H\u0016J\u0016\u0010\n\u001a\b\u0012\u0004\u0012\u00020\u00050\u00042\u0006\u0010\u0006\u001a\u00020\u0007H\u0002J\u0010\u0010\u000b\u001a\u00020\f2\u0006\u0010\u0006\u001a\u00020\u0007H\u0002J\u0010\u0010\r\u001a\u00020\f2\u0006\u0010\u000e\u001a\u00020\u0005H\u0002J\u0016\u0010\u000f\u001a\b\u0012\u0004\u0012\u00020\u00050\u00042\u0006\u0010\u000e\u001a\u00020\u0005H\u0002\u00a8\u0006\u0010"}, d2={"Lcom/epages/restdocs/apispec/JwtSecurityHandler;", "Lcom/epages/restdocs/apispec/SecurityRequirementsExtractor;", "()V", "extractScopes", "", "", "operation", "Lorg/springframework/restdocs/operation/Operation;", "extractSecurityRequirements", "Lcom/epages/restdocs/apispec/SecurityRequirements;", "getJWT", "hasJWTBearer", "", "isJWT", "jwt", "jwt2scopes", "restdocs-api-spec"})
public final class JwtSecurityHandler
implements SecurityRequirementsExtractor {
    @Override
    @Nullable
    public SecurityRequirements extractSecurityRequirements(@NotNull Operation operation) {
        Intrinsics.checkNotNullParameter((Object)operation, (String)"operation");
        if (!this.hasJWTBearer(operation)) {
            return null;
        }
        List<String> scopes = this.extractScopes(operation);
        Collection collection = scopes;
        boolean bl = false;
        return !collection.isEmpty() ? (SecurityRequirements)new Oauth2(scopes) : (SecurityRequirements)JWTBearer.INSTANCE;
    }

    private final boolean hasJWTBearer(Operation operation) {
        boolean bl;
        block3: {
            Iterable $this$any$iv = this.getJWT(operation);
            boolean $i$f$any = false;
            if ($this$any$iv instanceof Collection && ((Collection)$this$any$iv).isEmpty()) {
                bl = false;
            } else {
                for (Object element$iv : $this$any$iv) {
                    String it = (String)element$iv;
                    boolean bl2 = false;
                    if (!this.isJWT(it)) continue;
                    bl = true;
                    break block3;
                }
                bl = false;
            }
        }
        return bl;
    }

    /*
     * WARNING - void declaration
     */
    private final List<String> getJWT(Operation operation) {
        void $this$mapTo$iv$iv;
        Iterable $this$filterTo$iv$iv;
        Iterable $this$flatMapTo$iv$iv;
        Object it;
        OperationRequest operationRequest = operation.getRequest();
        Intrinsics.checkNotNullExpressionValue((Object)operationRequest, (String)"operation.request");
        HttpHeaders httpHeaders = operationRequest.getHeaders();
        Intrinsics.checkNotNullExpressionValue((Object)httpHeaders, (String)"operation.request.headers");
        Map $this$filterKeys$iv = (Map)httpHeaders;
        boolean $i$f$filterKeys = false;
        Map result$iv = new LinkedHashMap();
        Map map = $this$filterKeys$iv;
        boolean bl = false;
        for (Map.Entry entry$iv : map.entrySet()) {
            it = (String)entry$iv.getKey();
            boolean bl2 = false;
            if (!Intrinsics.areEqual((Object)it, (Object)"Authorization")) continue;
            ((HashMap)result$iv).put(entry$iv.getKey(), entry$iv.getValue());
        }
        Map $this$flatMap$iv = result$iv;
        boolean $i$f$flatMap = false;
        result$iv = $this$flatMap$iv;
        Collection destination$iv$iv = new ArrayList();
        boolean $i$f$flatMapTo = false;
        Iterator iterator = $this$flatMapTo$iv$iv;
        boolean entry$iv = false;
        it = iterator.entrySet().iterator();
        while (it.hasNext()) {
            Map.Entry element$iv$iv;
            Map.Entry it2 = element$iv$iv = (Map.Entry)it.next();
            boolean bl3 = false;
            Iterable list$iv$iv = (List)it2.getValue();
            CollectionsKt.addAll((Collection)destination$iv$iv, (Iterable)list$iv$iv);
        }
        Iterable $this$filter$iv = (List)destination$iv$iv;
        boolean $i$f$filter = false;
        $this$flatMapTo$iv$iv = $this$filter$iv;
        destination$iv$iv = new ArrayList();
        boolean $i$f$filterTo = false;
        for (Map.Entry element$iv$iv : $this$filterTo$iv$iv) {
            it = (String)((Object)element$iv$iv);
            boolean bl4 = false;
            Object object = it;
            Intrinsics.checkNotNullExpressionValue((Object)object, (String)"it");
            if (!StringsKt.startsWith$default((String)object, (String)"Bearer ", (boolean)false, (int)2, null)) continue;
            destination$iv$iv.add(element$iv$iv);
        }
        Iterable $this$map$iv = (List)destination$iv$iv;
        boolean $i$f$map = false;
        $this$filterTo$iv$iv = $this$map$iv;
        destination$iv$iv = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)$this$map$iv, (int)10));
        boolean $i$f$mapTo = false;
        for (Map.Entry item$iv$iv : $this$mapTo$iv$iv) {
            it = (String)((Object)item$iv$iv);
            Collection collection = destination$iv$iv;
            boolean bl5 = false;
            Object object = it;
            Intrinsics.checkNotNullExpressionValue((Object)object, (String)"it");
            String string = StringsKt.replace$default((String)object, (String)"Bearer ", (String)"", (boolean)false, (int)4, null);
            collection.add(string);
        }
        return (List)destination$iv$iv;
    }

    private final boolean isJWT(String jwt) {
        List jwtParts;
        List list;
        CharSequence charSequence = jwt;
        String string = "\\.";
        int n = 0;
        string = new Regex(string);
        n = 0;
        boolean bl = false;
        List $this$dropLastWhile$iv = string.split(charSequence, n);
        boolean $i$f$dropLastWhile = false;
        if (!$this$dropLastWhile$iv.isEmpty()) {
            ListIterator iterator$iv = $this$dropLastWhile$iv.listIterator($this$dropLastWhile$iv.size());
            while (iterator$iv.hasPrevious()) {
                String it = (String)iterator$iv.previous();
                boolean bl2 = false;
                CharSequence charSequence2 = it;
                boolean bl3 = false;
                if (charSequence2.length() == 0) continue;
                list = CollectionsKt.take((Iterable)$this$dropLastWhile$iv, (int)(iterator$iv.nextIndex() + 1));
                break;
            }
        } else {
            list = jwtParts = CollectionsKt.emptyList();
        }
        if (jwtParts.size() >= 2) {
            String jwtHeader = (String)jwtParts.get(0);
            byte[] byArray = Base64.getDecoder().decode(jwtHeader);
            Intrinsics.checkNotNullExpressionValue((Object)byArray, (String)"Base64.getDecoder().decode(jwtHeader)");
            byte[] iterator$iv = byArray;
            boolean it = false;
            String decodedJwtHeader = new String(iterator$iv, Charsets.UTF_8);
            try {
                ObjectMapper $this$readValue$iv = new ObjectMapper();
                boolean $i$f$readValue = false;
                boolean $i$f$jacksonTypeRef = false;
                return ((Map)$this$readValue$iv.readValue(decodedJwtHeader, (TypeReference)new TypeReference<Map<String, ? extends Object>>(){})).containsKey("alg");
            }
            catch (IOException iOException) {
                // empty catch block
            }
        }
        return false;
    }

    /*
     * WARNING - void declaration
     */
    private final List<String> extractScopes(Operation operation) {
        void $this$flatMapTo$iv$iv;
        Iterable $this$flatMap$iv = this.getJWT(operation);
        boolean $i$f$flatMap = false;
        Iterable iterable = $this$flatMap$iv;
        Collection destination$iv$iv = new ArrayList();
        boolean $i$f$flatMapTo = false;
        for (Object element$iv$iv : $this$flatMapTo$iv$iv) {
            String it = (String)element$iv$iv;
            boolean bl = false;
            Iterable list$iv$iv = this.jwt2scopes(it);
            CollectionsKt.addAll((Collection)destination$iv$iv, (Iterable)list$iv$iv);
        }
        return (List)destination$iv$iv;
    }

    private final List<String> jwt2scopes(String jwt) {
        List jwtParts;
        List list;
        CharSequence charSequence = jwt;
        String string = "\\.";
        int n = 0;
        string = new Regex(string);
        n = 0;
        boolean bl = false;
        List $this$dropLastWhile$iv = string.split(charSequence, n);
        boolean $i$f$dropLastWhile = false;
        if (!$this$dropLastWhile$iv.isEmpty()) {
            ListIterator iterator$iv = $this$dropLastWhile$iv.listIterator($this$dropLastWhile$iv.size());
            while (iterator$iv.hasPrevious()) {
                String it = (String)iterator$iv.previous();
                boolean bl2 = false;
                CharSequence charSequence2 = it;
                boolean bl3 = false;
                if (charSequence2.length() == 0) continue;
                list = CollectionsKt.take((Iterable)$this$dropLastWhile$iv, (int)(iterator$iv.nextIndex() + 1));
                break;
            }
        } else {
            list = jwtParts = CollectionsKt.emptyList();
        }
        if (jwtParts.size() >= 2) {
            String jwtPayload = (String)jwtParts.get(1);
            byte[] byArray = Base64.getDecoder().decode(jwtPayload);
            Intrinsics.checkNotNullExpressionValue((Object)byArray, (String)"Base64.getDecoder().decode(jwtPayload)");
            byte[] iterator$iv = byArray;
            boolean it = false;
            String decodedPayload = new String(iterator$iv, Charsets.UTF_8);
            try {
                ObjectMapper $this$readValue$iv = new ObjectMapper();
                boolean $i$f$readValue = false;
                boolean $i$f$jacksonTypeRef = false;
                Map jwtMap = (Map)$this$readValue$iv.readValue(decodedPayload, (TypeReference)new TypeReference<Map<String, ? extends Object>>(){});
                Object scope = jwtMap.get("scope");
                if (scope instanceof List) {
                    return (List)scope;
                }
            }
            catch (IOException iOException) {
                // empty catch block
            }
        }
        List<String> list2 = Collections.emptyList();
        Intrinsics.checkNotNullExpressionValue(list2, (String)"emptyList()");
        return list2;
    }
}

