/*
 * Decompiled with CFR 0.152.
 */
package com.epages.restdocs;

import com.epages.restdocs.ResponseFieldTemplateDescriptor;
import com.epages.restdocs.ResponseTemplateProcessor;
import com.fasterxml.jackson.core.JsonProcessingException;
import com.fasterxml.jackson.databind.ObjectMapper;
import com.fasterxml.jackson.databind.SerializationFeature;
import java.io.IOException;
import java.io.Writer;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.springframework.restdocs.RestDocumentationContext;
import org.springframework.restdocs.operation.Operation;
import org.springframework.restdocs.operation.OperationRequest;
import org.springframework.restdocs.operation.OperationResponse;
import org.springframework.restdocs.operation.Parameters;
import org.springframework.restdocs.operation.QueryStringParser;
import org.springframework.restdocs.snippet.PlaceholderResolverFactory;
import org.springframework.restdocs.snippet.RestDocumentationContextPlaceholderResolverFactory;
import org.springframework.restdocs.snippet.Snippet;
import org.springframework.restdocs.snippet.StandardWriterResolver;
import org.springframework.restdocs.templates.TemplateFormat;
import org.springframework.util.StringUtils;
import org.springframework.web.util.UriComponentsBuilder;
import org.springframework.web.util.UriTemplate;

final class WireMockJsonSnippet
implements Snippet {
    private static final String SNIPPET_NAME = "wiremock-stub";
    static final TemplateFormat TEMPLATE_FORMAT = new TemplateFormat(){

        public String getId() {
            return "json";
        }

        public String getFileExtension() {
            return "json";
        }
    };
    private List<ResponseFieldTemplateDescriptor> responseFieldTemplateDescriptors;

    WireMockJsonSnippet(ResponseFieldTemplateDescriptor[] responseFieldTemplateDescriptors) {
        this.responseFieldTemplateDescriptors = Arrays.asList(responseFieldTemplateDescriptors);
    }

    public void document(Operation operation) throws IOException {
        RestDocumentationContext context = (RestDocumentationContext)operation.getAttributes().get(RestDocumentationContext.class.getName());
        StandardWriterResolver writerResolver = new StandardWriterResolver((PlaceholderResolverFactory)new RestDocumentationContextPlaceholderResolverFactory(), "UTF-8", TEMPLATE_FORMAT);
        try (Writer writer = writerResolver.resolve(operation.getName(), SNIPPET_NAME, context);){
            writer.append(this.toJsonString(operation));
        }
    }

    private String toJsonString(Operation operation) throws JsonProcessingException {
        return new ObjectMapper().enable(SerializationFeature.INDENT_OUTPUT).writeValueAsString(this.createModel(operation));
    }

    protected Map<Object, Object> createModel(Operation operation) {
        Map<Object, Object> headers;
        Map<Object, Object> queryParams;
        OperationResponse response = operation.getResponse();
        Maps.Builder requestBuilder = ((Maps.Builder)Maps.builder()).put("method", operation.getRequest().getMethod());
        this.urlPathOrUrlPattern(operation, requestBuilder);
        Maps.Builder responseBuilder = ((Maps.Builder)((Maps.Builder)((Maps.Builder)Maps.builder()).put("status", response.getStatus().value())).put("headers", this.responseHeaders(response))).put("body", this.responseBody(operation));
        if (!this.responseFieldTemplateDescriptors.isEmpty()) {
            responseBuilder.put("transformers", Collections.singletonList("response-template"));
        }
        if (!(queryParams = this.queryParams(operation)).isEmpty()) {
            requestBuilder.put("queryParameters", queryParams);
        }
        if (!(headers = this.requestHeaders(operation.getRequest())).isEmpty()) {
            requestBuilder.put("headers", headers);
        }
        return ((Maps.Builder)((Maps.Builder)((Maps.Builder)Maps.builder()).put("request", requestBuilder.build())).put("response", responseBuilder.build())).build();
    }

    private void urlPathOrUrlPattern(Operation operation, Maps.Builder<Object, Object> requestBuilder) {
        String urlTemplate = (String)operation.getAttributes().get("org.springframework.restdocs.urlTemplate");
        if (StringUtils.isEmpty((Object)urlTemplate)) {
            ((Maps.Builder)requestBuilder).put("urlPath", operation.getRequest().getUri().getRawPath());
        } else {
            UriTemplate uriTemplate = new UriTemplate(urlTemplate);
            UriComponentsBuilder uriTemplateBuilder = UriComponentsBuilder.fromUriString((String)urlTemplate);
            Maps.Builder uriVariables = Maps.builder();
            for (String variableName : uriTemplate.getVariableNames()) {
                uriVariables.put(variableName, "[^/]+");
            }
            String uriPathRegex = uriTemplateBuilder.buildAndExpand(uriVariables.build()).getPath();
            ((Maps.Builder)requestBuilder).put("urlPathPattern", uriPathRegex);
        }
    }

    private Map<Object, Object> responseHeaders(OperationResponse response) {
        Maps.Builder responseHeaders = Maps.builder();
        for (Map.Entry e : response.getHeaders().entrySet()) {
            List values = (List)e.getValue();
            if (values.isEmpty()) continue;
            responseHeaders.put(e.getKey(), values.get(0));
        }
        return responseHeaders.build();
    }

    private Map<Object, Object> queryParams(Operation operation) {
        Maps.Builder queryParams = Maps.builder();
        Parameters queryStringParameters = new QueryStringParser().parse(operation.getRequest().getUri());
        for (Map.Entry e : queryStringParameters.entrySet()) {
            List values = (List)e.getValue();
            if (values.isEmpty()) continue;
            queryParams.put(e.getKey(), Maps.of("equalTo", (String)values.get(0)));
        }
        return queryParams.build();
    }

    private String responseBody(Operation operation) {
        OperationResponse response = operation.getResponse();
        String urlTemplateString = (String)operation.getAttributes().get("org.springframework.restdocs.urlTemplate");
        return new ResponseTemplateProcessor(this.responseFieldTemplateDescriptors, urlTemplateString != null ? new UriTemplate(urlTemplateString) : null, response.getContentAsString()).replaceTemplateFields();
    }

    private Map<Object, Object> requestHeaders(OperationRequest request) {
        Maps.Builder requestHeaders = Maps.builder();
        for (Map.Entry e : request.getHeaders().entrySet()) {
            List values;
            if (!"content-type".equalsIgnoreCase((String)e.getKey()) && !"accept".equalsIgnoreCase((String)e.getKey()) || (values = (List)e.getValue()).isEmpty()) continue;
            String mediaType = (String)values.get(0);
            mediaType = mediaType.contains("+") ? mediaType.replaceAll(".*[+]", "") : mediaType.replaceAll(".*/", "");
            if (mediaType.contains(";")) {
                mediaType = mediaType.replaceAll(";.*", "");
            }
            requestHeaders.put(e.getKey(), Maps.of("contains", mediaType));
        }
        return requestHeaders.build();
    }

    private static abstract class Maps {
        private Maps() {
        }

        private static <K, V> Map<K, V> of(K k1, V v1) {
            HashMap<K, V> map = new HashMap<K, V>();
            map.put(k1, v1);
            return map;
        }

        private static <K, V> Builder<K, V> builder() {
            return new Builder();
        }

        private static class Builder<K, V> {
            private final Map<K, V> map = new HashMap();

            private Builder() {
            }

            private Builder<K, V> put(K k, V v) {
                this.map.put(k, v);
                return this;
            }

            private Map<K, V> build() {
                return this.map;
            }
        }
    }
}

