/*
 * Decompiled with CFR 0.152.
 */
package com.epam.gmp;

import com.epam.gmp.config.GMPConfig;
import com.epam.gmp.process.GroovyThread;
import com.epam.gmp.process.QueuedProcessService;
import com.epam.gmp.service.ExitCodeCalculator;
import com.epam.gmp.service.ScriptContextBuilder;
import java.util.ArrayList;
import java.util.regex.Matcher;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.BeansException;
import org.springframework.context.annotation.AnnotationConfigApplicationContext;

public class ChainExecutor {
    private static final Logger logger = LoggerFactory.getLogger(ChainExecutor.class);
    private AnnotationConfigApplicationContext context;

    public static void main(String[] args) throws InterruptedException {
        if (args.length > 0) {
            Integer initialExitCode = 0;
            ChainExecutor chainExecutor = new ChainExecutor();
            chainExecutor.initContext();
            QueuedProcessService processService = (QueuedProcessService)chainExecutor.context.getBean(QueuedProcessService.class);
            long start = System.currentTimeMillis();
            int i = 0;
            while (i < args.length) {
                String arg = args[i];
                Matcher pathMatcher = ScriptContextBuilder.SCRIPT_PATTERN.matcher(arg);
                if (pathMatcher.matches()) {
                    Matcher nextMatcher;
                    ArrayList<String> cmdLineParams = new ArrayList<String>();
                    int j = i + 1;
                    while (j < args.length && !(nextMatcher = ScriptContextBuilder.SCRIPT_PATTERN.matcher(args[j])).matches()) {
                        cmdLineParams.add(args[j++]);
                    }
                    i += cmdLineParams.size() + 1;
                    try {
                        processService.execute(GroovyThread.class, arg, cmdLineParams);
                    }
                    catch (BeansException e) {
                        logger.error("Unable to run script", (Throwable)e);
                        Integer n = initialExitCode;
                        Integer n2 = initialExitCode = Integer.valueOf(initialExitCode + 1);
                    }
                    continue;
                }
                ++i;
            }
            processService.shutdown();
            if (logger.isInfoEnabled()) {
                logger.info("Took: {}", (Object)(System.currentTimeMillis() - start));
            }
            ExitCodeCalculator exitCodeCalculator = (ExitCodeCalculator)chainExecutor.context.getBean(ExitCodeCalculator.class);
            int exitCode = exitCodeCalculator.calculate(initialExitCode);
            chainExecutor.context.close();
            System.exit(exitCode);
        } else {
            logger.error("Parameter script name is absent!");
            System.exit(1);
        }
    }

    private void initContext() {
        this.context = new AnnotationConfigApplicationContext();
        this.context.register(new Class[]{GMPConfig.class});
        this.context.refresh();
        if (logger.isInfoEnabled()) {
            for (String name : this.context.getBeanDefinitionNames()) {
                logger.info("<bean name='{}'/> - READY.", (Object)name);
            }
        }
    }
}

