/*
 * Decompiled with CFR 0.152.
 */
package com.epam.gmp.config;

import com.epam.gmp.ExportBinding;
import com.epam.gmp.ScriptContextException;
import com.epam.gmp.service.GMPContext;
import java.io.IOException;
import java.net.MalformedURLException;
import java.util.Collections;
import java.util.HashMap;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.ListableBeanFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.context.annotation.Bean;
import org.springframework.context.annotation.ComponentScan;
import org.springframework.context.annotation.Configuration;
import org.springframework.context.annotation.EnableAspectJAutoProxy;
import org.springframework.context.support.PropertySourcesPlaceholderConfigurer;
import org.springframework.core.io.ClassPathResource;
import org.springframework.core.io.Resource;
import org.springframework.core.io.UrlResource;

@Configuration
@ComponentScan(value={"com.epam.gmp.service", "com.epam.gmp.process", "com.epam.gmp.config.custom"})
@EnableAspectJAutoProxy
public class GMPConfig {
    private static final Logger logger = LoggerFactory.getLogger(GMPConfig.class);
    private static final String GMP_PROPERTIES = "gmp.properties";
    @Autowired
    private GMPContext gmpContext;

    @Bean(name={"gmpHome"})
    public static String gmpHome() {
        return System.getProperty("gmp.home");
    }

    @Bean(name={"gmpHomeResource"})
    public static Resource gmpHomeURL() {
        Object gmpHomeUrl;
        String pGmpHome = GMPConfig.gmpHome();
        try {
            gmpHomeUrl = pGmpHome != null ? new UrlResource(pGmpHome) : new ClassPathResource("gmp-home/");
        }
        catch (MalformedURLException e) {
            throw new ScriptContextException("Unable to initialize gmpHome", e);
        }
        return gmpHomeUrl;
    }

    @Bean(name={"GMPProperties"})
    public static PropertySourcesPlaceholderConfigurer properties() {
        Object[] resources;
        PropertySourcesPlaceholderConfigurer pspc = new PropertySourcesPlaceholderConfigurer();
        try {
            Resource homeResource = GMPConfig.gmpHomeURL().createRelative(GMP_PROPERTIES);
            resources = homeResource.exists() ? new Resource[]{homeResource} : new ClassPathResource[]{new ClassPathResource("gmp-home/gmp.properties")};
        }
        catch (IOException e) {
            throw new ScriptContextException("Unable to initialize gmp.properties", e);
        }
        pspc.setLocations(resources);
        pspc.setIgnoreUnresolvablePlaceholders(true);
        pspc.setIgnoreResourceNotFound(true);
        return pspc;
    }

    @Bean(name={"ResultMap"})
    public static Map<String, Object> resultMap() {
        return new ConcurrentHashMap<String, Object>();
    }

    @Bean(name={"ExportBindings"})
    public static Map<String, Object> computeExportBeans(ListableBeanFactory beanFactory) {
        Map beans = beanFactory.getBeansWithAnnotation(ExportBinding.class);
        HashMap bindings = new HashMap();
        for (Map.Entry bean : beans.entrySet()) {
            ExportBinding annotationBinding = bean.getValue().getClass().getAnnotation(ExportBinding.class);
            String key = annotationBinding.name().length() == 0 ? (String)bean.getKey() : annotationBinding.name();
            bindings.put(key, bean.getValue());
            if (!logger.isDebugEnabled()) continue;
            logger.debug("Export binding: {}.", (Object)key);
        }
        return Collections.unmodifiableMap(bindings);
    }
}

