/*
 * Decompiled with CFR 0.152.
 */
package com.epam.gmp.process;

import com.epam.gmp.ScriptContext;
import com.epam.gmp.ScriptExecutionException;
import com.epam.gmp.ScriptInitializationException;
import com.epam.gmp.ScriptResult;
import com.epam.gmp.process.IQueuedThread;
import com.epam.gmp.service.IGroovyScriptEngineService;
import com.epam.gmp.service.ScriptContextBuilder;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import javax.annotation.PostConstruct;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.context.annotation.Scope;
import org.springframework.stereotype.Component;

@Component(value="GroovyThread")
@Scope(value="prototype")
public class GroovyThread<T>
implements IQueuedThread<T> {
    @Autowired
    private ScriptContextBuilder scriptContextBuilder;
    @Autowired
    private IGroovyScriptEngineService groovyScriptEngineService;
    private ScriptContext scriptContext;
    private String resultKey;
    private final String scriptPath;
    private Map<String, Object> params = new HashMap<String, Object>();

    public GroovyThread(String scriptPath) {
        this.scriptPath = scriptPath;
    }

    public GroovyThread(String scriptPath, List<String> params) {
        this.scriptPath = scriptPath;
        this.params.put("cmdLine", params);
    }

    public GroovyThread(String scriptPath, Map<String, Object> params) {
        this.scriptPath = scriptPath;
        this.params = params;
    }

    @PostConstruct
    public void init() throws ScriptInitializationException {
        this.scriptContext = this.scriptContextBuilder.buildContextFor(this.scriptPath, this.params);
        this.resultKey = this.scriptContext.getScriptId();
    }

    @Override
    public ScriptResult<T> call() throws ScriptExecutionException {
        return this.groovyScriptEngineService.runScript(this.scriptContext);
    }

    @Override
    public String getKey() {
        return this.resultKey;
    }

    public String toString() {
        return this.scriptPath;
    }
}

