/*
 * Decompiled with CFR 0.152.
 */
package com.epam.gmp.process;

import com.epam.gmp.ScriptResult;
import com.epam.gmp.process.IQueuedProcessService;
import com.epam.gmp.process.IQueuedThread;
import com.epam.gmp.process.QueuedProcessThreadPoolExecutor;
import com.epam.gmp.service.GMPContext;
import java.util.concurrent.ArrayBlockingQueue;
import java.util.concurrent.Future;
import java.util.concurrent.TimeUnit;
import javax.annotation.PostConstruct;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Value;
import org.springframework.context.annotation.Scope;
import org.springframework.stereotype.Service;

@Service(value="QueuedProcessService")
@Scope(value="singleton")
public class QueuedProcessService
implements IQueuedProcessService {
    private final Logger logger = LoggerFactory.getLogger((String)this.getClass().getName());
    private QueuedProcessThreadPoolExecutor threadPool;
    private ArrayBlockingQueue<Runnable> queue;
    @Value(value="${groovy.thread.pool.size}")
    private int startPullers = 100;
    @Value(value="#{systemProperties['numThreads'] ?: ${groovy.thread.pool.core.size}}")
    private int corePullers = 100;
    @Value(value="${groovy.thread.timeout}")
    private int threadTimeout = 30;

    @PostConstruct
    public void initialize() {
        this.queue = new ArrayBlockingQueue(this.startPullers);
        this.threadPool = new QueuedProcessThreadPoolExecutor(this.corePullers, this.startPullers, 30L, TimeUnit.SECONDS, this.queue);
        if (this.logger.isInfoEnabled()) {
            this.logger.info("Prepared Groovy thread pool of {} pullers; concurrent: {}", (Object)this.startPullers, (Object)this.corePullers);
            this.logger.info("Initialized.");
        }
    }

    @Override
    public <R> Future<ScriptResult<R>> execute(IQueuedThread<R> process) {
        if (this.threadPool != null && !this.threadPool.isShutdown()) {
            Future<ScriptResult<R>> result = this.threadPool.submit(process);
            this.logger.debug("EXEC.Accepted {}", result);
            return result;
        }
        this.logger.debug("Process {} has not been started", (Object)process.getKey());
        return null;
    }

    @Override
    public <R, C extends IQueuedThread<R>> Future<ScriptResult<R>> execute(Class<C> bean, Object ... args) {
        return this.execute((IQueuedThread)GMPContext.getApplicationContext().getBean(bean, args));
    }

    public void shutdown() {
        this.shutdown(this.threadTimeout);
    }

    public void shutdown(int timeout) {
        if (this.logger.isInfoEnabled()) {
            this.logger.info("Global shutdown requested");
        }
        if (this.threadPool.shutdown(timeout)) {
            try {
                long start = System.currentTimeMillis();
                if (!this.threadPool.awaitTermination(10L, TimeUnit.SECONDS)) {
                    this.logger.info("ThreadPool shutdown timeout");
                }
                if (this.logger.isInfoEnabled()) {
                    this.logger.info("ThreadPool has been terminated in: {} millis.", (Object)(System.currentTimeMillis() - start));
                }
            }
            catch (InterruptedException e) {
                this.logger.error("Unable to stop thread pool correctly.", (Throwable)e);
            }
        }
    }

    @Override
    public int getQueueSize() {
        return this.queue.size();
    }

    @Override
    public int getQueueCapacity() {
        return this.startPullers;
    }
}

