/*
 * Decompiled with CFR 0.152.
 */
package com.epam.gmp.process;

import com.epam.gmp.process.GroovyFutureTask;
import java.util.List;
import java.util.concurrent.BlockingQueue;
import java.util.concurrent.Callable;
import java.util.concurrent.RejectedExecutionHandler;
import java.util.concurrent.RunnableFuture;
import java.util.concurrent.ThreadFactory;
import java.util.concurrent.ThreadPoolExecutor;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.atomic.AtomicInteger;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class QueuedProcessThreadPoolExecutor
extends ThreadPoolExecutor {
    private final Logger logger = LoggerFactory.getLogger((String)this.getClass().getName());
    protected final AtomicInteger incompleteScripts = new AtomicInteger(0);

    public QueuedProcessThreadPoolExecutor(int corePoolSize, int maximumPoolSize, long keepAliveTime, TimeUnit unit, BlockingQueue<Runnable> workQueue) {
        super(corePoolSize, maximumPoolSize, keepAliveTime, unit, workQueue, new GroovyThreadFactory(), new QPSRejectedExecutionHandler());
    }

    @Override
    protected <T> RunnableFuture<T> newTaskFor(Callable<T> callable) {
        return new GroovyFutureTask<T>(callable);
    }

    @Override
    protected <T> RunnableFuture<T> newTaskFor(Runnable runnable, T value) {
        return new GroovyFutureTask<T>(runnable, value);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void execute(Runnable command) {
        int active = this.incompleteScripts.incrementAndGet();
        super.execute(command);
        AtomicInteger atomicInteger = this.incompleteScripts;
        synchronized (atomicInteger) {
            this.incompleteScripts.notifyAll();
        }
        this.logger.debug("EXEC.Request ({}): Active runners: {}; threadPoolActive: {} ", new Object[]{command, active, this.getActiveCount()});
    }

    @Override
    protected void afterExecute(Runnable r, Throwable t) {
        super.afterExecute(r, t);
        if (t != null) {
            this.logger.error("Unhandled error occurred during task execution with message {}", (Object)t.getMessage());
        }
        this.decScriptCounter();
        this.logger.debug("COMPLETED ({}): Active runners: {}; threadPoolActive: {} ", new Object[]{r.toString(), this.incompleteScripts.get(), this.getActiveCount()});
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void decScriptCounter() {
        this.incompleteScripts.decrementAndGet();
        AtomicInteger atomicInteger = this.incompleteScripts;
        synchronized (atomicInteger) {
            this.incompleteScripts.notifyAll();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean shutdown(int timeout) {
        long stopRequested = System.currentTimeMillis();
        long stopDeadline = stopRequested + TimeUnit.MILLISECONDS.convert(timeout, TimeUnit.MINUTES);
        this.logger.info("ThreadPool shutdown requested. Wait for running scripts to complete their job... countdown: {} milliseconds.", (Object)(stopDeadline - System.currentTimeMillis()));
        while (this.incompleteScripts.get() != 0 && System.currentTimeMillis() < stopDeadline) {
            this.logger.info("Await for termination, pending scripts=({}); threadPoolActive: {}; countdown: {} milliseconds.", new Object[]{this.incompleteScripts.get(), this.getActiveCount(), stopDeadline - System.currentTimeMillis()});
            AtomicInteger atomicInteger = this.incompleteScripts;
            synchronized (atomicInteger) {
                try {
                    this.incompleteScripts.wait(TimeUnit.MILLISECONDS.convert(10L, TimeUnit.SECONDS));
                }
                catch (InterruptedException e) {
                    this.logger.debug("Await check.");
                }
            }
        }
        if (this.incompleteScripts.get() > 0) {
            this.logger.error("Shutdown timeout occurred.");
            List<Runnable> frozenTasks = this.shutdownNow();
            for (Runnable task : frozenTasks) {
                this.logger.error("Frozen: {}", (Object)task);
                if (!(task instanceof GroovyFutureTask)) continue;
                ((GroovyFutureTask)task).cancel(true);
            }
            return false;
        }
        this.logger.info("No active Scripts. Shutting down...");
        this.shutdown();
        return true;
    }

    protected static class QPSRejectedExecutionHandler
    implements RejectedExecutionHandler {
        private final Logger logger = LoggerFactory.getLogger((String)this.getClass().getName());

        protected QPSRejectedExecutionHandler() {
        }

        @Override
        public void rejectedExecution(Runnable r, ThreadPoolExecutor executor) {
            QueuedProcessThreadPoolExecutor qpExecutor = (QueuedProcessThreadPoolExecutor)executor;
            qpExecutor.decScriptCounter();
            this.logger.info("RejectedExecution for \u2116 {}. Run in the same thread.", (Object)qpExecutor.incompleteScripts);
            if (!executor.isShutdown()) {
                r.run();
            }
        }
    }

    public static class GroovyThreadFactory
    implements ThreadFactory {
        static final AtomicInteger poolNumber = new AtomicInteger(1);
        final ThreadGroup group;
        final AtomicInteger threadNumber = new AtomicInteger(1);
        final String namePrefix;

        GroovyThreadFactory() {
            SecurityManager s = System.getSecurityManager();
            this.group = s != null ? s.getThreadGroup() : Thread.currentThread().getThreadGroup();
            this.namePrefix = "QueuedProcess(" + poolNumber.getAndIncrement() + ")-thread-";
        }

        @Override
        public Thread newThread(Runnable r) {
            String name = this.namePrefix + this.threadNumber.getAndIncrement();
            Thread t = new Thread(this.group, r, name, 0L);
            if (t.isDaemon()) {
                t.setDaemon(false);
            }
            if (t.getPriority() != 5) {
                t.setPriority(5);
            }
            return t;
        }
    }
}

