/*
 * Decompiled with CFR 0.152.
 */
package com.epam.gmp.service;

import com.epam.gmp.ScriptResult;
import java.util.Map;
import javax.annotation.Resource;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.stereotype.Service;

@Service(value="ExitCodeCalculator")
public class ExitCodeCalculator {
    private final Logger logger = LoggerFactory.getLogger((String)this.getClass().getName());
    @Resource(name="ResultMap")
    private Map<String, Object> resultCache;

    public Integer calculate(Integer initialCode) {
        Integer resultCode = initialCode;
        for (Map.Entry<String, Object> entry : this.resultCache.entrySet()) {
            String key = entry.getKey();
            Object value = entry.getValue();
            boolean isLogValue = false;
            if (value != ":null") {
                if (value instanceof Integer) {
                    resultCode = resultCode + (Integer)value;
                    isLogValue = true;
                } else if (value instanceof ScriptResult && ((ScriptResult)value).getResult() instanceof Integer) {
                    resultCode = resultCode + (Integer)((ScriptResult)value).getResult();
                    isLogValue = true;
                }
            } else {
                isLogValue = true;
            }
            if (!this.logger.isInfoEnabled() || !isLogValue) continue;
            this.logger.info(" Script: {} result={}", (Object)key, value);
        }
        if (this.logger.isInfoEnabled()) {
            this.logger.info("Unique scripts executed: {}", (Object)this.resultCache.size());
            this.logger.info("Initial/Total = {}/{} ", (Object)initialCode, (Object)resultCode);
        }
        return resultCode;
    }
}

