/*
 * Decompiled with CFR 0.152.
 */
package com.epam.gmp.service;

import com.epam.dep.esp.common.json.JsonMapper;
import com.epam.gmp.GmpResourceUtils;
import com.epam.gmp.ScriptClassloader;
import com.epam.gmp.ScriptContext;
import com.epam.gmp.ScriptExecutionException;
import com.epam.gmp.ScriptInitializationException;
import com.epam.gmp.ScriptResult;
import com.epam.gmp.service.IGroovyScriptEngineService;
import groovy.lang.Binding;
import groovy.lang.Script;
import groovy.util.GroovyScriptEngine;
import groovy.util.ResourceException;
import groovy.util.ScriptException;
import java.io.IOException;
import java.io.PrintWriter;
import java.io.StringWriter;
import java.net.URL;
import java.util.ArrayList;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import javax.annotation.PostConstruct;
import javax.annotation.Resource;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.context.annotation.Scope;
import org.springframework.core.io.support.PathMatchingResourcePatternResolver;
import org.springframework.stereotype.Service;

@Service(value="GroovyScriptEngineService")
@Scope(value="singleton")
public class GroovyScriptEngineService
implements IGroovyScriptEngineService {
    public static final String SCRIPTS_FOLDER = "scripts";
    public static final String GROOVY_ROOT_FOLDER = "groovyRoot";
    public static final String LIB_FOLDER = "lib";
    public static final String NULL_RESULT = ":null";
    private static final Logger logger = LoggerFactory.getLogger(GroovyScriptEngineService.class);
    private Map<String, GroovyScriptEngine> gseCache;
    @Resource(name="gmpHomeResource")
    private org.springframework.core.io.Resource gmpHomeResource;
    @Resource(name="ResultMap")
    private Map<String, Object> resultMap;
    private org.springframework.core.io.Resource groovyRoot;

    @PostConstruct
    private void init() {
        this.gseCache = new ConcurrentHashMap<String, GroovyScriptEngine>();
        try {
            this.groovyRoot = GmpResourceUtils.getRelativeResource(this.gmpHomeResource, "/scripts/groovyRoot/");
        }
        catch (ScriptInitializationException e) {
            this.groovyRoot = null;
        }
    }

    public GroovyScriptEngine getEngine(org.springframework.core.io.Resource rootFolder) throws ScriptInitializationException {
        GroovyScriptEngine engine = this.gseCache.get(rootFolder.toString());
        try {
            if (engine == null) {
                URL[] roots = new URL[]{this.groovyRoot.exists() ? this.groovyRoot.getURL() : this.gmpHomeResource.getURL(), rootFolder.getURL()};
                ClassLoader scriptClassLoader = this.buildClassloader(rootFolder);
                engine = scriptClassLoader != null ? new GroovyScriptEngine(roots, scriptClassLoader) : new GroovyScriptEngine(roots, this.getClass().getClassLoader());
                this.gseCache.put(rootFolder.toString(), engine);
            }
            return engine;
        }
        catch (IOException e) {
            throw new ScriptInitializationException("Unable to initialize groovy root at: " + rootFolder, e);
        }
    }

    @Override
    public Script createScript(ScriptContext scriptContext) throws ScriptInitializationException {
        return this.createScript(scriptContext.getRoot(), scriptContext.getScriptName(), new Binding(scriptContext.getParams()));
    }

    @Override
    public Script createScript(org.springframework.core.io.Resource rootFolder, String scriptName, Binding binding) throws ScriptInitializationException {
        GroovyScriptEngine gse = this.getEngine(rootFolder);
        try {
            return gse.createScript(scriptName, binding);
        }
        catch (ResourceException e) {
            logger.trace("File not found for script: {}/{}", (Object)rootFolder, (Object)scriptName);
            return null;
        }
        catch (ScriptException e) {
            throw new ScriptInitializationException("Unable to initialize groovy script: " + scriptName, e);
        }
    }

    protected ClassLoader buildClassloader(org.springframework.core.io.Resource scriptPath) {
        ScriptClassloader scriptClassLoader;
        block7: {
            scriptClassLoader = null;
            try {
                org.springframework.core.io.Resource libPath = scriptPath.createRelative(LIB_FOLDER);
                if (libPath.exists()) {
                    PathMatchingResourcePatternResolver resolver = new PathMatchingResourcePatternResolver();
                    org.springframework.core.io.Resource[] jarResources = resolver.getResources(libPath.getURL() + "/*.jar");
                    ArrayList<URL> urls = new ArrayList<URL>();
                    for (org.springframework.core.io.Resource resource : jarResources) {
                        try {
                            urls.add(resource.getURL());
                        }
                        catch (IOException ex) {
                            if (!logger.isWarnEnabled()) continue;
                            logger.warn("Unable to resolve url for " + resource, (Throwable)ex);
                        }
                    }
                    URL[] aUrls = new URL[urls.size()];
                    scriptClassLoader = new ScriptClassloader(urls.toArray(aUrls), Thread.currentThread().getContextClassLoader());
                } else {
                    scriptClassLoader = new ScriptClassloader(new URL[0], Thread.currentThread().getContextClassLoader());
                }
            }
            catch (IOException e) {
                if (!logger.isErrorEnabled()) break block7;
                logger.error("unable to create relative LIB path.");
            }
        }
        return scriptClassLoader;
    }

    protected <T> void putResult(T result, ScriptContext scriptContext) {
        if (this.resultMap != null) {
            if (scriptContext.getScriptId() != null) {
                if (result != null) {
                    if (logger.isInfoEnabled()) {
                        logger.info("Internal cache put into: {}", (Object)scriptContext.getScriptId());
                    }
                    this.resultMap.put(scriptContext.getScriptId(), result);
                } else {
                    this.resultMap.put(scriptContext.getScriptId(), NULL_RESULT);
                }
            } else {
                logger.warn("Result key should not be NULL_RESULT!");
            }
        } else {
            logger.warn("Result storage should not be NULL_RESULT!");
        }
    }

    @Override
    public <R> ScriptResult<R> runScript(ScriptContext scriptContext) throws ScriptExecutionException {
        try {
            JsonMapper.getInstance().cleanCache();
            Script script = this.createScript(scriptContext);
            if (script != null) {
                if (logger.isInfoEnabled()) {
                    logger.info("Start script: <{}>", (Object)scriptContext.getScriptId());
                }
                Object scriptResult = script.run();
                logger.info("Script finished: <{}>={}", (Object)scriptContext.getScriptId(), (Object)(scriptResult == null ? NULL_RESULT : scriptResult.toString()));
                ScriptResult<Object> result = scriptResult instanceof ScriptResult ? (ScriptResult<Object>)scriptResult : new ScriptResult<Object>(scriptResult);
                this.putResult(result, scriptContext);
                return result;
            }
        }
        catch (Exception e) {
            if (logger.isErrorEnabled()) {
                StringWriter sw = new StringWriter();
                PrintWriter pw = new PrintWriter(sw);
                e.printStackTrace(pw);
                logger.error("Unable to run: '{}'  message: {}", (Object)scriptContext.getScriptName(), (Object)sw);
                this.putResult(1, scriptContext);
            }
            throw new ScriptExecutionException(e);
        }
        return null;
    }
}

