/*
 * Decompiled with CFR 0.152.
 */
package com.epam.gmp.service;

import com.epam.gmp.GmpResourceUtils;
import com.epam.gmp.ScriptContext;
import com.epam.gmp.ScriptContextException;
import com.epam.gmp.ScriptInitializationException;
import com.epam.gmp.service.ConfigLayer;
import com.epam.gmp.service.ConfigStackBuilder;
import com.epam.gmp.service.IGroovyScriptEngineService;
import com.epam.gmp.service.yaml.YamlLoader;
import groovy.lang.Binding;
import groovy.lang.Script;
import groovy.util.ConfigObject;
import groovy.util.ConfigSlurper;
import java.util.Collections;
import java.util.Deque;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.LinkedList;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import javax.annotation.Resource;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.context.annotation.Scope;
import org.springframework.stereotype.Service;
import org.springframework.util.StringUtils;

@Service(value="ScriptContextBuilder")
@Scope(value="singleton")
public class ScriptContextBuilder {
    public static final String CONFIG_SUFFIX = ".config.groovy";
    public static final String SCRIPT_SUFFIX = ".groovy";
    public static final String INCLUDE_CONFIG_FIELD = "includeConfig";
    public static final String INCLUDE_YAML_FIELD = "includeYaml";
    public static final String SCRIPT_CONFIG = "@scriptConfig";
    public static final String SCRIPT_TO_RUN = "script";
    public static final String EXECUTOR_FIELD = "EXECUTOR";
    private static final Logger logger = LoggerFactory.getLogger(ScriptContextBuilder.class);
    private static final String COMMON_CONFIG = "common-config.groovy";
    private static final String GLOBAL_CONFIG = "global-config.groovy";
    private static final String SCRIPTS_FOLDER = "scripts";
    public static final Pattern SCRIPT_PATTERN = Pattern.compile("([^@]*)[@](([^/]*)/((.*)[.]groovy))");
    public static final Pattern SCRIPT_FILE_PATTERN = Pattern.compile("(([^.]*)([.]config)?([.]groovy))");
    public static final String G_ENV = "gEnv";
    @Resource(name="ExportBindings")
    private Map<String, Object> bindingBeans;
    private Map<Class, Map<String, ConfigObject>> configCache = new ConcurrentHashMap<Class, Map<String, ConfigObject>>();
    @Resource(name="gmpHomeResource")
    private org.springframework.core.io.Resource gmpHome;
    @Autowired
    private IGroovyScriptEngineService groovyScriptEngineService;
    @Autowired
    private YamlLoader yamlLoader;

    public ScriptContext buildContextFor(String scriptPath, Map<String, Object> params) throws ScriptInitializationException {
        Matcher pathMatcher = SCRIPT_PATTERN.matcher(scriptPath);
        if (!pathMatcher.matches()) {
            throw new ScriptContextException("Unable to build context for: " + scriptPath);
        }
        org.springframework.core.io.Resource scriptGroupPath = GmpResourceUtils.getRelativeResource(this.gmpHome, "/scripts/" + pathMatcher.group(3) + "/");
        String scriptName = pathMatcher.group(4);
        String environment = pathMatcher.group(1);
        if (!scriptGroupPath.exists()) {
            throw new ScriptContextException("Script group folder doesn't exist: " + scriptGroupPath);
        }
        try {
            ConfigStackBuilder confBuilder = new ConfigStackBuilder();
            confBuilder.addLayer(new ConfigLayer(scriptGroupPath, GLOBAL_CONFIG));
            confBuilder.addLayer(new ConfigLayer(scriptGroupPath, COMMON_CONFIG));
            confBuilder.addLayer(new ConfigLayer(scriptGroupPath, scriptName));
            HashMap<String, String> scriptConfigParameters = new HashMap<String, String>();
            scriptConfigParameters.put(G_ENV, environment);
            ConfigObject scriptConfig = this.buildConfig(confBuilder.build(), environment, scriptConfigParameters);
            scriptName = ((Map)scriptConfig.get((Object)EXECUTOR_FIELD)).get(SCRIPT_TO_RUN).toString();
            scriptConfig.remove((Object)EXECUTOR_FIELD);
            HashMap<String, Object> paramMap = new HashMap<String, Object>();
            Logger scriptLogger = LoggerFactory.getLogger((String)scriptName.replaceAll("[.]", "_"));
            if (params != null) {
                paramMap.putAll(params);
            }
            paramMap.computeIfAbsent("cmdLine", key -> Collections.emptyList());
            paramMap.put("logger", scriptLogger);
            paramMap.put("gConfig", scriptConfig);
            paramMap.put(G_ENV, environment);
            if (logger.isInfoEnabled()) {
                logger.info("Groovy based script configuration:\n" + scriptName + ":" + this.configToString(scriptConfig));
            }
            return new ScriptContext(scriptPath, paramMap, scriptGroupPath, scriptName);
        }
        catch (ScriptInitializationException e) {
            throw new ScriptContextException("Unable to build context for: " + scriptPath, e);
        }
    }

    private void updateWithDefaultExecutor(ConfigObject scriptConfig, ConfigLayer layer) {
        Map executorConfig = (Map)scriptConfig.computeIfAbsent((Object)EXECUTOR_FIELD, key -> new HashMap());
        executorConfig.putIfAbsent(SCRIPT_TO_RUN, layer.getScriptToRun());
        executorConfig.put(SCRIPT_CONFIG, layer.getScriptConfig());
    }

    protected ConfigObject preProcessConfig(Deque<ConfigLayer> configStack, ConfigLayer layer, String environment, Map<String, Object> bindingMap) {
        ConfigObject scriptConfig;
        if (layer.getScript() != null) {
            scriptConfig = this.fillParamMapFromGroovy(layer.getScript(), environment, bindingMap);
            this.updateWithDefaultExecutor(scriptConfig, layer);
            Map executorConfig = (Map)scriptConfig.get((Object)EXECUTOR_FIELD);
            String yamlToInclude = null;
            if (!StringUtils.isEmpty(executorConfig.get(INCLUDE_CONFIG_FIELD))) {
                configStack.addFirst(new ConfigLayer(layer.getRoot(), executorConfig.get(INCLUDE_CONFIG_FIELD).toString()));
            }
            if (!StringUtils.isEmpty(executorConfig.get(INCLUDE_YAML_FIELD))) {
                yamlToInclude = executorConfig.get(INCLUDE_YAML_FIELD).toString();
            }
            if (!StringUtils.isEmpty(yamlToInclude)) {
                Map<String, Object> yamlObject = this.yamlLoader.getObject((Map<String, Object>)scriptConfig, layer.getRoot(), yamlToInclude);
                GmpConfigObject yamlCfg = new GmpConfigObject();
                yamlCfg.mapMerge(yamlObject);
                yamlCfg.mapMerge((Map)scriptConfig);
                scriptConfig = yamlCfg;
            }
        } else {
            scriptConfig = new ConfigObject();
            this.updateWithDefaultExecutor(scriptConfig, layer);
        }
        return scriptConfig;
    }

    protected ConfigObject assembleConfigForLayer(Deque<ConfigLayer> configStack, ConfigLayer layer, String environment, Map<String, Object> additionalBindings) throws ScriptInitializationException {
        Matcher fileNameMatcher = SCRIPT_FILE_PATTERN.matcher(layer.getScriptName());
        ConfigObject cfgObj = null;
        if (fileNameMatcher.matches()) {
            if (COMMON_CONFIG.equals(layer.getScriptName()) || GLOBAL_CONFIG.equals(layer.getScriptName())) {
                layer.setScriptConfig(layer.getScriptName());
                layer.setScriptToRun(null);
            } else if (fileNameMatcher.group(3) == null) {
                layer.setScriptConfig(fileNameMatcher.group(2) + CONFIG_SUFFIX);
                layer.setScriptToRun(layer.getScriptName());
            } else {
                layer.setScriptConfig(layer.getScriptName());
                layer.setScriptToRun(fileNameMatcher.group(2) + SCRIPT_SUFFIX);
            }
            layer.setScript(this.groovyScriptEngineService.createScript(layer.getRoot(), layer.getScriptConfig(), new Binding(this.bindingBeans)));
            LinkedHashMap<String, Object> bindingMap = new LinkedHashMap<String, Object>(this.bindingBeans);
            if (additionalBindings != null) {
                bindingMap.putAll(additionalBindings);
            }
            cfgObj = this.preProcessConfig(configStack, layer, environment, bindingMap);
        }
        return cfgObj;
    }

    protected ConfigObject buildConfig(Deque<ConfigLayer> configStack, String environment, Map additionalBindings) throws ScriptInitializationException {
        HashSet<String> processedConfigs = new HashSet<String>();
        LinkedList<ConfigObject> cfgObjStack = new LinkedList<ConfigObject>();
        ConfigObject resultConfig = new ConfigObject();
        while (!configStack.isEmpty()) {
            ConfigLayer cfgLayer = configStack.removeFirst();
            String curConfigPath = cfgLayer.getRoot().toString() + cfgLayer.getScriptName();
            if (processedConfigs.contains(curConfigPath)) continue;
            processedConfigs.add(curConfigPath);
            ConfigObject cfgObj = this.assembleConfigForLayer(configStack, cfgLayer, environment, additionalBindings);
            if (cfgObj == null) continue;
            cfgObjStack.addFirst(cfgObj);
        }
        do {
            ConfigObject cfgItem = (ConfigObject)cfgObjStack.removeFirst();
            resultConfig.merge(cfgItem);
        } while (!cfgObjStack.isEmpty());
        return resultConfig;
    }

    private ConfigObject fillParamMapFromGroovy(Script cfgScript, String environment, Map bindings) {
        if (cfgScript == null) {
            return null;
        }
        Map scriptConfigs = this.configCache.computeIfAbsent(cfgScript.getClass(), key -> new ConcurrentHashMap());
        ConfigObject configForEnvironment = scriptConfigs.computeIfAbsent(environment, key -> {
            ConfigSlurper configSlurper = new ConfigSlurper(key);
            configSlurper.setBinding(bindings);
            return configSlurper.parse(cfgScript);
        });
        return this.copyConfigObject(configForEnvironment);
    }

    private ConfigObject copyConfigObject(ConfigObject origin) {
        ConfigObject copy = new ConfigObject();
        origin.forEach((key, value) -> {
            if (value instanceof ConfigObject) {
                value = this.copyConfigObject((ConfigObject)value);
            }
            copy.put(key, value);
        });
        return copy;
    }

    private String configToString(ConfigObject cfg) {
        if (logger.isDebugEnabled()) {
            return cfg.toString();
        }
        return "Hidden, enable DEBUG level for component to see the data.";
    }

    class GmpConfigObject
    extends ConfigObject {
        GmpConfigObject() {
        }

        public Map mapMerge(Map other) {
            return this.doMerge((Map)((Object)this), other);
        }

        private Map doMerge(Map config, Map other) {
            Iterator iterator = other.entrySet().iterator();
            while (iterator.hasNext()) {
                Map.Entry o;
                Map.Entry next = o = iterator.next();
                Object key = next.getKey();
                Object value = next.getValue();
                Object configEntry = config.get(key);
                if (configEntry == null) {
                    config.put(key, value);
                    continue;
                }
                if (configEntry instanceof Map && !((Map)configEntry).isEmpty() && value instanceof Map) {
                    this.doMerge((Map)configEntry, (Map)value);
                    continue;
                }
                config.put(key, value);
            }
            return config;
        }
    }
}

