/*
 * Decompiled with CFR 0.152.
 */
package com.epam.gmp.service.yaml;

import com.epam.gmp.GmpResourceUtils;
import com.epam.gmp.ScriptInitializationException;
import com.epam.gmp.service.yaml.YamlLoaderContext;
import freemarker.cache.ClassTemplateLoader;
import freemarker.cache.MultiTemplateLoader;
import freemarker.cache.TemplateLoader;
import freemarker.cache.URLTemplateLoader;
import freemarker.template.Configuration;
import freemarker.template.Template;
import freemarker.template.TemplateException;
import freemarker.template.TemplateExceptionHandler;
import java.io.IOException;
import java.io.StringWriter;
import java.io.Writer;
import java.net.URL;
import org.springframework.core.io.Resource;

public class YamlFreemarkerEngine {
    private Configuration config;

    public YamlFreemarkerEngine(ClassLoader classLoader, String path, Resource baseFolder) throws IOException {
        Configuration cfg = new Configuration(Configuration.VERSION_2_3_25);
        TemplateLoader[] loaders = new TemplateLoader[]{new ClassTemplateLoader(classLoader, path), new GmpURLTemplateLoader(baseFolder)};
        cfg.setTemplateLoader((TemplateLoader)new MultiTemplateLoader(loaders));
        cfg.setDefaultEncoding("UTF-8");
        cfg.setTemplateExceptionHandler(TemplateExceptionHandler.RETHROW_HANDLER);
        this.config = cfg;
    }

    public String loadYaml(String templateName, YamlLoaderContext context) throws IOException, TemplateException {
        Template template = this.config.getTemplate(templateName);
        StringWriter out = new StringWriter();
        template.process(context.getParams(), (Writer)out);
        return out.toString();
    }

    public class GmpURLTemplateLoader
    extends URLTemplateLoader {
        Resource baseFolder;

        public GmpURLTemplateLoader(Resource baseFolder) {
            this.baseFolder = baseFolder;
        }

        protected URL getURL(String name) {
            try {
                return GmpResourceUtils.getRelativeResource(this.baseFolder, name).getURL();
            }
            catch (ScriptInitializationException | IOException exception) {
                return null;
            }
        }
    }
}

