/*
 * Decompiled with CFR 0.152.
 */
package com.epam.gmp.service.yaml;

import com.epam.gmp.ScriptInitializationException;
import com.epam.gmp.service.GMPContext;
import com.epam.gmp.service.GroovyScriptEngineService;
import com.epam.gmp.service.yaml.IYamlPreLoader;
import com.epam.gmp.service.yaml.IYamlPreProcessor;
import com.epam.gmp.service.yaml.YamlFreemarkerEngine;
import com.epam.gmp.service.yaml.YamlLoaderContext;
import freemarker.template.TemplateException;
import java.io.IOException;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import javax.annotation.PostConstruct;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.config.YamlMapFactoryBean;
import org.springframework.core.io.ByteArrayResource;
import org.springframework.core.io.Resource;
import org.springframework.stereotype.Service;

@Service
public class YamlLoader {
    private static final Logger logger = LoggerFactory.getLogger(YamlLoader.class);
    @Autowired
    private List<IYamlPreProcessor> yamlPreProcessors;
    @Autowired
    private List<IYamlPreLoader> yamlPreLoaders;
    Map<String, YamlFreemarkerEngine> yamlEngineCache;
    @Autowired
    GroovyScriptEngineService groovyScriptEngineService;

    @PostConstruct
    private void init() {
        this.yamlEngineCache = new HashMap<String, YamlFreemarkerEngine>();
    }

    public Map<String, Object> getObject(Map<String, Object> params, Resource baseFolder, String yamlFileName) {
        Map result = Collections.emptyMap();
        YamlFreemarkerEngine yamlFreemarkerEngine = this.yamlEngineCache.computeIfAbsent(baseFolder.toString(), key -> {
            try {
                return new YamlFreemarkerEngine(this.groovyScriptEngineService.getEngine(baseFolder).getParentClassLoader(), "", baseFolder);
            }
            catch (ScriptInitializationException | IOException e) {
                logger.error("Unable to create YamlFreemarkerEngine for {} ", (Object)baseFolder);
                return null;
            }
        });
        if (yamlFreemarkerEngine != null) {
            try {
                YamlLoaderContext context = (YamlLoaderContext)GMPContext.getApplicationContext().getBean(YamlLoaderContext.class, new Object[]{params});
                for (IYamlPreLoader iYamlPreLoader : this.yamlPreLoaders) {
                    iYamlPreLoader.preload(context);
                }
                String yamlStr = yamlFreemarkerEngine.loadYaml(yamlFileName, context);
                for (IYamlPreProcessor preProcessor : this.yamlPreProcessors) {
                    yamlStr = preProcessor.process(yamlStr, context);
                }
                YamlMapFactoryBean yamlMapFactoryBean = new YamlMapFactoryBean();
                yamlMapFactoryBean.setResources(new Resource[]{new ByteArrayResource(yamlStr.getBytes())});
                result = yamlMapFactoryBean.getObject();
            }
            catch (TemplateException | IOException e) {
                logger.error("Unable to load " + yamlFileName, e);
            }
        }
        return result;
    }
}

