/*
 * Decompiled with CFR 0.152.
 */
package com.epam.drill.integration.common.agent.impl;

import java.io.Closeable;
import java.io.File;
import java.io.FileOutputStream;
import java.io.InputStream;
import java.io.OutputStream;
import java.util.Enumeration;
import java.util.Iterator;
import java.util.zip.ZipEntry;
import java.util.zip.ZipFile;
import kotlin.Metadata;
import kotlin.Unit;
import kotlin.collections.CollectionsKt;
import kotlin.io.ByteStreamsKt;
import kotlin.io.CloseableKt;
import kotlin.io.FilesKt;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import kotlin.sequences.Sequence;
import kotlin.sequences.SequencesKt;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 9, 0}, k=2, xi=48, d1={"\u0000\u0016\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0002\b\u0004\u001a\u001c\u0010\u0000\u001a\u0004\u0018\u00010\u00012\n\u0010\u0002\u001a\u00060\u0001j\u0002`\u00032\u0006\u0010\u0004\u001a\u00020\u0005\u001a\u001e\u0010\u0006\u001a\u00060\u0001j\u0002`\u00032\u0006\u0010\u0007\u001a\u00020\u00012\n\u0010\b\u001a\u00060\u0001j\u0002`\u0003\u00a8\u0006\t"}, d2={"findFile", "Ljava/io/File;", "directory", "Lcom/epam/drill/integration/common/agent/Directory;", "fileExtension", "", "unzip", "zipFile", "destinationDir", "drill-cicd-common"})
@SourceDebugExtension(value={"SMAP\nFileUtils.kt\nKotlin\n*S Kotlin\n*F\n+ 1 FileUtils.kt\ncom/epam/drill/integration/common/agent/impl/FileUtilsKt\n+ 2 _Sequences.kt\nkotlin/sequences/SequencesKt___SequencesKt\n*L\n1#1,62:1\n1313#2,2:63\n*S KotlinDebug\n*F\n+ 1 FileUtils.kt\ncom/epam/drill/integration/common/agent/impl/FileUtilsKt\n*L\n49#1:63,2\n*E\n"})
public final class FileUtilsKt {
    @Nullable
    public static final File findFile(@NotNull File directory, @NotNull String fileExtension) {
        Intrinsics.checkNotNullParameter((Object)directory, (String)"directory");
        Intrinsics.checkNotNullParameter((Object)fileExtension, (String)"fileExtension");
        File[] fileArray = directory.listFiles();
        if (fileArray == null) {
            return null;
        }
        for (File file : fileArray) {
            if (file.isDirectory()) {
                Intrinsics.checkNotNull((Object)file);
                File result = FileUtilsKt.findFile(file, fileExtension);
                if (result == null) continue;
                return result;
            }
            Intrinsics.checkNotNull((Object)file);
            if (!Intrinsics.areEqual((Object)FilesKt.getExtension((File)file), (Object)fileExtension)) continue;
            return file;
        }
        return null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * WARNING - void declaration
     */
    @NotNull
    public static final File unzip(@NotNull File zipFile, @NotNull File destinationDir) {
        Intrinsics.checkNotNullParameter((Object)zipFile, (String)"zipFile");
        Intrinsics.checkNotNullParameter((Object)destinationDir, (String)"destinationDir");
        if (!zipFile.exists()) {
            throw new IllegalStateException("File " + zipFile + " doesn't exist");
        }
        File unzippedDir = new File(destinationDir, FilesKt.getNameWithoutExtension((File)zipFile));
        if (!unzippedDir.exists()) {
            unzippedDir.mkdirs();
        }
        Closeable closeable = new ZipFile(zipFile);
        Throwable throwable = null;
        try {
            void $this$forEach$iv;
            ZipFile zip = (ZipFile)closeable;
            boolean bl = false;
            Enumeration<? extends ZipEntry> enumeration = zip.entries();
            Intrinsics.checkNotNullExpressionValue(enumeration, (String)"entries(...)");
            Sequence sequence = SequencesKt.asSequence((Iterator)CollectionsKt.iterator(enumeration));
            boolean $i$f$forEach = false;
            for (Object element$iv : $this$forEach$iv) {
                ZipEntry entry = (ZipEntry)element$iv;
                boolean bl2 = false;
                if (entry.isDirectory()) {
                    new File(unzippedDir, entry.getName()).mkdirs();
                    continue;
                }
                Closeable closeable2 = zip.getInputStream(entry);
                Throwable throwable2 = null;
                try {
                    long l;
                    InputStream input = (InputStream)closeable2;
                    boolean bl3 = false;
                    Closeable closeable3 = new FileOutputStream(new File(unzippedDir, entry.getName()));
                    Throwable throwable3 = null;
                    try {
                        FileOutputStream output = (FileOutputStream)closeable3;
                        boolean bl4 = false;
                        Intrinsics.checkNotNull((Object)input);
                        l = ByteStreamsKt.copyTo$default((InputStream)input, (OutputStream)output, (int)0, (int)2, null);
                    }
                    catch (Throwable throwable4) {
                        throwable3 = throwable4;
                        throw throwable4;
                    }
                    finally {
                        CloseableKt.closeFinally((Closeable)closeable3, (Throwable)throwable3);
                    }
                    long l2 = l;
                }
                catch (Throwable throwable5) {
                    throwable2 = throwable5;
                    throw throwable5;
                }
                finally {
                    CloseableKt.closeFinally((Closeable)closeable2, (Throwable)throwable2);
                }
            }
            Unit unit = Unit.INSTANCE;
        }
        catch (Throwable throwable6) {
            throwable = throwable6;
            throw throwable6;
        }
        finally {
            CloseableKt.closeFinally((Closeable)closeable, (Throwable)throwable);
        }
        return unzippedDir;
    }
}

