/*
 * Decompiled with CFR 0.152.
 */
package com.epam.drill.integration.common.baseline;

import com.epam.drill.integration.common.baseline.BaselineFinder;
import com.epam.drill.integration.common.baseline.BaselineFinderByTag;
import com.epam.drill.integration.common.baseline.TagCriteria;
import com.epam.drill.integration.common.git.GitClient;
import com.epam.drill.integration.common.git.GitException;
import java.util.List;
import kotlin.Metadata;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.functions.Function0;
import kotlin.jvm.internal.Intrinsics;
import mu.KLogger;
import mu.KotlinLogging;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000$\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0002\b\u0002\u0018\u00002\b\u0012\u0004\u0012\u00020\u00020\u0001B\r\u0012\u0006\u0010\u0003\u001a\u00020\u0004\u00a2\u0006\u0002\u0010\u0005J\u0010\u0010\b\u001a\u00020\t2\u0006\u0010\n\u001a\u00020\u0002H\u0016R\u000e\u0010\u0003\u001a\u00020\u0004X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0006\u001a\u00020\u0007X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u000b"}, d2={"Lcom/epam/drill/integration/common/baseline/BaselineFinderByTag;", "Lcom/epam/drill/integration/common/baseline/BaselineFinder;", "Lcom/epam/drill/integration/common/baseline/TagCriteria;", "gitClient", "Lcom/epam/drill/integration/common/git/GitClient;", "(Lcom/epam/drill/integration/common/git/GitClient;)V", "logger", "Lmu/KLogger;", "findBaseline", "", "criteria", "drill-cicd-common"})
public final class BaselineFinderByTag
implements BaselineFinder<TagCriteria> {
    @NotNull
    private final GitClient gitClient;
    @NotNull
    private final KLogger logger;

    public BaselineFinderByTag(@NotNull GitClient gitClient) {
        Intrinsics.checkNotNullParameter((Object)gitClient, (String)"gitClient");
        this.gitClient = gitClient;
        this.logger = KotlinLogging.INSTANCE.logger((Function0)logger.1.INSTANCE);
    }

    @Override
    @NotNull
    public String findBaseline(@NotNull TagCriteria criteria) {
        String string;
        Intrinsics.checkNotNullParameter((Object)criteria, (String)"criteria");
        try {
            this.logger.info((Function0)new Function0<Object>(criteria){
                final /* synthetic */ TagCriteria $criteria;
                {
                    this.$criteria = $criteria;
                    super(0);
                }

                @Nullable
                public final Object invoke() {
                    return "Looking for git tag " + this.$criteria.getTagPattern() + "...";
                }
            });
            String tag = GitClient.DefaultImpls.describe$default(this.gitClient, false, true, 0, criteria.getTagPattern(), null, 21, null);
            string = (String)CollectionsKt.first((List)GitClient.DefaultImpls.revList$default(this.gitClient, tag, 0, 2, null));
        }
        catch (GitException e) {
            if (e.getExitCode() == 128) {
                throw new IllegalStateException("No git tags found matching pattern " + criteria.getTagPattern(), e);
            }
            throw e;
        }
        return string;
    }
}

