/*
 * Decompiled with CFR 0.152.
 */
package com.epam.drill.integration.common.git.impl;

import com.epam.drill.integration.common.git.GitClient;
import com.epam.drill.integration.common.git.GitCommitInfo;
import com.epam.drill.integration.common.git.GitException;
import com.epam.drill.integration.common.git.impl.GitClientImpl;
import java.io.BufferedReader;
import java.io.Closeable;
import java.io.File;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.Reader;
import java.nio.charset.Charset;
import java.util.Arrays;
import java.util.Collection;
import java.util.List;
import kotlin.Metadata;
import kotlin.collections.CollectionsKt;
import kotlin.io.CloseableKt;
import kotlin.io.TextStreamsKt;
import kotlin.jvm.functions.Function0;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import kotlin.text.Charsets;
import kotlin.text.StringsKt;
import mu.KLogger;
import mu.KotlinLogging;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000L\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0000\n\u0002\u0010\u000b\n\u0002\b\u0002\n\u0002\u0010\b\n\u0002\b\u0005\n\u0002\u0010\u0002\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010 \n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\u0018\u00002\u00020\u0001B\u0011\u0012\n\b\u0002\u0010\u0002\u001a\u0004\u0018\u00010\u0003\u00a2\u0006\u0002\u0010\u0004J4\u0010\u0007\u001a\u00020\b2\u0006\u0010\t\u001a\u00020\n2\u0006\u0010\u000b\u001a\u00020\n2\u0006\u0010\f\u001a\u00020\r2\b\u0010\u000e\u001a\u0004\u0018\u00010\b2\b\u0010\u000f\u001a\u0004\u0018\u00010\bH\u0016J\u0010\u0010\u0010\u001a\u00020\b2\u0006\u0010\u0011\u001a\u00020\bH\u0002J\u0017\u0010\u0012\u001a\u00020\u00132\b\u0010\u0014\u001a\u0004\u0018\u00010\rH\u0016\u00a2\u0006\u0002\u0010\u0015J\b\u0010\u0016\u001a\u00020\bH\u0016J\b\u0010\u0017\u001a\u00020\bH\u0016J\b\u0010\u0018\u001a\u00020\u0019H\u0016J\u0010\u0010\u001a\u001a\u00020\b2\u0006\u0010\u001b\u001a\u00020\bH\u0016J\u001e\u0010\u001c\u001a\b\u0012\u0004\u0012\u00020\b0\u001d2\u0006\u0010\u001e\u001a\u00020\b2\u0006\u0010\u001f\u001a\u00020\rH\u0016J\f\u0010 \u001a\u00020\b*\u00020!H\u0002R\u000e\u0010\u0005\u001a\u00020\u0006X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0010\u0010\u0002\u001a\u0004\u0018\u00010\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\""}, d2={"Lcom/epam/drill/integration/common/git/impl/GitClientImpl;", "Lcom/epam/drill/integration/common/git/GitClient;", "workingDir", "Ljava/io/File;", "(Ljava/io/File;)V", "logger", "Lmu/KLogger;", "describe", "", "all", "", "tags", "abbrev", "", "matchPattern", "excludePattern", "executeGitCommand", "command", "fetch", "", "depth", "(Ljava/lang/Integer;)V", "getCurrentCommitSha", "getGitBranch", "getGitCommitInfo", "Lcom/epam/drill/integration/common/git/GitCommitInfo;", "getMergeBaseCommitSha", "targetRef", "revList", "", "ref", "n", "readText", "Ljava/io/InputStream;", "drill-cicd-common"})
@SourceDebugExtension(value={"SMAP\nGitClientImpl.kt\nKotlin\n*S Kotlin\n*F\n+ 1 GitClientImpl.kt\ncom/epam/drill/integration/common/git/impl/GitClientImpl\n+ 2 fake.kt\nkotlin/jvm/internal/FakeKt\n+ 3 ArraysJVM.kt\nkotlin/collections/ArraysKt__ArraysJVMKt\n*L\n1#1,98:1\n1#2:99\n37#3,2:100\n*S KotlinDebug\n*F\n+ 1 GitClientImpl.kt\ncom/epam/drill/integration/common/git/impl/GitClientImpl\n*L\n84#1:100,2\n*E\n"})
public final class GitClientImpl
implements GitClient {
    @Nullable
    private final File workingDir;
    @NotNull
    private final KLogger logger;

    public GitClientImpl(@Nullable File workingDir) {
        this.workingDir = workingDir;
        this.logger = KotlinLogging.INSTANCE.logger((Function0)logger.1.INSTANCE);
    }

    public /* synthetic */ GitClientImpl(File file, int n, DefaultConstructorMarker defaultConstructorMarker) {
        if ((n & 1) != 0) {
            file = null;
        }
        this(file);
    }

    @Override
    @NotNull
    public String getCurrentCommitSha() {
        return this.executeGitCommand("git rev-parse HEAD");
    }

    @Override
    @NotNull
    public String describe(boolean all, boolean tags, int abbrev, @Nullable String matchPattern, @Nullable String excludePattern) {
        return this.executeGitCommand("git describe" + (all ? " --all" : "") + (tags ? " --tags" : "") + " --abbrev=" + abbrev + (matchPattern != null ? " --match=" + matchPattern : "") + (excludePattern != null ? " --exclude=" + excludePattern : ""));
    }

    @Override
    @NotNull
    public List<String> revList(@NotNull String ref, int n) {
        Intrinsics.checkNotNullParameter((Object)ref, (String)"ref");
        String[] stringArray = new String[]{"\n"};
        return StringsKt.split$default((CharSequence)this.executeGitCommand("git rev-list -n " + n + ' ' + ref), (String[])stringArray, (boolean)false, (int)0, (int)6, null);
    }

    @Override
    @NotNull
    public String getGitBranch() {
        return this.executeGitCommand("git rev-parse --abbrev-ref HEAD");
    }

    @Override
    @NotNull
    public GitCommitInfo getGitCommitInfo() {
        String[] stringArray = new String[]{"\n"};
        List commitDetails = StringsKt.split$default((CharSequence)this.executeGitCommand("git log -1 --pretty=format:%H%n%ad%n%an%n%B"), (String[])stringArray, (boolean)false, (int)0, (int)6, null);
        if (commitDetails.size() < 4) {
            throw new IllegalStateException("Failed to get commit log details");
        }
        return new GitCommitInfo((String)commitDetails.get(0), (String)commitDetails.get(1), (String)commitDetails.get(2), CollectionsKt.joinToString$default((Iterable)commitDetails.subList(3, commitDetails.size()), (CharSequence)"\n", null, null, (int)0, null, null, (int)62, null));
    }

    @Override
    @NotNull
    public String getMergeBaseCommitSha(@NotNull String targetRef) {
        Intrinsics.checkNotNullParameter((Object)targetRef, (String)"targetRef");
        return this.executeGitCommand("git merge-base HEAD " + targetRef);
    }

    @Override
    public void fetch(@Nullable Integer depth) {
        String string;
        String it = string = " --depth=" + depth;
        boolean bl = false;
        String string2 = depth != null && depth > 0 ? string : null;
        if (string2 == null) {
            string2 = "";
        }
        String depthParam = string2;
        this.executeGitCommand("git fetch" + depthParam);
    }

    private final String executeGitCommand(String command) {
        this.logger.info((Function0)new Function0<Object>(command, this){
            final /* synthetic */ String $command;
            final /* synthetic */ GitClientImpl this$0;
            {
                this.$command = $command;
                this.this$0 = $receiver;
                super(0);
            }

            @Nullable
            public final Object invoke() {
                Object object;
                StringBuilder stringBuilder;
                block3: {
                    block2: {
                        stringBuilder = new StringBuilder().append("Executing git command: ").append(this.$command).append(' ');
                        object = GitClientImpl.access$getWorkingDir$p(this.this$0);
                        if (object == null) break block2;
                        File it = object;
                        StringBuilder stringBuilder2 = stringBuilder;
                        boolean bl = false;
                        String string = "in " + it.getAbsolutePath();
                        stringBuilder = stringBuilder2;
                        object = string;
                        if (string != null) break block3;
                    }
                    object = "";
                }
                return stringBuilder.append((String)object).toString();
            }
        });
        String[] stringArray = new String[]{" "};
        Collection $this$toTypedArray$iv = StringsKt.split$default((CharSequence)command, (String[])stringArray, (boolean)false, (int)0, (int)6, null);
        boolean $i$f$toTypedArray = false;
        Collection thisCollection$iv = $this$toTypedArray$iv;
        String[] stringArray2 = thisCollection$iv.toArray(new String[0]);
        ProcessBuilder it = new ProcessBuilder(Arrays.copyOf(stringArray2, stringArray2.length));
        boolean bl = false;
        Process process = (this.workingDir != null ? it.directory(this.workingDir) : it).start();
        if (process.waitFor() != 0) {
            int n = process.exitValue();
            InputStream inputStream = process.getErrorStream();
            Intrinsics.checkNotNullExpressionValue((Object)inputStream, (String)"getErrorStream(...)");
            throw new GitException(command, n, this.readText(inputStream));
        }
        InputStream inputStream = process.getInputStream();
        Intrinsics.checkNotNullExpressionValue((Object)inputStream, (String)"getInputStream(...)");
        return this.readText(inputStream);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private final String readText(InputStream $this$readText) {
        Closeable closeable = $this$readText;
        Object object = Charsets.UTF_8;
        Object object2 = new InputStreamReader((InputStream)closeable, (Charset)object);
        int n = 8192;
        closeable = object2 instanceof BufferedReader ? (BufferedReader)object2 : new BufferedReader((Reader)object2, n);
        object = null;
        try {
            BufferedReader p0 = (BufferedReader)closeable;
            boolean bl = false;
            object2 = TextStreamsKt.readText((Reader)p0);
        }
        catch (Throwable throwable) {
            object = throwable;
            throw throwable;
        }
        finally {
            CloseableKt.closeFinally((Closeable)closeable, (Throwable)object);
        }
        return ((Object)StringsKt.trim((CharSequence)((CharSequence)object2))).toString();
    }

    public GitClientImpl() {
        this(null, 1, null);
    }

    public static final /* synthetic */ File access$getWorkingDir$p(GitClientImpl $this) {
        return $this.workingDir;
    }
}

