/*
 * Decompiled with CFR 0.152.
 */
package com.epam.drill.integration.common.util;

import java.util.List;
import kotlin.Metadata;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.internal.Intrinsics;
import kotlin.text.StringsKt;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 9, 0}, k=2, xi=48, d1={"\u0000\u0016\n\u0000\n\u0002\u0010\b\n\u0002\b\u0002\n\u0002\u0010 \n\u0002\u0010\u000e\n\u0002\b\b\u001a\u000f\u0010\u0000\u001a\u0004\u0018\u00010\u0001H\u0002\u00a2\u0006\u0002\u0010\u0002\u001a\f\u0010\u0003\u001a\b\u0012\u0004\u0012\u00020\u00050\u0004\u001a!\u0010\u0006\u001a\u0004\u0018\u00010\u0005\"\u0004\b\u0000\u0010\u0007*\u0004\u0018\u0001H\u00072\u0006\u0010\b\u001a\u00020\u0005\u00a2\u0006\u0002\u0010\t\u001a\u001f\u0010\n\u001a\u0002H\u0007\"\u0004\b\u0000\u0010\u0007*\u0004\u0018\u0001H\u00072\u0006\u0010\u000b\u001a\u00020\u0005\u00a2\u0006\u0002\u0010\f\u00a8\u0006\r"}, d2={"getCurrentJavaVersion", "", "()Ljava/lang/Integer;", "getJavaAddOpensOptions", "", "", "fromEnv", "T", "envVar", "(Ljava/lang/Object;Ljava/lang/String;)Ljava/lang/String;", "required", "name", "(Ljava/lang/Object;Ljava/lang/String;)Ljava/lang/Object;", "drill-cicd-common"})
public final class UtilsKt {
    public static final <T> T required(@Nullable T $this$required, @NotNull String name) {
        Intrinsics.checkNotNullParameter((Object)name, (String)"name");
        T t = $this$required;
        if (t == null) {
            throw new IllegalArgumentException("Property '" + name + "' is not set or null");
        }
        return t;
    }

    @Nullable
    public static final <T> String fromEnv(@Nullable T $this$fromEnv, @NotNull String envVar) {
        Intrinsics.checkNotNullParameter((Object)envVar, (String)"envVar");
        String string = System.getenv(envVar);
        if (string == null) {
            T t = $this$fromEnv;
            string = t != null ? t.toString() : null;
        }
        return string;
    }

    @NotNull
    public static final List<String> getJavaAddOpensOptions() {
        List list;
        Integer javaVersion = UtilsKt.getCurrentJavaVersion();
        if (javaVersion != null && javaVersion >= 17) {
            Object[] objectArray = new String[]{"--add-opens=java.base/java.util=ALL-UNNAMED", "--add-opens=java.base/java.lang=ALL-UNNAMED"};
            list = CollectionsKt.listOf((Object[])objectArray);
        } else {
            list = CollectionsKt.emptyList();
        }
        return list;
    }

    private static final Integer getCurrentJavaVersion() {
        String string = System.getProperty("java.version");
        Intrinsics.checkNotNullExpressionValue((Object)string, (String)"getProperty(...)");
        String[] stringArray = new String[]{"."};
        return StringsKt.toIntOrNull((String)((String)StringsKt.split$default((CharSequence)string, (String[])stringArray, (boolean)false, (int)0, (int)6, null).get(0)));
    }
}

