/*
 * Decompiled with CFR 0.152.
 */
package com.epam.healenium;

import com.epam.healenium.HealException;
import com.epam.healenium.PageAwareBy;
import com.epam.healenium.SelectorComponent;
import com.epam.healenium.annotation.DisableHealing;
import com.epam.healenium.client.RestClient;
import com.epam.healenium.model.HealingCandidateDto;
import com.epam.healenium.model.Locator;
import com.epam.healenium.model.MetricsDto;
import com.epam.healenium.treecomparing.HeuristicNodeDistance;
import com.epam.healenium.treecomparing.JsoupHTMLParser;
import com.epam.healenium.treecomparing.LCSPathDistance;
import com.epam.healenium.treecomparing.Node;
import com.epam.healenium.treecomparing.NodeBuilder;
import com.epam.healenium.treecomparing.NodeDistance;
import com.epam.healenium.treecomparing.Path;
import com.epam.healenium.treecomparing.PathDistance;
import com.epam.healenium.treecomparing.PathFinder;
import com.epam.healenium.treecomparing.Scored;
import com.epam.healenium.utils.ResourceReader;
import com.epam.healenium.utils.StackUtils;
import com.fasterxml.jackson.core.JsonParser;
import com.fasterxml.jackson.core.ObjectCodec;
import com.fasterxml.jackson.core.TreeNode;
import com.fasterxml.jackson.databind.JsonNode;
import com.fasterxml.jackson.databind.ObjectMapper;
import com.typesafe.config.Config;
import com.typesafe.config.ConfigFactory;
import com.typesafe.config.ConfigMergeable;
import java.io.ByteArrayInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.nio.charset.StandardCharsets;
import java.util.AbstractMap;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Comparator;
import java.util.EnumSet;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.Set;
import java.util.stream.Collectors;
import org.jetbrains.annotations.NotNull;
import org.openqa.selenium.By;
import org.openqa.selenium.JavascriptExecutor;
import org.openqa.selenium.WebDriver;
import org.openqa.selenium.WebElement;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class SelfHealingEngine {
    private static final Logger log = LoggerFactory.getLogger(SelfHealingEngine.class);
    private static final String SCRIPT = ResourceReader.readResource("itemsWithAttributes.js", s -> s.collect(Collectors.joining()));
    private static final Config DEFAULT_CONFIG = ConfigFactory.systemProperties().withFallback((ConfigMergeable)ConfigFactory.load((String)"healenium.properties").withFallback((ConfigMergeable)ConfigFactory.load()));
    private final Config config;
    private final WebDriver webDriver;
    private final int recoveryTries;
    private final double scoreCap;
    private final List<Set<SelectorComponent>> selectorDetailLevels;
    private final RestClient client;
    private String healingTime;

    public SelfHealingEngine(@NotNull WebDriver delegate, @NotNull Config config) {
        Config finalizedConfig = ConfigFactory.load((Config)config).withFallback((ConfigMergeable)DEFAULT_CONFIG);
        ArrayList<EnumSet<SelectorComponent>> temp = new ArrayList<EnumSet<SelectorComponent>>();
        temp.add(EnumSet.of(SelectorComponent.TAG, SelectorComponent.ID));
        temp.add(EnumSet.of(SelectorComponent.TAG, SelectorComponent.CLASS));
        temp.add(EnumSet.of(SelectorComponent.PARENT, SelectorComponent.TAG, SelectorComponent.ID, SelectorComponent.CLASS));
        temp.add(EnumSet.of(SelectorComponent.PARENT, SelectorComponent.TAG, SelectorComponent.CLASS, SelectorComponent.POSITION));
        temp.add(EnumSet.of(SelectorComponent.PARENT, SelectorComponent.TAG, SelectorComponent.ID, SelectorComponent.CLASS, SelectorComponent.ATTRIBUTES));
        temp.add(EnumSet.of(SelectorComponent.PATH));
        this.webDriver = delegate;
        this.config = finalizedConfig;
        this.recoveryTries = finalizedConfig.getInt("recovery-tries");
        this.scoreCap = finalizedConfig.getDouble("score-cap");
        this.selectorDetailLevels = Collections.unmodifiableList(temp);
        this.client = new RestClient(finalizedConfig);
    }

    public SelfHealingEngine(@NotNull WebDriver delegate) {
        this(delegate, DEFAULT_CONFIG);
    }

    public void saveElements(PageAwareBy by, List<WebElement> webElements) {
        List<List<Node>> nodesToSave = webElements.stream().map(this::getNodePath).collect(Collectors.toList());
        this.saveNodes(by, nodesToSave);
    }

    public void saveNodes(PageAwareBy key, List<List<Node>> elementsToSave) {
        this.client.selectorsRequest(key.getBy(), new ArrayList<List<Node>>(elementsToSave));
    }

    public List<Node> getNodePath(WebElement webElement) {
        JavascriptExecutor executor = (JavascriptExecutor)this.webDriver;
        String data = (String)executor.executeScript(SCRIPT, new Object[]{webElement});
        LinkedList<Node> path = new LinkedList<Node>();
        try {
            ObjectMapper mapper = new ObjectMapper();
            JsonNode treeNode = mapper.readTree(data);
            if (treeNode.isArray()) {
                for (JsonNode jsonNode : treeNode) {
                    Node node = this.toNode(mapper.treeAsTokens((TreeNode)jsonNode));
                    path.add(node);
                }
            }
        }
        catch (Exception ex) {
            log.error("Failed to get element node path!", (Throwable)ex);
        }
        return path;
    }

    private Node toNode(JsonParser parser) throws IOException {
        ObjectCodec codec = parser.getCodec();
        TreeNode tree = parser.readValueAsTree();
        String tag = (String)codec.treeToValue(tree.path("tag"), String.class);
        Integer index = (Integer)codec.treeToValue(tree.path("index"), Integer.class);
        String innerText = (String)codec.treeToValue(tree.path("innerText"), String.class);
        String id = (String)codec.treeToValue(tree.path("id"), String.class);
        Set classes = (Set)codec.treeToValue(tree.path("classes"), Set.class);
        Map attributes = (Map)codec.treeToValue(tree.path("other"), Map.class);
        return new NodeBuilder().setAttributes(attributes).setTag(tag).setIndex(index.intValue()).setId(id).addContent(innerText).setClasses(classes).build();
    }

    public List<Scored<By>> findNewLocations(String targetPage, List<Node> paths, MetricsDto metricsDto) {
        return this.findNearest(paths.toArray(new Node[0]), targetPage, metricsDto).stream().map(this::toLocator).collect(Collectors.toList());
    }

    private Scored<By> toLocator(Scored<Node> node) {
        for (Set<SelectorComponent> detailLevel : this.selectorDetailLevels) {
            By locator = this.construct((Node)node.getValue(), detailLevel);
            List elements = this.webDriver.findElements(locator);
            if (elements.size() != 1) continue;
            return new Scored(node.getScore(), (Object)locator);
        }
        throw new HealException();
    }

    public Optional<Scored<By>> toLocator(List<Locator> imitatedLocators, Double score) {
        for (Locator imitatedLocator : imitatedLocators) {
            By locator = StackUtils.BY_MAP.get(imitatedLocator.getType()).apply(imitatedLocator.getValue());
            List elements = this.webDriver.findElements(locator);
            if (elements.size() != 1) continue;
            return Optional.of(new Scored(score.doubleValue(), (Object)locator));
        }
        return Optional.empty();
    }

    private By construct(Node node, Set<SelectorComponent> detailLevel) {
        return By.cssSelector((String)detailLevel.stream().map(component -> component.createComponent(node)).collect(Collectors.joining()));
    }

    private List<Scored<Node>> findNearest(Node[] nodePath, String destinationTree, MetricsDto metricsDto) {
        long then = System.currentTimeMillis();
        Node destination = this.parseTree(destinationTree);
        PathFinder pathFinder = new PathFinder((PathDistance)new LCSPathDistance(), (NodeDistance)new HeuristicNodeDistance());
        AbstractMap.SimpleImmutableEntry scoresToNodes = pathFinder.findScoresToNodes(new Path(nodePath), destination);
        List scoreds = pathFinder.getSortedNodes((Map)scoresToNodes.getValue(), this.recoveryTries, this.scoreCap);
        this.healingTime = String.valueOf((double)(System.currentTimeMillis() - then) / 1000.0);
        this.collectMetrics(nodePath, scoresToNodes, scoreds, metricsDto);
        return scoreds;
    }

    private void collectMetrics(Node[] nodePath, AbstractMap.SimpleImmutableEntry<Integer, Map<Double, List<AbstractMap.SimpleImmutableEntry<Node, Integer>>>> curPathHeightToScores, List<Scored<Node>> scoreds, MetricsDto metricsDto) {
        Integer curPathHeight = curPathHeightToScores.getKey();
        Map<Double, List<AbstractMap.SimpleImmutableEntry<Node, Integer>>> scoresToNodes = curPathHeightToScores.getValue();
        List<HealingCandidateDto> allHealingCandidates = scoresToNodes.keySet().stream().sorted(Comparator.reverseOrder()).flatMap(score -> ((List)scoresToNodes.get(score)).stream().map(it -> new HealingCandidateDto((Double)score, (Integer)it.getValue(), curPathHeight, (Node)it.getKey()))).limit(10L).collect(Collectors.toList());
        HealingCandidateDto mainHealingCandidate = allHealingCandidates.stream().filter(candidate -> candidate.getScore().equals(((Scored)scoreds.get(0)).getScore()) && candidate.getNode().equals(((Scored)scoreds.get(0)).getValue())).findFirst().orElse(null);
        allHealingCandidates.remove(mainHealingCandidate);
        metricsDto.setTargetNode(new Path(nodePath).getLastNode()).setMainHealingCandidate(mainHealingCandidate).setOtherHealingCandidates(allHealingCandidates);
    }

    private Node parseTree(String tree) {
        return new JsoupHTMLParser().parse((InputStream)new ByteArrayInputStream(tree.getBytes(StandardCharsets.UTF_8)));
    }

    public boolean isHealingEnabled() {
        boolean isDisabled = StackUtils.isAnnotationPresent(DisableHealing.class);
        return this.config.getBoolean("heal-enabled") && !isDisabled;
    }

    public boolean isHealingBacklighted() {
        return this.config.getBoolean("backlight-healing");
    }

    public Config getConfig() {
        return this.config;
    }

    public WebDriver getWebDriver() {
        return this.webDriver;
    }

    public double getScoreCap() {
        return this.scoreCap;
    }

    public RestClient getClient() {
        return this.client;
    }

    public String getHealingTime() {
        return this.healingTime;
    }
}

