/*
 * Decompiled with CFR 0.152.
 */
package com.epam.healenium;

import com.epam.healenium.SelfHealingEngine;
import com.epam.healenium.client.RestClient;
import com.epam.healenium.handlers.proxy.SelfHealingProxyInvocationHandler;
import com.epam.healenium.service.HealingService;
import com.epam.healenium.service.NodeService;
import com.epam.healenium.utils.ProxyFactory;
import com.typesafe.config.Config;
import org.openqa.selenium.WebDriver;

public interface SelfHealingDriver
extends WebDriver {
    public SelfHealingEngine getCurrentEngine();

    public <T extends WebDriver> T getDelegate();

    public static SelfHealingDriver create(WebDriver delegate) {
        SelfHealingEngine selfHealingEngine = new SelfHealingEngine(delegate);
        SelfHealingDriver.setEngineFields(delegate, selfHealingEngine);
        return SelfHealingDriver.create(selfHealingEngine);
    }

    public static SelfHealingDriver create(WebDriver delegate, Config config) {
        SelfHealingEngine selfHealingEngine = new SelfHealingEngine(delegate, config);
        SelfHealingDriver.setEngineFields(delegate, selfHealingEngine);
        return SelfHealingDriver.create(selfHealingEngine);
    }

    public static void setEngineFields(WebDriver delegate, SelfHealingEngine selfHealingEngine) {
        Config finalizedConfig = selfHealingEngine.getConfig();
        selfHealingEngine.setClient(new RestClient(finalizedConfig));
        selfHealingEngine.setNodeService(new NodeService(delegate));
        selfHealingEngine.setHealingService(new HealingService(finalizedConfig, delegate));
    }

    public static SelfHealingDriver create(SelfHealingEngine engine) {
        ClassLoader classLoader = SelfHealingDriver.class.getClassLoader();
        Class<?> driverClass = engine.getWebDriver().getClass();
        SelfHealingProxyInvocationHandler handler = new SelfHealingProxyInvocationHandler(engine);
        return ProxyFactory.createDriverProxy(classLoader, handler, driverClass);
    }
}

