/*
 * Decompiled with CFR 0.152.
 */
package com.epam.healenium.processor;

import com.epam.healenium.SelfHealingEngine;
import com.epam.healenium.client.RestClient;
import com.epam.healenium.handlers.processor.ProcessorHandler;
import com.epam.healenium.model.Context;
import com.epam.healenium.service.HealingService;
import org.openqa.selenium.WebDriver;
import org.openqa.selenium.WebElement;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public abstract class BaseProcessor
implements ProcessorHandler {
    private static final Logger log = LoggerFactory.getLogger(BaseProcessor.class);
    protected BaseProcessor nextProcessor;
    protected Context context;
    protected SelfHealingEngine engine;
    protected RestClient restClient;
    protected WebDriver driver;
    protected WebElement delegateElement;
    protected HealingService healingService;

    public BaseProcessor() {
    }

    public BaseProcessor(BaseProcessor nextProcessor) {
        this.nextProcessor = nextProcessor;
    }

    public void process() {
        if (this.validate()) {
            this.execute();
            if (this.nextProcessor != null) {
                this.nextProcessor.setContext(this.context).setDriver(this.driver).setEngine(this.engine).setRestClient(this.restClient).setHealingService(this.healingService).setDelegateElement(this.delegateElement).process();
            }
        }
    }

    @Override
    public boolean validate() {
        return true;
    }

    @Override
    public abstract void execute();

    public BaseProcessor setContext(Context context) {
        this.context = context;
        return this;
    }

    public BaseProcessor setEngine(SelfHealingEngine engine) {
        this.engine = engine;
        return this;
    }

    public BaseProcessor setRestClient(RestClient restClient) {
        this.restClient = restClient;
        return this;
    }

    public BaseProcessor setDriver(WebDriver driver) {
        this.driver = driver;
        return this;
    }

    public BaseProcessor setDelegateElement(WebElement delegateElement) {
        this.delegateElement = delegateElement;
        return this;
    }

    public BaseProcessor setHealingService(HealingService healingService) {
        this.healingService = healingService;
        return this;
    }
}

