/*
 * Decompiled with CFR 0.152.
 */
package com.epam.healenium.converter;

import com.epam.healenium.treecomparing.Node;
import com.fasterxml.jackson.core.JsonGenerator;
import com.fasterxml.jackson.core.JsonToken;
import com.fasterxml.jackson.core.type.WritableTypeId;
import com.fasterxml.jackson.databind.JsonSerializer;
import com.fasterxml.jackson.databind.SerializerProvider;
import com.fasterxml.jackson.databind.jsontype.TypeSerializer;
import java.io.IOException;

public class NodeSerializer
extends JsonSerializer<Node> {
    public void serializeWithType(Node value, JsonGenerator gen, SerializerProvider serializers, TypeSerializer typeSer) throws IOException {
        WritableTypeId typeId = typeSer.typeId((Object)value, Node.class, JsonToken.START_OBJECT);
        typeSer.writeTypePrefix(gen, typeId);
        this.serialize(value, gen, serializers);
        typeSer.writeTypeSuffix(gen, typeId);
    }

    public void serialize(Node value, JsonGenerator gen, SerializerProvider serializers) throws IOException {
        gen.writeStartObject();
        gen.writeStringField("tag", value.getTag());
        gen.writeNumberField("index", value.getIndex().intValue());
        gen.writeStringField("innerText", value.getInnerText());
        gen.writeStringField("id", value.getId());
        gen.writeStringField("classes", String.join((CharSequence)" ", value.getClasses()));
        gen.writeObjectField("other", (Object)value.getOtherAttributes());
        gen.writeEndObject();
        gen.flush();
    }
}

