/*
 * Decompiled with CFR 0.152.
 */
package com.epam.healenium.processor;

import com.epam.healenium.model.Locator;
import com.epam.healenium.model.ReferenceElementsDto;
import com.epam.healenium.processor.BaseProcessor;
import com.epam.healenium.treecomparing.Node;
import com.epam.healenium.utils.SystemUtils;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class GetReferenceElementsProcessor
extends BaseProcessor {
    private static final Logger log = LoggerFactory.getLogger((String)"healenium");

    public GetReferenceElementsProcessor(BaseProcessor nextProcessor) {
        super(nextProcessor);
    }

    @Override
    public boolean validate() {
        boolean healingEnabled;
        String fullLocator;
        if (this.engine.getSessionContext().isWaitCommand()) {
            return false;
        }
        Locator locator = this.engine.getClient().getMapper().byToLocator(this.context.getBy());
        Map<String, String> enableHealingSelectors = this.engine.getSessionContext().getEnableHealingElements();
        Map<String, String> disableHealingSelector = this.engine.getSessionContext().getDisableHealingElement();
        if (disableHealingSelector.containsValue(fullLocator = locator.getType() + locator.getValue()) && "findElement".equals(this.context.getAction()) && (healingEnabled = this.isContains(disableHealingSelector))) {
            return false;
        }
        if (enableHealingSelectors.containsValue(fullLocator) && !"findElement".equals(this.context.getAction()) && (healingEnabled = this.isContains(enableHealingSelectors))) {
            return true;
        }
        if ("findElement".equals(this.context.getAction())) {
            return this.context.getNoSuchElementException() != null;
        }
        return this.engine.getSessionContext().isFindElementsAutoHealing();
    }

    @Override
    public void execute() {
        if (this.context.getNoSuchElementException() != null) {
            log.warn("Failed to find an element using locator {}", (Object)this.context.getBy().toString());
            log.warn("Reason: {}", (Object)this.context.getNoSuchElementException().getMessage());
        }
        this.populateUrlKey();
        ReferenceElementsDto referenceElementsDto = this.restClient.getReferenceElements(this.context.getBy(), this.context.getAction(), this.context.getCurrentUrl()).orElse(new ReferenceElementsDto().setPaths(new ArrayList<List<Node>>()));
        this.context.setReferenceElementsDto(referenceElementsDto);
        this.context.setUnsuccessfulLocators(referenceElementsDto.getUnsuccessfulLocators());
        Locator userLocator = this.restClient.getMapper().byToLocator(this.context.getBy());
        this.context.setUserLocator(userLocator);
    }

    private boolean isContains(Map<String, String> enableHealingSelectors) {
        this.populateUrlKey();
        String[] locatorParts = this.restClient.getMapper().getLocatorParts(this.context.getBy());
        String selectorId = SystemUtils.getMd5Hash(locatorParts[1].trim(), this.context.getAction(), this.context.getUrlKey());
        return enableHealingSelectors.containsKey(selectorId);
    }

    private void populateUrlKey() {
        if (this.context.getUrlKey() == null) {
            if (this.context.getCurrentUrl() == null) {
                this.context.setCurrentUrl(this.engine.getCurrentUrl());
            }
            String urlKey = this.engine.getSessionContext().getFunctionUrl().apply(this.engine, this.context.getCurrentUrl());
            this.context.setUrlKey(urlKey);
        }
    }
}

