/*
 * Decompiled with CFR 0.152.
 */
package com.epam.healenium.client;

import com.epam.healenium.converter.NodeDeserializer;
import com.epam.healenium.converter.NodeSerializer;
import com.epam.healenium.exception.HealeniumException;
import com.epam.healenium.mapper.HealeniumMapper;
import com.epam.healenium.model.ConfigSelectorDto;
import com.epam.healenium.model.Context;
import com.epam.healenium.model.HealedElement;
import com.epam.healenium.model.HealingResult;
import com.epam.healenium.model.Locator;
import com.epam.healenium.model.ReferenceElementsDto;
import com.epam.healenium.model.RequestDto;
import com.epam.healenium.model.SelectorImitatorDto;
import com.epam.healenium.treecomparing.Node;
import com.epam.healenium.treecomparing.Scored;
import com.epam.healenium.utils.SystemUtils;
import com.fasterxml.jackson.core.type.TypeReference;
import com.fasterxml.jackson.databind.DeserializationFeature;
import com.fasterxml.jackson.databind.JsonDeserializer;
import com.fasterxml.jackson.databind.JsonSerializer;
import com.fasterxml.jackson.databind.Module;
import com.fasterxml.jackson.databind.ObjectMapper;
import com.fasterxml.jackson.databind.module.SimpleModule;
import com.typesafe.config.Config;
import java.io.InputStream;
import java.io.UncheckedIOException;
import java.net.URL;
import java.nio.charset.StandardCharsets;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.Optional;
import java.util.stream.Collectors;
import org.openqa.selenium.By;
import org.openqa.selenium.remote.http.ClientConfig;
import org.openqa.selenium.remote.http.Contents;
import org.openqa.selenium.remote.http.HttpClient;
import org.openqa.selenium.remote.http.HttpMethod;
import org.openqa.selenium.remote.http.HttpRequest;
import org.openqa.selenium.remote.http.HttpResponse;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class RestClient {
    private static final Logger log = LoggerFactory.getLogger((String)"healenium");
    private final String serverUrl;
    private final String imitateUrl;
    private final String sessionKey;
    private ObjectMapper objectMapper = this.initMapper();
    private HealeniumMapper mapper;
    private HttpClient serverHttpClient;
    private HttpClient imitateHttpClient;

    public RestClient(Config config) {
        this.sessionKey = config.getString("sessionKey");
        this.serverUrl = this.getHttpUrl(config.getString("hlm.server.url"), "/healenium");
        this.imitateUrl = this.getHttpUrl(config.getString("hlm.imitator.url"), "/imitate");
        this.serverHttpClient = this.getHttpClient(this.serverUrl);
        this.imitateHttpClient = this.getHttpClient(this.imitateUrl);
        log.debug("[Init] sessionKey: {}, serverUrl: {}, imitateUrl: {}", new Object[]{this.sessionKey, this.serverUrl, this.imitateUrl});
    }

    private String getHttpUrl(String hlmServerUrl, String path) {
        return (hlmServerUrl.startsWith("http") ? hlmServerUrl : "http://".concat(hlmServerUrl)).concat(path);
    }

    private HttpClient getHttpClient(String url) {
        ClientConfig clientConfig = ClientConfig.defaultConfig().baseUrl(new URL(url));
        return HttpClient.Factory.createDefault().createClient(clientConfig);
    }

    private ObjectMapper initMapper() {
        SimpleModule module = new SimpleModule("node");
        module.addSerializer(Node.class, (JsonSerializer)new NodeSerializer());
        module.addDeserializer(Node.class, (JsonDeserializer)new NodeDeserializer());
        ObjectMapper mapper = new ObjectMapper().registerModule((Module)module);
        mapper.configure(DeserializationFeature.FAIL_ON_UNKNOWN_PROPERTIES, false);
        mapper.enable(DeserializationFeature.ACCEPT_EMPTY_STRING_AS_NULL_OBJECT);
        return mapper;
    }

    public void saveElements(RequestDto requestDto) {
        try {
            HttpRequest request = new HttpRequest(HttpMethod.POST, "");
            String content = this.objectMapper.writeValueAsString((Object)requestDto);
            byte[] data = content.getBytes(StandardCharsets.UTF_8);
            request.setHeader("Content-Length", String.valueOf(data.length));
            request.setHeader("Content-Type", "application/json; charset=utf-8");
            request.setContent(Contents.bytes((byte[])data));
            log.debug("[Save Elements] By: {}, Locator: {}, Command: {}, URL: {}", new Object[]{requestDto.getType(), requestDto.getLocator(), requestDto.getCommand(), requestDto.getUrl()});
            this.serverExecute(request);
        }
        catch (Exception e) {
            log.warn("[Save Elements] Error during call. Message: {}, Exception: {}", (Object)e.getMessage(), (Object)e.toString());
        }
    }

    public ConfigSelectorDto getElements() {
        ConfigSelectorDto configSelectorDto = null;
        try {
            HttpRequest request = new HttpRequest(HttpMethod.GET, "/elements");
            request.setHeader("Cache-Control", "no-cache");
            log.debug("[Get Elements] Request: {}", (Object)request);
            HttpResponse response = this.serverExecute(request);
            if (404 == response.getStatus()) {
                throw new RuntimeException("[Get Elements] Compatibility error. Hlm-backend service must be 3.3.0 and height.\nActual versions you can find here: https://github.com/healenium/healenium/blob/master/docker-compose-web.yaml");
            }
            Contents.Supplier result = response.getContent();
            configSelectorDto = (ConfigSelectorDto)this.objectMapper.readValue((InputStream)result.get(), (TypeReference)new TypeReference<ConfigSelectorDto>(){});
        }
        catch (RuntimeException e) {
            throw e;
        }
        catch (Exception e) {
            log.warn("[Get Elements] Error during call. Message: {}, Exception: {}", (Object)e.getMessage(), (Object)e.toString());
        }
        return configSelectorDto;
    }

    public void healRequest(Context context) {
        try {
            ArrayList<RequestDto> requestDtos = new ArrayList<RequestDto>();
            for (HealingResult healingResult : context.getHealingResults()) {
                List<Scored<By>> choices = healingResult.getHealedElements().stream().map(HealedElement::getScored).collect(Collectors.toList());
                if (choices.isEmpty()) {
                    return;
                }
                String metrics = this.objectMapper.writeValueAsString((Object)healingResult.getMetricsDto());
                requestDtos.add(this.mapper.buildMultRequest(context, healingResult, choices, metrics));
            }
            HttpRequest request = new HttpRequest(HttpMethod.POST, "/healing");
            String content = this.objectMapper.writeValueAsString(requestDtos);
            byte[] data = content.getBytes(StandardCharsets.UTF_8);
            request.setHeader("Content-Length", String.valueOf(data.length));
            request.setHeader("Content-Type", "application/json; charset=utf-8");
            request.setHeader("sessionKey", this.sessionKey);
            request.setHeader("hostProject", SystemUtils.getHostProjectName());
            request.setContent(Contents.bytes((byte[])data));
            for (RequestDto requestDto : requestDtos) {
                log.debug("[Save Healed Elements] {}", (Object)requestDto.getUsedResult().getLocator());
            }
            this.serverExecute(request);
        }
        catch (Exception e) {
            log.warn("[Heal Element] Error during call. Message: {}. Exception: {}", (Object)e.getMessage(), (Object)e.toString());
        }
    }

    public Optional<ReferenceElementsDto> getReferenceElements(By locator, String command, String currentUrl) {
        ReferenceElementsDto referenceElementsDto = null;
        RequestDto requestDto = this.mapper.buildDto(locator, command, currentUrl);
        try {
            HttpRequest request = new HttpRequest(HttpMethod.GET, "");
            ((HttpRequest)((HttpRequest)request.setHeader("Cache-Control", "no-cache")).setHeader("sessionKey", this.sessionKey)).addQueryParameter("locator", requestDto.getLocator()).addQueryParameter("className", requestDto.getClassName()).addQueryParameter("methodName", requestDto.getMethodName()).addQueryParameter("command", requestDto.getCommand()).addQueryParameter("url", currentUrl);
            log.debug("[Get Reference Elements] Request. Locator: {}, Command: {}, Url: {}", new Object[]{requestDto.getLocator(), requestDto.getCommand(), currentUrl});
            HttpResponse response = this.serverExecute(request);
            if (response.getStatus() == 200) {
                Contents.Supplier result = response.getContent();
                referenceElementsDto = (ReferenceElementsDto)this.objectMapper.readValue((InputStream)result.get(), (TypeReference)new TypeReference<ReferenceElementsDto>(){});
            }
        }
        catch (Exception e) {
            log.warn("[Get Reference Elements] Error during call. Message: {}. Exception: {}", (Object)e.getMessage(), (Object)e.toString());
        }
        return Optional.ofNullable(referenceElementsDto);
    }

    public List<Locator> imitate(SelectorImitatorDto selectorImitatorDto) {
        try {
            HttpRequest request = new HttpRequest(HttpMethod.POST, "");
            String content = this.objectMapper.writeValueAsString((Object)selectorImitatorDto);
            byte[] data = content.getBytes(StandardCharsets.UTF_8);
            request.setHeader("Content-Length", String.valueOf(data.length));
            request.setHeader("Content-Type", "application/json; charset=utf-8");
            request.setContent(Contents.bytes((byte[])data));
            HttpResponse response = this.imitateExecute(request);
            if (response.getStatus() == 200) {
                Contents.Supplier result = response.getContent();
                List locators = (List)this.objectMapper.readValue((InputStream)result.get(), (TypeReference)new TypeReference<List<Locator>>(){});
                log.debug("[Selector Imitate] Response: {}", (Object)locators);
                return locators;
            }
        }
        catch (Exception e) {
            log.warn("[Selector Imitate] Error during call. Message: {}, Exception: {}", (Object)e.getMessage(), (Object)e.toString());
        }
        return Collections.emptyList();
    }

    public void initReport(String sessionId) {
        try {
            HttpRequest request = new HttpRequest(HttpMethod.POST, "/report/init/" + sessionId);
            request.setHeader("Content-Type", "application/json; charset=utf-8");
            log.debug("[Init Report] Request: {}", (Object)request);
            this.serverExecute(request);
        }
        catch (Exception e) {
            log.warn("[Init Report] Error during call. Message: {}, Exception: {}", (Object)e.getMessage(), (Object)e.toString());
        }
    }

    private HttpResponse serverExecute(HttpRequest request) {
        try {
            return this.serverHttpClient.execute(request);
        }
        catch (UncheckedIOException e) {
            String errorMessage = "[Execute Error] Unable to connect to the hlm-backend service. Please check if the service is up and running, and verify that the connection URL is correct.";
            log.error(errorMessage);
            throw new HealeniumException(errorMessage, e);
        }
    }

    private HttpResponse imitateExecute(HttpRequest request) {
        try {
            return this.imitateHttpClient.execute(request);
        }
        catch (UncheckedIOException e) {
            String errorMessage = "[Execute Error] Unable to connect to the selector-imitator service. Please check if the service is up and running, and verify that the connection URL is correct.";
            log.error(errorMessage);
            throw new HealeniumException(errorMessage, e);
        }
    }

    public String getServerUrl() {
        return this.serverUrl;
    }

    public String getImitateUrl() {
        return this.imitateUrl;
    }

    public String getSessionKey() {
        return this.sessionKey;
    }

    public ObjectMapper getObjectMapper() {
        return this.objectMapper;
    }

    public HealeniumMapper getMapper() {
        return this.mapper;
    }

    public HttpClient getServerHttpClient() {
        return this.serverHttpClient;
    }

    public HttpClient getImitateHttpClient() {
        return this.imitateHttpClient;
    }

    public void setObjectMapper(ObjectMapper objectMapper) {
        this.objectMapper = objectMapper;
    }

    public void setMapper(HealeniumMapper mapper) {
        this.mapper = mapper;
    }

    public void setServerHttpClient(HttpClient serverHttpClient) {
        this.serverHttpClient = serverHttpClient;
    }

    public void setImitateHttpClient(HttpClient imitateHttpClient) {
        this.imitateHttpClient = imitateHttpClient;
    }

    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof RestClient)) {
            return false;
        }
        RestClient other = (RestClient)o;
        if (!other.canEqual(this)) {
            return false;
        }
        String this$serverUrl = this.getServerUrl();
        String other$serverUrl = other.getServerUrl();
        if (this$serverUrl == null ? other$serverUrl != null : !this$serverUrl.equals(other$serverUrl)) {
            return false;
        }
        String this$imitateUrl = this.getImitateUrl();
        String other$imitateUrl = other.getImitateUrl();
        if (this$imitateUrl == null ? other$imitateUrl != null : !this$imitateUrl.equals(other$imitateUrl)) {
            return false;
        }
        String this$sessionKey = this.getSessionKey();
        String other$sessionKey = other.getSessionKey();
        if (this$sessionKey == null ? other$sessionKey != null : !this$sessionKey.equals(other$sessionKey)) {
            return false;
        }
        ObjectMapper this$objectMapper = this.getObjectMapper();
        ObjectMapper other$objectMapper = other.getObjectMapper();
        if (this$objectMapper == null ? other$objectMapper != null : !this$objectMapper.equals(other$objectMapper)) {
            return false;
        }
        HealeniumMapper this$mapper = this.getMapper();
        HealeniumMapper other$mapper = other.getMapper();
        if (this$mapper == null ? other$mapper != null : !this$mapper.equals(other$mapper)) {
            return false;
        }
        HttpClient this$serverHttpClient = this.getServerHttpClient();
        HttpClient other$serverHttpClient = other.getServerHttpClient();
        if (this$serverHttpClient == null ? other$serverHttpClient != null : !this$serverHttpClient.equals(other$serverHttpClient)) {
            return false;
        }
        HttpClient this$imitateHttpClient = this.getImitateHttpClient();
        HttpClient other$imitateHttpClient = other.getImitateHttpClient();
        return !(this$imitateHttpClient == null ? other$imitateHttpClient != null : !this$imitateHttpClient.equals(other$imitateHttpClient));
    }

    protected boolean canEqual(Object other) {
        return other instanceof RestClient;
    }

    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        String $serverUrl = this.getServerUrl();
        result = result * 59 + ($serverUrl == null ? 43 : $serverUrl.hashCode());
        String $imitateUrl = this.getImitateUrl();
        result = result * 59 + ($imitateUrl == null ? 43 : $imitateUrl.hashCode());
        String $sessionKey = this.getSessionKey();
        result = result * 59 + ($sessionKey == null ? 43 : $sessionKey.hashCode());
        ObjectMapper $objectMapper = this.getObjectMapper();
        result = result * 59 + ($objectMapper == null ? 43 : $objectMapper.hashCode());
        HealeniumMapper $mapper = this.getMapper();
        result = result * 59 + ($mapper == null ? 43 : $mapper.hashCode());
        HttpClient $serverHttpClient = this.getServerHttpClient();
        result = result * 59 + ($serverHttpClient == null ? 43 : $serverHttpClient.hashCode());
        HttpClient $imitateHttpClient = this.getImitateHttpClient();
        result = result * 59 + ($imitateHttpClient == null ? 43 : $imitateHttpClient.hashCode());
        return result;
    }

    public String toString() {
        return "RestClient(serverUrl=" + this.getServerUrl() + ", imitateUrl=" + this.getImitateUrl() + ", sessionKey=" + this.getSessionKey() + ", objectMapper=" + this.getObjectMapper() + ", mapper=" + this.getMapper() + ", serverHttpClient=" + this.getServerHttpClient() + ", imitateHttpClient=" + this.getImitateHttpClient() + ")";
    }
}

