/*
 * Decompiled with CFR 0.152.
 */
package com.epam.healenium.service;

import com.epam.healenium.model.Context;
import com.epam.healenium.treecomparing.Node;
import com.epam.healenium.treecomparing.NodeBuilder;
import com.epam.healenium.utils.ResourceReader;
import com.fasterxml.jackson.core.JsonParser;
import com.fasterxml.jackson.core.ObjectCodec;
import com.fasterxml.jackson.core.TreeNode;
import com.fasterxml.jackson.databind.JsonNode;
import com.fasterxml.jackson.databind.ObjectMapper;
import java.io.IOException;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.stream.Collectors;
import org.openqa.selenium.JavascriptExecutor;
import org.openqa.selenium.WebDriver;
import org.openqa.selenium.WebElement;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class NodeService {
    private static final Logger log = LoggerFactory.getLogger((String)"healenium");
    private static final String SCRIPT = ResourceReader.readResource("itemsWithAttributes.js", s -> s.collect(Collectors.joining()));

    public List<Node> getNodePath(WebDriver driver, WebElement webElement, Context context) {
        JavascriptExecutor executor = (JavascriptExecutor)driver;
        String data = (String)executor.executeScript(SCRIPT, new Object[]{webElement});
        LinkedList<Node> path = new LinkedList<Node>();
        try {
            ObjectMapper mapper = new ObjectMapper();
            JsonNode treeNode = mapper.readTree(data);
            context.setCurrentUrl(treeNode.get("url").textValue());
            JsonNode items = treeNode.get("items");
            if (items.isArray()) {
                for (JsonNode jsonNode : items) {
                    Node node = this.toNode(mapper.treeAsTokens((TreeNode)jsonNode));
                    path.add(node);
                }
            }
        }
        catch (Exception ex) {
            log.error("Failed to get element node path!", (Throwable)ex);
        }
        return path;
    }

    private Node toNode(JsonParser parser) throws IOException {
        ObjectCodec codec = parser.getCodec();
        TreeNode tree = parser.readValueAsTree();
        String tag = (String)codec.treeToValue(tree.path("tag"), String.class);
        Integer index = (Integer)codec.treeToValue(tree.path("index"), Integer.class);
        String innerText = (String)codec.treeToValue(tree.path("innerText"), String.class);
        String id = (String)codec.treeToValue(tree.path("id"), String.class);
        Set classes = (Set)codec.treeToValue(tree.path("classes"), Set.class);
        Map attributes = (Map)codec.treeToValue(tree.path("other"), Map.class);
        return new NodeBuilder().setAttributes(attributes).setTag(tag).setIndex(index.intValue()).setId(id).addContent(innerText).setClasses(classes).build();
    }
}

