/*
 * Decompiled with CFR 0.152.
 */
package com.epam.healenium.elementcreators;

import com.epam.healenium.elementcreators.ElementCreator;
import com.epam.healenium.treecomparing.Node;
import java.util.regex.Pattern;
import org.apache.commons.lang3.StringUtils;

public class IdElementCreator
implements ElementCreator {
    private static final Pattern SAFE_HASH_ID = Pattern.compile("^-?[A-Za-z_][A-Za-z0-9_-]*$");

    @Override
    public String create(Node node) {
        String id = StringUtils.trimToNull((String)node.getId());
        if (id == null) {
            return "";
        }
        if (IdElementCreator.isHashSafe(id)) {
            return "#" + id;
        }
        return "[id=\"" + IdElementCreator.escapeAttrValue(id) + "\"]";
    }

    private static boolean isHashSafe(String id) {
        return SAFE_HASH_ID.matcher(id).matches();
    }

    private static String escapeAttrValue(String s) {
        return s.replace("\\", "\\\\").replace("\"", "\\\"");
    }
}

