/*
 * Decompiled with CFR 0.152.
 */
package com.epam.healenium.mojo;

import com.epam.healenium.client.HealingClient;
import com.epam.healenium.extension.ReportHelper;
import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.nio.file.FileVisitOption;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.nio.file.StandardCopyOption;
import java.nio.file.attribute.FileAttribute;
import java.util.Optional;
import java.util.Properties;
import java.util.stream.Stream;
import org.apache.maven.model.Build;
import org.apache.maven.model.Model;
import org.apache.maven.plugin.AbstractMojo;
import org.apache.maven.plugins.annotations.LifecyclePhase;
import org.apache.maven.plugins.annotations.Mojo;
import org.apache.maven.plugins.annotations.Parameter;
import org.apache.maven.project.MavenProject;

@Mojo(name="initReport", defaultPhase=LifecyclePhase.TEST)
public class InitReportMojo
extends AbstractMojo {
    private final String configFile = "/healenium.properties";
    @Parameter(readonly=true, defaultValue="${project}")
    private MavenProject project;

    public void execute() {
        Model model = this.project.getModel();
        Build build = model.getBuild();
        String targetDir = build.getDirectory() + "/classes";
        String sourceDir = this.project.getBasedir().getPath() + "/src/test/resources";
        this.findConfig(targetDir, sourceDir).ifPresent(it -> {
            try {
                Properties configProperty = ReportHelper.loadConfig(it);
                this.normalizeProperties(configProperty);
                String serverHost = configProperty.getProperty("serverHost", "localhost");
                Integer serverPort = this.stringToInteger(configProperty.getProperty("serverPort", "7878"));
                this.getLog().info((CharSequence)("Healenium server Port = " + serverPort));
                this.getLog().info((CharSequence)("Healenium server Host = " + serverHost));
                HealingClient client = new HealingClient(serverHost, serverPort);
                String sessionKey = client.initReport();
                this.getLog().info((CharSequence)("sessionKey= " + sessionKey));
                if (sessionKey == null || sessionKey.isEmpty()) {
                    this.getLog().warn((CharSequence)"Couldn't obtain session key from server!");
                    return;
                }
                configProperty.setProperty("sessionKey", sessionKey);
                configProperty.setProperty("serverHost", serverHost);
                configProperty.setProperty("serverPort", serverPort.toString());
                this.uploadConfig((File)it, configProperty);
            }
            catch (Exception ex) {
                this.getLog().error((CharSequence)"Failed to perform init action", (Throwable)ex);
            }
        });
    }

    private Optional<File> findConfig(String targetDir, String sourceDir) {
        Optional<String> result = Optional.empty();
        try (Stream<Path> walk2 = Files.walk(Paths.get(targetDir.toString(), new String[0]), new FileVisitOption[0]);){
            result = walk2.filter(x$0 -> Files.isRegularFile(x$0, new LinkOption[0])).map(Path::toString).filter(it -> it.endsWith("/healenium.properties")).findFirst();
        }
        catch (Exception walk2) {
            // empty catch block
        }
        File file = result.map(File::new).orElseGet(() -> {
            Path fromPath = Paths.get(String.valueOf(sourceDir), "/healenium.properties");
            Path toPath = Paths.get(String.valueOf(targetDir), "/healenium.properties");
            try {
                Files.createDirectories(toPath.getParent(), new FileAttribute[0]);
                if (Files.exists(Paths.get(sourceDir + "/healenium.properties", new String[0]), new LinkOption[0])) {
                    Files.copy(fromPath, toPath, StandardCopyOption.REPLACE_EXISTING);
                } else {
                    Files.createFile(toPath, new FileAttribute[0]);
                }
                return Paths.get(targetDir + "/healenium.properties", new String[0]).toFile();
            }
            catch (IOException ex) {
                this.getLog().error((CharSequence)"Failed to create config file", (Throwable)ex);
                return null;
            }
        });
        return Optional.ofNullable(file);
    }

    private void normalizeProperties(Properties configProperty) {
        for (String name : configProperty.stringPropertyNames()) {
            String value = configProperty.getProperty(name);
            if (value == null || value.isEmpty()) {
                configProperty.remove(name);
                continue;
            }
            if (!name.equals(";")) continue;
            configProperty.remove(name);
            configProperty.setProperty(name.concat(value.substring(0, value.indexOf("=")).replaceAll("\\s+", "")), value.substring(value.indexOf("=") + 1).trim());
        }
    }

    private void uploadConfig(File file, Properties properties) {
        try {
            FileOutputStream fileOut = new FileOutputStream(file);
            properties.store(fileOut, "\n");
            fileOut.close();
        }
        catch (IOException ex) {
            this.getLog().error((CharSequence)"Failed to append data", (Throwable)ex);
        }
    }

    public Integer stringToInteger(String inputString) {
        return inputString == null || inputString.isEmpty() ? null : Integer.valueOf(Integer.parseInt(inputString));
    }
}

