/*
 * Decompiled with CFR 0.152.
 */
package com.epam.healenium.treecomparing;

import com.epam.healenium.treecomparing.Node;
import com.epam.healenium.treecomparing.NodeDistance;
import com.epam.healenium.treecomparing.Path;
import com.epam.healenium.treecomparing.PathDistance;
import com.epam.healenium.treecomparing.Scored;
import com.epam.healenium.treecomparing.StreamUtils;
import com.epam.healenium.treecomparing.Utils;
import java.util.AbstractMap;
import java.util.ArrayDeque;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Comparator;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class PathFinder {
    private static final Logger log = LoggerFactory.getLogger(PathFinder.class);
    private final PathDistance pathDistance;
    private final NodeDistance nodeDistance;

    public PathFinder(PathDistance pathDistance, NodeDistance nodeDistance) {
        this.pathDistance = pathDistance;
        this.nodeDistance = nodeDistance;
    }

    public Node findNearest(Path path, Node newSource) {
        List<Scored<Node>> found = this.find(path, newSource, 1);
        return found.isEmpty() ? null : found.get(0).getValue();
    }

    public List<Scored<Node>> find(Path path, Node newSource, int bestGuessesCount) {
        return this.getSortedNodes(this.findScoresToNodes(path, newSource).getValue(), bestGuessesCount, -1.0);
    }

    public AbstractMap.SimpleImmutableEntry<Integer, Map<Double, List<AbstractMap.SimpleImmutableEntry<Node, Integer>>>> findScoresToNodes(Path path, Node newSource) {
        List<Path> destinationLeaves = this.findAllLeafPaths(newSource);
        Node byPath = path.getLastNode();
        int pathLength = path.getNodes().length;
        ArrayList<AbstractMap.SimpleImmutableEntry<Path, Integer>> paths = new ArrayList<AbstractMap.SimpleImmutableEntry<Path, Integer>>();
        int maxLCSDistance = 0;
        for (Path destinationLeaf : destinationLeaves) {
            int distance = this.pathDistance.distance(path, destinationLeaf);
            if (distance < 1) continue;
            maxLCSDistance = Math.max(maxLCSDistance, distance);
            paths.add(new AbstractMap.SimpleImmutableEntry<Path, Integer>(destinationLeaf, distance));
        }
        int pathLengthToCheck = Math.min(maxLCSDistance, pathLength);
        Map<Double, List<AbstractMap.SimpleImmutableEntry>> scoresToNodes = paths.stream().map(pathPair -> new AbstractMap.SimpleImmutableEntry<Node[], Integer>(Arrays.copyOfRange(((Path)pathPair.getKey()).getNodes(), (Integer)pathPair.getValue() - 1, ((Path)pathPair.getKey()).getNodes().length), (Integer)pathPair.getValue())).flatMap(pathPair -> Arrays.stream((Node[])pathPair.getKey()).map(it -> new AbstractMap.SimpleImmutableEntry<Node, Integer>((Node)it, (Integer)pathPair.getValue()))).collect(Collectors.groupingBy(nodePair -> this.nodeDistance.distance(byPath, (Node)nodePair.getKey(), (Integer)nodePair.getValue(), pathLengthToCheck)));
        return new AbstractMap.SimpleImmutableEntry<Integer, Map<Double, List<AbstractMap.SimpleImmutableEntry<Node, Integer>>>>(pathLengthToCheck, scoresToNodes);
    }

    public List<Scored<Node>> getSortedNodes(Map<Double, List<AbstractMap.SimpleImmutableEntry<Node, Integer>>> scoresToNodes, int bestGuessesCount, double guessCap) {
        int nodeLimit = this.normalizeLimit(bestGuessesCount);
        double scoreLimit = this.normalizeScoreCap(guessCap);
        return scoresToNodes.keySet().stream().sorted(Comparator.reverseOrder()).filter(StreamUtils.logFiltered(score -> score >= scoreLimit, score -> log.debug("Skipping nodes, because their score={} less then {}", score, (Object)scoreLimit))).flatMap(score -> ((List)scoresToNodes.get(score)).stream().map(it -> new Scored<Node>((double)score, (Node)it.getKey()))).limit(nodeLimit).collect(Collectors.toList());
    }

    private List<Path> findAllLeafPaths(Node node) {
        ArrayList<Path> paths = new ArrayList<Path>();
        this.addLeafPath(paths, new Path(node));
        return paths;
    }

    private void addLeafPath(List<Path> leaves, Path current) {
        ArrayDeque<Path> paths = new ArrayDeque<Path>();
        paths.addFirst(current);
        while (!paths.isEmpty()) {
            Path path = (Path)paths.removeLast();
            Node node = path.getLastNode();
            if (node.getChildren() == null || node.getChildren().isEmpty()) {
                leaves.add(path);
                continue;
            }
            for (Node child : node.getChildren()) {
                paths.addFirst(Utils.addNode(path, child));
            }
        }
    }

    private double normalizeScoreCap(double value) {
        if (value > 1.0) {
            log.warn("Required min score value={} will be ignored, because exceed allowed value. It must be in range [0..1]", (Object)value);
            return -1.0;
        }
        return value;
    }

    private int normalizeLimit(int value) {
        if (value < 0) {
            log.warn("Desired number of result nodes={} will be reset to 1, because it must be positive", (Object)value);
            return 1;
        }
        return value;
    }
}

