/*
 * Decompiled with CFR 0.152.
 */
package com.epam.http;

import com.epam.http.logger.HTTPLogger;
import com.epam.http.logger.ILogger;
import com.epam.http.logger.LogLevels;
import com.jdiai.tools.PropertyReader;
import java.util.HashMap;
import java.util.Map;

public class JdiHttpSettings {
    public static String TEST_PROPERTIES_PATH = "test.properties";
    public static ILogger logger = HTTPLogger.instance("JDI");
    public static Map<String, String> DOMAIN = new HashMap<String, String>();

    public static String getDomain() {
        return !DOMAIN.isEmpty() ? DOMAIN.get("domain") : "No Domain Found. Use test.properties or WebSettings.DOMAIN";
    }

    public static String getDomain(String domainId) {
        return !DOMAIN.isEmpty() ? DOMAIN.getOrDefault(domainId, "No Domain Found. Use test.properties.") : "No Domain Found. Use test.properties.";
    }

    public static void setDomain(String domain) {
        String[] params = domain.trim().split(",");
        if (domain.contains("=")) {
            for (String p : params) {
                String[] pairs = p.split("=");
                DOMAIN.put(pairs[0].trim(), pairs[1]);
            }
        } else {
            DOMAIN.put("domain", domain);
        }
    }

    public static synchronized void init() {
        PropertyReader.getProperties((String)TEST_PROPERTIES_PATH);
        PropertyReader.fillAction(JdiHttpSettings::setDomain, (String)"domain");
        PropertyReader.fillAction(p -> logger.setLogLevel(LogLevels.parseLogLevel(p)), (String)"log.level");
    }
}

