/*
 * Decompiled with CFR 0.152.
 */
package com.epam.http.logger;

import com.epam.http.logger.LogLevels;
import io.qameta.allure.Allure;
import io.qameta.allure.aspects.StepsAspects;
import io.qameta.allure.model.Status;
import io.qameta.allure.model.StepResult;
import java.util.UUID;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class AllureLogger {
    public static boolean writeToAllure = StepsAspects.getLifecycle().getCurrentTestCase().isPresent();

    public static void setAllureRootLogLevel(LogLevels level) {
        Logger logger = LoggerFactory.getLogger((String)"ROOT");
        if (logger instanceof ch.qos.logback.classic.Logger) {
            ((ch.qos.logback.classic.Logger)logger).setLevel(LogLevels.getLogbackLevel(level));
        }
    }

    public static String startStep(String message, String requestData) {
        if (!writeToAllure) {
            return "";
        }
        StepResult step = new StepResult().setName(message).setStatus(Status.PASSED);
        String uuid = UUID.randomUUID().toString();
        StepsAspects.getLifecycle().startStep(uuid, step);
        AllureLogger.attachRequest(message, requestData);
        return uuid;
    }

    public static void failStep() {
        if (!writeToAllure) {
            return;
        }
        StepsAspects.getLifecycle().updateStep(s -> s.setStatus(Status.FAILED));
        StepsAspects.getLifecycle().stopStep();
    }

    public static void passStep(String responseData, String uuid) {
        if (!writeToAllure || StringUtils.isBlank((CharSequence)uuid)) {
            return;
        }
        StepsAspects.getLifecycle().updateStep(uuid, s -> s.setStatus(Status.PASSED));
        AllureLogger.attachResponse(responseData);
        StepsAspects.getLifecycle().stopStep();
    }

    public static void attachRequest(String message, String requestData) {
        if (!writeToAllure) {
            return;
        }
        Allure.addAttachment((String)("Request " + message), (String)"text/html", (String)requestData, (String)"json");
    }

    public static void attachResponse(String responseData) {
        if (!writeToAllure) {
            return;
        }
        Allure.addAttachment((String)"Response", (String)"text/html", (String)responseData, (String)"json");
    }
}

