/*
 * Decompiled with CFR 0.152.
 */
package com.epam.http.logger;

import ch.qos.logback.classic.Level;
import com.epam.http.logger.AllureLogger;
import com.epam.http.logger.ILogger;
import com.epam.http.logger.LogLevels;
import com.jdiai.tools.Safe;
import com.jdiai.tools.StringUtils;
import com.jdiai.tools.func.JAction;
import com.jdiai.tools.func.JFunc;
import com.jdiai.tools.map.MapArray;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.apache.logging.log4j.Marker;
import org.apache.logging.log4j.MarkerManager;
import org.apache.logging.log4j.core.config.Configurator;
import org.slf4j.LoggerFactory;

public class HTTPLogger
implements ILogger {
    private static MapArray<String, HTTPLogger> loggers = new MapArray();
    private static Marker jdiMarker = MarkerManager.getMarker((String)"JDI");
    private Safe<LogLevels> logLevel = new Safe((Object)LogLevels.INFO);
    private Safe<Integer> logOffDeepness = new Safe((Object)0);
    private String name;
    private Logger logger;

    public static HTTPLogger instance(String name) {
        if (!loggers.has((Object)name)) {
            loggers.add((Object)name, (Object)new HTTPLogger(name));
        }
        return (HTTPLogger)loggers.get((Object)name);
    }

    public HTTPLogger() {
        this("JDI");
    }

    public HTTPLogger(String name) {
        this.logger = LogManager.getLogger((String)name);
        this.name = name;
        this.setLogLevel(LogLevels.INFO);
    }

    public HTTPLogger(Class clazz) {
        this(clazz.getSimpleName());
    }

    @Override
    public LogLevels getLogLevel() {
        return (LogLevels)((Object)this.logLevel.get());
    }

    @Override
    public void setLogLevel(LogLevels level) {
        this.logLevel = new Safe((Object)level);
        if (LoggerFactory.getLogger((String)this.name) instanceof ch.qos.logback.classic.Logger) {
            HTTPLogger.setLogbackLevel(this.name, LogLevels.getLogbackLevel(level));
        } else {
            Configurator.setRootLevel((org.apache.logging.log4j.Level)LogLevels.getLog4j2Level(level));
            Configurator.setLevel((String)this.name, (org.apache.logging.log4j.Level)LogLevels.getLog4j2Level(level));
        }
        AllureLogger.setAllureRootLogLevel(level);
    }

    public static void setLogbackLevel(String loggerName, Level level) {
        ch.qos.logback.classic.Logger logger = (ch.qos.logback.classic.Logger)LoggerFactory.getLogger((String)loggerName);
        logger.setLevel(level);
    }

    @Override
    public void logOff() {
        this.logLevel.set((Object)LogLevels.OFF);
        this.logOffDeepness.update(v -> v + 1);
    }

    @Override
    public void logOn() {
        this.logOffDeepness.update(v -> v - 1);
        if ((Integer)this.logOffDeepness.get() > 0) {
            return;
        }
        if ((Integer)this.logOffDeepness.get() == 0) {
            this.logLevel.reset();
        }
        if ((Integer)this.logOffDeepness.get() < 0) {
            throw new RuntimeException("Log Off Deepness to high. Please check that each logOff has appropriate logOn");
        }
    }

    @Override
    public void dropLogOff() {
        this.logOffDeepness.set((Object)0);
        this.logLevel.reset();
    }

    @Override
    public void logOff(JAction action) {
        this.logOff(() -> {
            action.invoke();
            return null;
        });
    }

    @Override
    public <T> T logOff(JFunc<T> func) {
        Object result;
        LogLevels tempLevel = (LogLevels)((Object)this.logLevel.get());
        if (this.logLevel.get() == LogLevels.OFF) {
            try {
                return (T)func.invoke();
            }
            catch (Exception ex) {
                throw new RuntimeException(ex);
            }
        }
        this.logLevel.set((Object)LogLevels.OFF);
        try {
            result = func.invoke();
        }
        catch (Exception ex) {
            throw new RuntimeException(ex);
        }
        this.logLevel.set((Object)tempLevel);
        return (T)result;
    }

    private String getRecord(String record, Object ... args) {
        return StringUtils.format((String)record, (Object[])args);
    }

    public String getName() {
        return this.name;
    }

    @Override
    public void step(String s, Object ... args) {
        if (((LogLevels)((Object)this.logLevel.get())).equalOrLessThan(LogLevels.STEP)) {
            this.logger.log(org.apache.logging.log4j.Level.forName((String)"STEP", (int)350), jdiMarker, this.getRecord(s, args));
        }
    }

    public void trace(String s, Object ... args) {
        if (((LogLevels)((Object)this.logLevel.get())).equalOrLessThan(LogLevels.TRACE)) {
            this.logger.trace(jdiMarker, this.getRecord(s, args));
        }
    }

    @Override
    public void debug(String s, Object ... args) {
        if (((LogLevels)((Object)this.logLevel.get())).equalOrLessThan(LogLevels.DEBUG)) {
            this.logger.debug(jdiMarker, this.getRecord(s, args));
        }
    }

    @Override
    public void info(String s, Object ... args) {
        if (((LogLevels)((Object)this.logLevel.get())).equalOrLessThan(LogLevels.INFO)) {
            this.logger.info(jdiMarker, this.getRecord(s, args));
        }
    }

    @Override
    public void error(String s, Object ... args) {
        this.logger.error(jdiMarker, this.getRecord(s, args));
    }

    @Override
    public void toLog(String msg) {
        this.toLog(msg, (LogLevels)((Object)this.logLevel.getDefault()));
    }

    @Override
    public void toLog(String msg, LogLevels level) {
        if (((LogLevels)((Object)this.logLevel.get())).equalOrLessThan(level)) {
            switch (level) {
                case ERROR: {
                    this.error(msg, new Object[0]);
                    break;
                }
                case STEP: {
                    this.step(msg, new Object[0]);
                    break;
                }
                case INFO: {
                    this.info(msg, new Object[0]);
                    break;
                }
                case DEBUG: {
                    this.debug(msg, new Object[0]);
                    break;
                }
                case OFF: {
                    break;
                }
                default: {
                    throw new RuntimeException("Unknown log level: " + (Object)((Object)level));
                }
            }
        }
    }
}

