/*
 * Decompiled with CFR 0.152.
 */
package com.epam.http.logger;

import ch.qos.logback.classic.Level;
import com.jdiai.tools.LinqUtils;
import java.util.Arrays;
import java.util.List;

public enum LogLevels {
    OFF(0),
    FATAL(100),
    ERROR(200),
    WARNING(300),
    STEP(350),
    INFO(400),
    DEBUG(500),
    TRACE(600),
    ALL(Integer.MAX_VALUE);

    private final int level;
    private static final List<org.apache.logging.log4j.Level> allLog4J2Levels;
    private static final List<Level> allLogbackLevels;

    private LogLevels(int level) {
        this.level = level;
    }

    public int getLevel() {
        return this.level;
    }

    public boolean equalOrLessThan(LogLevels level) {
        return this.getLevel() >= level.getLevel();
    }

    public boolean equalOrMoreThan(LogLevels level) {
        return this.getLevel() <= level.getLevel();
    }

    public static org.apache.logging.log4j.Level getLog4j2Level(LogLevels level) {
        return (org.apache.logging.log4j.Level)LinqUtils.first(allLog4J2Levels, l -> l.intLevel() >= level.level);
    }

    public static Level getLogbackLevel(LogLevels level) {
        return Level.toLevel((String)level.name());
    }

    public static LogLevels parseLogLevel(String logLevel) {
        switch (logLevel) {
            case "OFF": {
                return OFF;
            }
            case "FATAL": {
                return FATAL;
            }
            case "ERROR": {
                return ERROR;
            }
            case "WARNING": {
                return WARNING;
            }
            case "STEP": {
                return STEP;
            }
            case "DEBUG": {
                return DEBUG;
            }
            case "TRACE": {
                return TRACE;
            }
            case "ALL": {
                return ALL;
            }
        }
        return INFO;
    }

    static {
        allLog4J2Levels = Arrays.asList(org.apache.logging.log4j.Level.OFF, org.apache.logging.log4j.Level.FATAL, org.apache.logging.log4j.Level.ERROR, org.apache.logging.log4j.Level.WARN, org.apache.logging.log4j.Level.INFO, org.apache.logging.log4j.Level.DEBUG, org.apache.logging.log4j.Level.TRACE, org.apache.logging.log4j.Level.ALL);
        allLogbackLevels = Arrays.asList(Level.OFF, Level.ERROR, Level.ERROR, Level.WARN, Level.INFO, Level.DEBUG, Level.TRACE, Level.ALL);
    }
}

