/*
 * Decompiled with CFR 0.152.
 */
package com.epam.http.performance;

import com.epam.http.JdiHttpSettings;
import com.epam.http.performance.ThreadResult;
import java.util.List;

public class PerformanceResult {
    public long minResponseTime = 0L;
    public long maxResponseTime = 0L;
    public long averageResponseTime = 0L;
    public long numberOfRequests = 0L;
    public long numberOfFails = 0L;
    public long numberOfClientFails = 0L;
    public long numberOfServerFails = 0L;

    public boolean noFails() {
        return this.numberOfFails == 0L;
    }

    public void aggregateResult(List<ThreadResult> results) {
        results.forEach(res -> {
            this.minResponseTime = this.minResponseTime == 0L ? res.getMinResponseTime() : Math.min(this.minResponseTime, res.getMinResponseTime());
            this.maxResponseTime = Math.max(this.maxResponseTime, res.getMaxResponseTime());
            this.averageResponseTime = (this.averageResponseTime * this.numberOfRequests + res.getAverageResponseTime()) / (this.numberOfRequests + 1L);
            this.numberOfRequests += res.getNumberOfRequests();
            this.numberOfClientFails += res.getNumberOfClientFails();
            this.numberOfServerFails += res.getNumberOfServerFails();
            this.numberOfFails = this.numberOfClientFails + this.numberOfServerFails;
        });
        JdiHttpSettings.logger.info("Performance test results:", new Object[0]);
        JdiHttpSettings.logger.info("Threads count: " + results.size(), new Object[0]);
        JdiHttpSettings.logger.info("Requests count: " + this.numberOfRequests, new Object[0]);
        JdiHttpSettings.logger.info("Average response time: " + this.averageResponseTime, new Object[0]);
        JdiHttpSettings.logger.info("Minimum response time: " + this.minResponseTime, new Object[0]);
        JdiHttpSettings.logger.info("Maximum response time: " + this.maxResponseTime, new Object[0]);
        if (!this.noFails()) {
            JdiHttpSettings.logger.info("Fails count: " + this.numberOfFails, new Object[0]);
            JdiHttpSettings.logger.info("Client fails count: " + this.numberOfClientFails, new Object[0]);
            JdiHttpSettings.logger.info("Server fails count: " + this.numberOfServerFails, new Object[0]);
        }
    }

    public long getMinResponseTime() {
        return this.minResponseTime;
    }

    public long getMaxResponseTime() {
        return this.maxResponseTime;
    }

    public long getAverageResponseTime() {
        return this.averageResponseTime;
    }

    public long getNumberOfRequests() {
        return this.numberOfRequests;
    }

    public long getNumberOfFails() {
        return this.numberOfFails;
    }

    public long getNumberOfClientFails() {
        return this.numberOfClientFails;
    }

    public long getNumberOfServerFails() {
        return this.numberOfServerFails;
    }

    public void setMinResponseTime(long minResponseTime) {
        this.minResponseTime = minResponseTime;
    }

    public void setMaxResponseTime(long maxResponseTime) {
        this.maxResponseTime = maxResponseTime;
    }

    public void setAverageResponseTime(long averageResponseTime) {
        this.averageResponseTime = averageResponseTime;
    }

    public void setNumberOfRequests(long numberOfRequests) {
        this.numberOfRequests = numberOfRequests;
    }

    public void setNumberOfFails(long numberOfFails) {
        this.numberOfFails = numberOfFails;
    }

    public void setNumberOfClientFails(long numberOfClientFails) {
        this.numberOfClientFails = numberOfClientFails;
    }

    public void setNumberOfServerFails(long numberOfServerFails) {
        this.numberOfServerFails = numberOfServerFails;
    }

    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof PerformanceResult)) {
            return false;
        }
        PerformanceResult other = (PerformanceResult)o;
        if (!other.canEqual(this)) {
            return false;
        }
        if (this.getMinResponseTime() != other.getMinResponseTime()) {
            return false;
        }
        if (this.getMaxResponseTime() != other.getMaxResponseTime()) {
            return false;
        }
        if (this.getAverageResponseTime() != other.getAverageResponseTime()) {
            return false;
        }
        if (this.getNumberOfRequests() != other.getNumberOfRequests()) {
            return false;
        }
        if (this.getNumberOfFails() != other.getNumberOfFails()) {
            return false;
        }
        if (this.getNumberOfClientFails() != other.getNumberOfClientFails()) {
            return false;
        }
        return this.getNumberOfServerFails() == other.getNumberOfServerFails();
    }

    protected boolean canEqual(Object other) {
        return other instanceof PerformanceResult;
    }

    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        long $minResponseTime = this.getMinResponseTime();
        result = result * 59 + (int)($minResponseTime >>> 32 ^ $minResponseTime);
        long $maxResponseTime = this.getMaxResponseTime();
        result = result * 59 + (int)($maxResponseTime >>> 32 ^ $maxResponseTime);
        long $averageResponseTime = this.getAverageResponseTime();
        result = result * 59 + (int)($averageResponseTime >>> 32 ^ $averageResponseTime);
        long $numberOfRequests = this.getNumberOfRequests();
        result = result * 59 + (int)($numberOfRequests >>> 32 ^ $numberOfRequests);
        long $numberOfFails = this.getNumberOfFails();
        result = result * 59 + (int)($numberOfFails >>> 32 ^ $numberOfFails);
        long $numberOfClientFails = this.getNumberOfClientFails();
        result = result * 59 + (int)($numberOfClientFails >>> 32 ^ $numberOfClientFails);
        long $numberOfServerFails = this.getNumberOfServerFails();
        result = result * 59 + (int)($numberOfServerFails >>> 32 ^ $numberOfServerFails);
        return result;
    }

    public String toString() {
        return "PerformanceResult(minResponseTime=" + this.getMinResponseTime() + ", maxResponseTime=" + this.getMaxResponseTime() + ", averageResponseTime=" + this.getAverageResponseTime() + ", numberOfRequests=" + this.getNumberOfRequests() + ", numberOfFails=" + this.getNumberOfFails() + ", numberOfClientFails=" + this.getNumberOfClientFails() + ", numberOfServerFails=" + this.getNumberOfServerFails() + ")";
    }
}

