/*
 * Decompiled with CFR 0.152.
 */
package com.epam.http.performance;

import com.epam.http.JdiHttpSettings;
import com.epam.http.performance.PerformanceResult;
import com.epam.http.performance.ThreadResult;
import com.epam.http.requests.RestMethod;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.Random;
import java.util.concurrent.Callable;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import java.util.concurrent.Future;
import java.util.stream.IntStream;

public class RestLoad {
    private static PerformanceResult loadService(int concurrentThreads, RunnableLoadService runnableLoadService) throws InterruptedException {
        ExecutorService executor = Executors.newFixedThreadPool(concurrentThreads);
        ArrayList tasks = new ArrayList();
        ArrayList<ThreadResult> threadResults = new ArrayList<ThreadResult>();
        IntStream.rangeClosed(1, concurrentThreads).forEach(e -> tasks.add(runnableLoadService.clone()));
        List results = executor.invokeAll(tasks);
        PerformanceResult pr = new PerformanceResult();
        executor.shutdown();
        for (Future result : results) {
            try {
                threadResults.add((ThreadResult)result.get());
            }
            catch (ExecutionException e2) {
                JdiHttpSettings.logger.error(e2.getMessage(), new Object[0]);
            }
        }
        pr.aggregateResult(threadResults);
        return pr;
    }

    public static PerformanceResult loadService(int concurrentThreads, long liveTimeInSec, RestMethod ... requests) throws InterruptedException {
        return RestLoad.loadService(concurrentThreads, new RunnableLoadService(liveTimeInSec, requests));
    }

    public static PerformanceResult loadService(long liveTimeInSec, RestMethod ... requests) throws InterruptedException {
        return RestLoad.loadService(1, liveTimeInSec, requests);
    }

    public static PerformanceResult loadService(int concurrentThreads, long liveTimeInSec, Map<RestMethod, Integer> weightRequests) throws InterruptedException {
        return RestLoad.loadService(concurrentThreads, new RunnableLoadService(liveTimeInSec, weightRequests));
    }

    public static PerformanceResult loadService(long liveTimeInSec, Map<RestMethod, Integer> weightRequests) throws InterruptedException {
        return RestLoad.loadService(1, liveTimeInSec, weightRequests);
    }

    private static int getLength(Map<RestMethod, Integer> wightRequests) {
        int Length = 0;
        for (Map.Entry<RestMethod, Integer> pair : wightRequests.entrySet()) {
            Length += pair.getValue().intValue();
        }
        return Length;
    }

    private static RestMethod getRequest(Map<RestMethod, Integer> wightRequests, int num) {
        if (wightRequests == null || wightRequests.size() == 0) {
            return null;
        }
        int Sum = 0;
        for (Map.Entry<RestMethod, Integer> pair : wightRequests.entrySet()) {
            if ((Sum += pair.getValue().intValue()) < num) continue;
            return pair.getKey();
        }
        return null;
    }

    static class RunnableLoadService
    implements Callable<ThreadResult>,
    Cloneable {
        private final long liveTimeInSec;
        private Map<RestMethod, Integer> weightRequests;
        private RestMethod[] restMethods;

        RunnableLoadService(long liveTimeInSec, RestMethod ... restMethods) {
            this.liveTimeInSec = liveTimeInSec;
            this.restMethods = restMethods;
        }

        RunnableLoadService(long liveTimeInSec, Map<RestMethod, Integer> weightRequests) {
            this.liveTimeInSec = liveTimeInSec;
            this.weightRequests = weightRequests;
        }

        public RunnableLoadService clone() {
            try {
                return (RunnableLoadService)super.clone();
            }
            catch (CloneNotSupportedException e) {
                return null;
            }
        }

        RestMethod getRestMethod() {
            Random rnd = new Random();
            if (this.weightRequests != null) {
                return RestLoad.getRequest(this.weightRequests, Math.round(rnd.nextFloat() * (float)RestLoad.getLength(this.weightRequests)));
            }
            return this.restMethods[rnd.nextInt(this.restMethods.length)];
        }

        @Override
        public ThreadResult call() {
            JdiHttpSettings.logger.info(Thread.currentThread().getName() + " started.", new Object[0]);
            ThreadResult result = new ThreadResult();
            long start = System.currentTimeMillis();
            do {
                result.addResult(this.getRestMethod().call());
            } while (System.currentTimeMillis() - start < this.liveTimeInSec * 1000L);
            JdiHttpSettings.logger.info(Thread.currentThread().getName() + " finished.", new Object[0]);
            return result;
        }
    }
}

