/*
 * Decompiled with CFR 0.152.
 */
package com.epam.http.performance;

import com.epam.http.response.ResponseStatusType;
import com.epam.http.response.RestResponse;

public class ThreadResult {
    public long minResponseTime = 0L;
    public long maxResponseTime = 0L;
    public long averageResponseTime = 0L;
    public long numberOfRequests = 0L;
    public long numberOfClientFails = 0L;
    public long numberOfServerFails = 0L;

    public void addResult(RestResponse response) {
        long responseTime = response.responseTime();
        this.minResponseTime = this.minResponseTime == 0L ? responseTime : Math.min(this.minResponseTime, responseTime);
        this.maxResponseTime = Math.max(this.maxResponseTime, responseTime);
        this.averageResponseTime = (this.averageResponseTime * this.numberOfRequests + response.responseTime()) / (this.numberOfRequests + 1L);
        ++this.numberOfRequests;
        if (response.getStatus().type == ResponseStatusType.CLIENT_ERROR) {
            ++this.numberOfClientFails;
        }
        if (response.getStatus().type == ResponseStatusType.SERVER_ERROR) {
            ++this.numberOfServerFails;
        }
    }

    public long getMinResponseTime() {
        return this.minResponseTime;
    }

    public long getMaxResponseTime() {
        return this.maxResponseTime;
    }

    public long getAverageResponseTime() {
        return this.averageResponseTime;
    }

    public long getNumberOfRequests() {
        return this.numberOfRequests;
    }

    public long getNumberOfClientFails() {
        return this.numberOfClientFails;
    }

    public long getNumberOfServerFails() {
        return this.numberOfServerFails;
    }

    public void setMinResponseTime(long minResponseTime) {
        this.minResponseTime = minResponseTime;
    }

    public void setMaxResponseTime(long maxResponseTime) {
        this.maxResponseTime = maxResponseTime;
    }

    public void setAverageResponseTime(long averageResponseTime) {
        this.averageResponseTime = averageResponseTime;
    }

    public void setNumberOfRequests(long numberOfRequests) {
        this.numberOfRequests = numberOfRequests;
    }

    public void setNumberOfClientFails(long numberOfClientFails) {
        this.numberOfClientFails = numberOfClientFails;
    }

    public void setNumberOfServerFails(long numberOfServerFails) {
        this.numberOfServerFails = numberOfServerFails;
    }

    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof ThreadResult)) {
            return false;
        }
        ThreadResult other = (ThreadResult)o;
        if (!other.canEqual(this)) {
            return false;
        }
        if (this.getMinResponseTime() != other.getMinResponseTime()) {
            return false;
        }
        if (this.getMaxResponseTime() != other.getMaxResponseTime()) {
            return false;
        }
        if (this.getAverageResponseTime() != other.getAverageResponseTime()) {
            return false;
        }
        if (this.getNumberOfRequests() != other.getNumberOfRequests()) {
            return false;
        }
        if (this.getNumberOfClientFails() != other.getNumberOfClientFails()) {
            return false;
        }
        return this.getNumberOfServerFails() == other.getNumberOfServerFails();
    }

    protected boolean canEqual(Object other) {
        return other instanceof ThreadResult;
    }

    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        long $minResponseTime = this.getMinResponseTime();
        result = result * 59 + (int)($minResponseTime >>> 32 ^ $minResponseTime);
        long $maxResponseTime = this.getMaxResponseTime();
        result = result * 59 + (int)($maxResponseTime >>> 32 ^ $maxResponseTime);
        long $averageResponseTime = this.getAverageResponseTime();
        result = result * 59 + (int)($averageResponseTime >>> 32 ^ $averageResponseTime);
        long $numberOfRequests = this.getNumberOfRequests();
        result = result * 59 + (int)($numberOfRequests >>> 32 ^ $numberOfRequests);
        long $numberOfClientFails = this.getNumberOfClientFails();
        result = result * 59 + (int)($numberOfClientFails >>> 32 ^ $numberOfClientFails);
        long $numberOfServerFails = this.getNumberOfServerFails();
        result = result * 59 + (int)($numberOfServerFails >>> 32 ^ $numberOfServerFails);
        return result;
    }

    public String toString() {
        return "ThreadResult(minResponseTime=" + this.getMinResponseTime() + ", maxResponseTime=" + this.getMaxResponseTime() + ", averageResponseTime=" + this.getAverageResponseTime() + ", numberOfRequests=" + this.getNumberOfRequests() + ", numberOfClientFails=" + this.getNumberOfClientFails() + ", numberOfServerFails=" + this.getNumberOfServerFails() + ")";
    }
}

