/*
 * Decompiled with CFR 0.152.
 */
package com.epam.http.requests;

import com.epam.http.annotations.Proxy;
import com.epam.http.annotations.TrustStore;
import com.epam.http.requests.updaters.CookieUpdater;
import com.epam.http.requests.updaters.FormParamsUpdater;
import com.epam.http.requests.updaters.HeaderUpdater;
import com.epam.http.requests.updaters.PathParamsUpdater;
import com.epam.http.requests.updaters.QueryParamsUpdater;
import com.jdiai.tools.DataClass;
import com.jdiai.tools.func.JFunc;
import com.jdiai.tools.map.MultiMap;
import com.jdiai.tools.pairs.Pair;
import io.restassured.authentication.AuthenticationScheme;
import io.restassured.builder.MultiPartSpecBuilder;
import io.restassured.filter.Filter;
import io.restassured.http.ContentType;
import io.restassured.http.Cookie;
import io.restassured.http.Cookies;
import io.restassured.http.Header;
import io.restassured.http.Headers;
import io.restassured.specification.MultiPartSpecification;
import io.restassured.specification.ProxySpecification;
import java.util.ArrayList;

public class RequestData
extends DataClass<RequestData> {
    public boolean empty = true;
    public String uri = null;
    public String path = null;
    public Object body = null;
    public String contentType = null;
    public Headers headers = new Headers(new Header[0]);
    public Cookies cookies = new Cookies(new Cookie[0]);
    public MultiMap<String, String> pathParams = new MultiMap();
    public MultiMap<String, String> queryParams = new MultiMap();
    public MultiMap<String, String> formParams = new MultiMap();
    public ArrayList<MultiPartSpecification> multiPartSpec = new ArrayList();
    public ArrayList<Filter> filters = new ArrayList();
    public ProxySpecification proxySpec = null;
    public AuthenticationScheme authScheme = null;
    public Pair<String, String> trustStore = null;

    public CookieUpdater cookieUpdater() {
        return new CookieUpdater((JFunc<RequestData>)((JFunc)() -> this));
    }

    public HeaderUpdater headerUpdater() {
        return new HeaderUpdater((JFunc<RequestData>)((JFunc)() -> this));
    }

    public QueryParamsUpdater queryParamsUpdater() {
        return new QueryParamsUpdater((JFunc<RequestData>)((JFunc)() -> this));
    }

    public PathParamsUpdater pathParamsUpdater() {
        return new PathParamsUpdater((JFunc<RequestData>)((JFunc)() -> this));
    }

    public FormParamsUpdater formParamsUpdater() {
        return new FormParamsUpdater((JFunc<RequestData>)((JFunc)() -> this));
    }

    public RequestData setBody(Object body) {
        this.empty = false;
        this.body = body;
        return this;
    }

    public RequestData setContentType(String contentType) {
        this.empty = false;
        this.contentType = contentType;
        return this;
    }

    public RequestData setContentType(ContentType contentType) {
        this.empty = false;
        this.contentType = contentType.toString();
        return this;
    }

    public RequestData setMultiPart(MultiPartSpecBuilder multiPartSpecBuilder) {
        this.empty = false;
        this.multiPartSpec.add(multiPartSpecBuilder.build());
        return this;
    }

    public RequestData setMultiPart(Object multiPartContent) {
        this.empty = false;
        this.multiPartSpec.add(new MultiPartSpecBuilder(multiPartContent).build());
        return this;
    }

    public RequestData setAuthScheme(AuthenticationScheme authScheme) {
        this.empty = false;
        this.authScheme = authScheme;
        return this;
    }

    public RequestData setProxySpec(String scheme, String host, int port) {
        this.empty = false;
        this.proxySpec = ProxySpecification.host((String)host).and().withPort(port).and().withScheme(scheme);
        return this;
    }

    public RequestData setProxySpec(Proxy proxyParams) {
        this.setProxySpec(proxyParams.scheme(), proxyParams.host(), proxyParams.port());
        return this;
    }

    public RequestData setTrustStore(String pathToJks, String password) {
        this.empty = false;
        this.trustStore = new Pair((Object)pathToJks, (Object)password);
        return this;
    }

    public RequestData setTrustStore(TrustStore trustStore) {
        this.setTrustStore(trustStore.pathToJks(), trustStore.password());
        return this;
    }

    public void clear() {
        this.headers = new Headers(new Header[0]);
        this.pathParams.clear();
        this.queryParams.clear();
        this.formParams.clear();
        this.cookies = new Cookies(new Cookie[0]);
        this.body = null;
        this.path = null;
        this.uri = null;
        this.contentType = null;
        this.empty = true;
        this.multiPartSpec.clear();
        this.proxySpec = null;
        this.authScheme = null;
        this.trustStore = null;
    }
}

