/*
 * Decompiled with CFR 0.152.
 */
package com.epam.http.requests;

import com.epam.http.ExceptionHandler;
import com.epam.http.JdiHttpSettings;
import com.epam.http.annotations.MultiPart;
import com.epam.http.logger.AllureLogger;
import com.epam.http.requests.RequestData;
import com.epam.http.requests.RestMethodTypes;
import com.epam.http.requests.RestRequest;
import com.epam.http.requests.RetryData;
import com.epam.http.requests.errorhandler.DefaultErrorHandler;
import com.epam.http.requests.errorhandler.ErrorHandler;
import com.epam.http.requests.updaters.CookieUpdater;
import com.epam.http.requests.updaters.FormParamsUpdater;
import com.epam.http.requests.updaters.HeaderUpdater;
import com.epam.http.requests.updaters.QueryParamsUpdater;
import com.epam.http.requests.util.WaitUtils;
import com.epam.http.response.ResponseStatusType;
import com.epam.http.response.RestResponse;
import com.jdiai.tools.func.JAction1;
import com.jdiai.tools.func.JFunc;
import com.jdiai.tools.func.JFunc2;
import com.jdiai.tools.func.JFunc3;
import com.jdiai.tools.map.MultiMap;
import com.jdiai.tools.pairs.Pair;
import io.restassured.RestAssured;
import io.restassured.authentication.AuthenticationScheme;
import io.restassured.builder.MultiPartSpecBuilder;
import io.restassured.builder.RequestSpecBuilder;
import io.restassured.config.RestAssuredConfig;
import io.restassured.http.Cookies;
import io.restassured.http.Headers;
import io.restassured.internal.RequestSpecificationImpl;
import io.restassured.mapper.ObjectMapper;
import io.restassured.specification.RequestSpecification;
import java.io.File;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import org.apache.commons.lang3.StringUtils;
import org.apache.commons.lang3.time.StopWatch;

public class RestMethod {
    private RequestSpecification callSpec;
    protected String responseType;
    protected Class<?> dataType;
    private RequestSpecification spec = RestAssured.given();
    public String url = null;
    public String path = null;
    public String uri = null;
    public ObjectMapper objectMapper = null;
    public HeaderUpdater header = new HeaderUpdater((JFunc<RequestData>)((JFunc)this::getData));
    public CookieUpdater cookies = new CookieUpdater((JFunc<RequestData>)((JFunc)this::getData));
    public QueryParamsUpdater queryParams = new QueryParamsUpdater((JFunc<RequestData>)((JFunc)this::getData));
    public FormParamsUpdater formParams = new FormParamsUpdater((JFunc<RequestData>)((JFunc)this::getData));
    public RetryData reTryData;
    public RequestData data;
    public RequestData userData = new RequestData();
    public RestMethodTypes type;
    public ErrorHandler errorHandler = new DefaultErrorHandler();
    public static JFunc2<RestMethod, List<RequestData>, String> LOG_REQUEST = RestMethod::logRequest;
    public static JFunc3<RestMethod, List<RequestData>, Integer, String> LOG_RETRY_REQUEST = RestMethod::logReTryRequest;
    private static final JFunc2<RestMethod, List<RequestData>, String> LOG_REQUEST_DEFAULT = LOG_REQUEST;
    private static final JFunc3<RestMethod, List<RequestData>, Integer, String> LOG_RETRY_REQUEST_DEFAULT = LOG_RETRY_REQUEST;
    private static final JFunc2<String, MultiMap<String, String>, String> insertPathParams = (s, mm) -> {
        for (Pair pathParam : mm) {
            s = s.replace("{" + (String)pathParam.key + "}", (CharSequence)pathParam.value);
        }
        return s;
    };

    public RestMethod() {
    }

    public RestMethod(JAction1<RequestSpecification> specFunc, RestMethodTypes type) {
        specFunc.execute((Object)this.spec);
        this.type = type;
    }

    public RestMethod(RestMethodTypes type, RequestData data) {
        this.data = data;
        this.type = type;
    }

    public RestMethod(RestMethodTypes type, String path) {
        this(type, JdiHttpSettings.getDomain(), path, new RequestData());
    }

    public RestMethod(RestMethodTypes type, String url, String path) {
        this(type, url, path, new RequestData());
    }

    public RestMethod(RestMethodTypes type, String url, String path, RequestData data) {
        this.type = type;
        this.url = url;
        this.path = path;
        this.data = data;
    }

    public RestMethod(RestMethodTypes type, String path, RequestSpecification requestSpecification) {
        this(type, path);
        if (requestSpecification == null) {
            return;
        }
        this.spec = this.spec.spec(requestSpecification);
    }

    public RestMethod(RestMethodTypes type, String path, String url, RequestSpecification requestSpecification) {
        this(type, path, url);
        if (requestSpecification == null) {
            return;
        }
        this.spec = this.spec.spec(requestSpecification);
    }

    public void setup(RestMethodTypes type, String path, String url, RequestSpecification requestSpecification) {
        this.type = type;
        this.path = path;
        this.url = url;
        this.data = new RequestData();
        if (requestSpecification == null) {
            return;
        }
        this.spec = this.spec.spec(requestSpecification);
    }

    public RestMethod restMethod() {
        return this;
    }

    public RequestData getData() {
        return this.data;
    }

    public RequestSpecification getInitSpec() {
        return RestAssured.given().spec(this.spec).spec(this.getDataSpec(this.data));
    }

    public RequestSpecification getDataSpec() {
        return this.getDataSpec(this.data);
    }

    public RestMethod setObjectMapper(ObjectMapper objectMapper) {
        if (objectMapper == null) {
            return this;
        }
        this.objectMapper = objectMapper;
        return this;
    }

    public RestMethod setErrorHandler(ErrorHandler errorHandler) {
        if (errorHandler == null) {
            return this;
        }
        this.errorHandler = errorHandler;
        return this;
    }

    void addMultiPartParams(MultiPart multiPartParams) {
        String path = multiPartParams.filePath();
        MultiPartSpecBuilder mpSpecBuilder = new MultiPartSpecBuilder(path.isEmpty() ? "" : new File(path.contains(":") ? path : System.getProperty("user.dir").concat(path.startsWith("/") ? "" : "/").concat(path)));
        if (!multiPartParams.controlName().isEmpty()) {
            mpSpecBuilder.controlName(multiPartParams.controlName());
        }
        if (!multiPartParams.fileName().isEmpty()) {
            mpSpecBuilder.fileName(multiPartParams.fileName());
        }
        if (!multiPartParams.mimeType().isEmpty()) {
            mpSpecBuilder.mimeType(multiPartParams.mimeType());
        }
        this.data.multiPartSpec.add(mpSpecBuilder.build());
    }

    public static void resetLogRequest() {
        LOG_REQUEST = LOG_REQUEST_DEFAULT;
        LOG_RETRY_REQUEST = LOG_RETRY_REQUEST_DEFAULT;
    }

    public String logRequest(List<RequestData> rds) {
        ArrayList<String> maps = new ArrayList<String>();
        for (RequestData rd : rds) {
            maps.addAll(rd.fields().filter((k, v) -> !k.equals("multiPartSpecifications") && !k.equals("headers") && !k.equals("cookies") && !k.equals("empty") && v != null && !v.toString().equals("[]") && !v.toString().isEmpty()).map((k, v) -> "\n" + k + ": " + (v instanceof MultiMap ? ((MultiMap)v).map((km, vm) -> km + "=" + vm) : v)));
            if (rd.headers.exist()) {
                maps.add("\nheaders: " + rd.headers.asList().toString());
            }
            if (rd.cookies.exist()) {
                maps.add("\ncookies: " + rd.cookies.asList().toString());
            }
            rd.multiPartSpec.forEach(mps -> maps.add("\nmultiPartSpecification: " + mps.toString()));
        }
        JdiHttpSettings.logger.info(String.format("Do %s request: %s %s", new Object[]{this.type, this.uri != null ? this.uri : "", maps}), new Object[0]);
        return AllureLogger.startStep(String.format("%s %s%s", new Object[]{this.type, this.url != null ? this.url : "", this.path != null ? this.path : ""}), String.format("%s %s%s  %s", new Object[]{this.type, this.url != null ? this.url : "", this.path != null ? this.path : "", maps}));
    }

    private String logReTryRequest(List<RequestData> requestData, Integer i) {
        JdiHttpSettings.logger.info("================================> RETRY REQUEST ATTEMPT " + (i + 1) + "/" + this.reTryData.getNumberOfRetryAttempts() + ":", new Object[0]);
        return this.logRequest(requestData);
    }

    public synchronized RestResponse call() {
        RequestSpecification runSpec;
        if (this.type == null) {
            throw ExceptionHandler.exception("HttpMethodType not specified", new Object[0]);
        }
        this.uri = this.url != null ? this.url + this.path : this.data.uri;
        this.getQueryParamsFromPath();
        this.insertPathParams();
        RequestSpecification requestSpecification = runSpec = this.callSpec != null ? this.callSpec : this.getInitSpec();
        if (!this.userData.empty) {
            this.userData.authScheme = this.userData.authScheme != null ? this.userData.authScheme : this.data.authScheme;
            runSpec.spec(this.getDataSpec(this.userData));
        }
        String startUuid = (String)LOG_REQUEST.execute((Object)this, Arrays.asList(this.data, this.userData));
        this.userData.clear();
        RestResponse response = RestRequest.doRequest(this.type, runSpec, startUuid);
        this.handleResponse(response);
        response = this.handleRetrying(runSpec, response);
        this.callSpec = null;
        return response;
    }

    public synchronized RestResponse call(JAction1<RequestData> action) {
        RequestData rd = new RequestData();
        action.execute((Object)rd);
        return this.call(rd);
    }

    public synchronized RestResponse call(RequestData requestData) {
        return this.data(requestData).call();
    }

    public synchronized RestResponse call(RequestSpecification requestSpecification) {
        this.callSpec = this.getInitSpec().spec(requestSpecification).baseUri(this.url).basePath(this.path);
        return this.call();
    }

    public synchronized RestResponse callBasedOnSpec(RequestSpecification requestSpecification) {
        this.callSpec = requestSpecification.spec(this.getInitSpec());
        return this.call();
    }

    public synchronized RestResponse call(RestAssuredConfig restAssuredConfig) {
        this.callSpec = this.getInitSpec().config(restAssuredConfig);
        return this.call();
    }

    public <T> T callAsData(Class<T> cl) {
        return this.objectMapper == null ? this.call().asData(cl) : this.call().asData(cl, this.objectMapper);
    }

    public <T> T callAsData() {
        return (T)this.call().asData(this.dataType, this.responseType);
    }

    public RestResponse post(Object body) {
        return this.body(body).call();
    }

    public synchronized <T> T post(Object body, Class<T> cl) {
        return this.body(body).callAsData(cl);
    }

    public synchronized <T> T postAsData(Object object) {
        return (T)this.body(object).call().asData(this.dataType, this.responseType);
    }

    private void getQueryParams(String queryString) {
        if (!queryString.isEmpty()) {
            String[] queryParams;
            for (String queryParam : queryParams = queryString.split("&")) {
                String key = StringUtils.substringBefore((String)queryParam, (String)"=");
                if (this.userData.queryParams.has((Object)key)) continue;
                this.userData.empty = false;
                this.userData.queryParams.add((Object)StringUtils.substringBefore((String)queryParam, (String)"="), (Object)StringUtils.substringAfter((String)queryParam, (String)"="));
            }
        }
    }

    private void getQueryParamsFromPath() {
        if (this.path != null && this.path.contains("?")) {
            String pathString = StringUtils.substringBefore((String)this.path, (String)"?");
            String queryString = StringUtils.substringAfter((String)this.path, (String)"?");
            this.userData.empty = false;
            this.userData.path = pathString;
            this.uri = this.url + pathString;
            this.getQueryParams(this.insertQueryParams(queryString));
        }
    }

    private void insertPathParams() {
        if (this.uri.contains("{")) {
            this.userData.empty = false;
            this.userData.path = this.path;
        }
        this.uri = (String)insertPathParams.execute((Object)this.uri, this.userData.pathParams);
        this.uri = (String)insertPathParams.execute((Object)this.uri, this.data.pathParams);
    }

    private String insertQueryParams(String uri) {
        String mod = (String)insertPathParams.execute((Object)uri, this.userData.queryParams);
        mod = (String)insertPathParams.execute((Object)mod, this.data.queryParams);
        return mod;
    }

    public RestMethod queryParams(String queryParams) {
        this.getQueryParams(queryParams);
        return this;
    }

    public RestMethod pathParams(Object ... pathParams) {
        if (pathParams.length > 0) {
            String[] namedParams = StringUtils.substringsBetween((String)this.path, (String)"{", (String)"}");
            RestMethod.catchPathParametersIllegalArguments(namedParams, pathParams);
            String pathString = StringUtils.substringBefore((String)this.path, (String)"?");
            String queryString = StringUtils.substringAfter((String)this.path, (String)"?");
            this.userData.empty = false;
            this.userData.path = pathString;
            int index = 0;
            String[] namedPathParams = StringUtils.substringsBetween((String)pathString, (String)"{", (String)"}");
            if (namedPathParams != null) {
                for (String key : StringUtils.substringsBetween((String)pathString, (String)"{", (String)"}")) {
                    this.userData.pathParamsUpdater().add(key, pathParams[index].toString());
                    ++index;
                }
            }
            if (!queryString.isEmpty()) {
                return this.queryParams(RestMethod.substPathParams(queryString, Arrays.copyOfRange(pathParams, index, pathParams.length)));
            }
        }
        return this;
    }

    private static String substPathParams(String path, Object[] pathParams) {
        String[] namedParams = StringUtils.substringsBetween((String)path, (String)"{", (String)"}");
        String substPath = path;
        for (int i = 0; i < namedParams.length; ++i) {
            substPath = substPath.replace("{" + namedParams[i] + "}", pathParams[i].toString());
        }
        return substPath;
    }

    private static void catchPathParametersIllegalArguments(String[] namedPathParams, Object[] pathParams) {
        if (pathParams.length > namedPathParams.length) {
            Object[] redundant_values = Arrays.copyOfRange(pathParams, namedPathParams.length, pathParams.length);
            throw ExceptionHandler.exception("Invalid number of path parameters. Expected %s , was %s.\nRedundant param values : %s", namedPathParams.length, pathParams.length, Arrays.asList(redundant_values));
        }
        if (pathParams.length < namedPathParams.length) {
            String[] missing_params = Arrays.copyOfRange(namedPathParams, pathParams.length, namedPathParams.length);
            throw ExceptionHandler.exception("Invalid number of path parameters. Expected %s, was %s.\nMissing params : %s", namedPathParams.length, pathParams.length, Arrays.asList(missing_params));
        }
    }

    public RestMethod body(Object body) {
        this.userData.setBody(body);
        return this;
    }

    public RestMethod data(JAction1<RequestData> action) {
        RequestData rd = new RequestData();
        action.execute((Object)rd);
        return this.data(rd);
    }

    public RestMethod data(RequestData requestData) {
        this.userData.empty = false;
        if (!requestData.pathParams.isEmpty()) {
            this.userData.pathParams = requestData.pathParams;
        }
        if (!requestData.queryParams.isEmpty()) {
            this.userData.queryParamsUpdater().addAll(requestData.queryParams);
        }
        if (!requestData.formParams.isEmpty()) {
            this.userData.formParamsUpdater().addAll(requestData.formParams);
        }
        if (requestData.body != null) {
            this.userData.body = requestData.body;
        }
        if (!requestData.headers.asList().isEmpty()) {
            ArrayList headerList = new ArrayList(this.userData.headers.asList());
            headerList.addAll(requestData.headers.asList());
            this.userData.headers = new Headers(headerList);
        }
        if (!requestData.cookies.asList().isEmpty()) {
            ArrayList cookieList = new ArrayList(this.userData.cookies.asList());
            cookieList.addAll(requestData.cookies.asList());
            this.userData.cookies = new Cookies(cookieList);
        }
        if (requestData.contentType != null) {
            this.userData.contentType = requestData.contentType;
        }
        if (requestData.multiPartSpec.size() > 0) {
            this.userData.multiPartSpec = requestData.multiPartSpec;
        }
        if (requestData.proxySpec != null) {
            this.userData.proxySpec = requestData.proxySpec;
        }
        if (requestData.trustStore != null) {
            this.userData.trustStore = requestData.trustStore;
        }
        if (requestData.authScheme != null) {
            this.userData.authScheme = requestData.authScheme;
        }
        return this;
    }

    public RequestSpecification getDataSpec(RequestData data) {
        RequestSpecification spec = new RequestSpecBuilder().build();
        if (this.url != null) {
            spec.baseUri(this.url);
        }
        if (this.path != null) {
            spec.basePath(this.path);
        }
        if (data == null) {
            return spec;
        }
        if (data.uri != null) {
            spec.baseUri(data.uri);
        }
        if (data.path != null) {
            spec.basePath(data.path);
        }
        if (data.pathParams.any()) {
            spec.pathParams(data.pathParams.toMap());
        }
        if (data.contentType != null) {
            spec.contentType(data.contentType);
        }
        if (data.queryParams.any()) {
            spec.queryParams(data.queryParams.toMap());
        }
        if (data.formParams.any()) {
            spec.formParams(data.formParams.toMap());
        }
        if (!data.headers.asList().isEmpty()) {
            spec.headers(data.headers);
        }
        if (!data.cookies.asList().isEmpty()) {
            spec.cookies(data.cookies);
        }
        if (data.multiPartSpec.size() > 0) {
            data.multiPartSpec.forEach(arg_0 -> ((RequestSpecification)spec).multiPart(arg_0));
        }
        if (data.body != null && this.objectMapper != null) {
            spec.body(data.body, this.objectMapper);
        } else if (data.body != null) {
            spec.body(data.body);
        }
        if (data.proxySpec != null) {
            spec.proxy(data.proxySpec);
        }
        if (data.trustStore != null) {
            spec.trustStore((String)data.trustStore.key, (String)data.trustStore.value);
        }
        if (data.authScheme != null) {
            ((RequestSpecificationImpl)spec).setAuthenticationScheme(data.authScheme);
        }
        return spec;
    }

    private RestResponse handleRetrying(RequestSpecification runSpec, RestResponse firstResponse) {
        if (this.reTryData == null || this.reTryData.getNumberOfRetryAttempts() <= 0) {
            return firstResponse;
        }
        List<Integer> errorCodes = this.reTryData.getErrorCodes();
        boolean failure = errorCodes.contains(firstResponse.getStatus().code);
        if (failure) {
            for (int attempt = 0; attempt < this.reTryData.getNumberOfRetryAttempts(); ++attempt) {
                WaitUtils.makeDelayFor(this.reTryData.getUnit(), this.reTryData.getDelay());
                String startUuidRetry = (String)LOG_RETRY_REQUEST.execute((Object)this, Arrays.asList(this.data, this.userData), (Object)attempt);
                RestResponse retryingResponse = RestRequest.doRequest(this.type, runSpec, startUuidRetry);
                if (errorCodes.contains(retryingResponse.getStatus().code)) continue;
                return retryingResponse;
            }
        }
        return firstResponse;
    }

    private void handleResponse(RestResponse restResponse) {
        boolean hasError = this.errorHandler.hasError(restResponse);
        if (hasError) {
            this.errorHandler.handleError(restResponse);
        }
    }

    public void isAlive() {
        this.isAlive(2000);
    }

    public void isAlive(int liveTimeMSec) {
        ResponseStatusType status;
        StopWatch watch = StopWatch.createStarted();
        while ((status = this.call().getResponseStatus().type) != ResponseStatusType.OK && watch.getTime() < (long)liveTimeMSec) {
        }
        this.call().isOk();
    }

    public RestMethod multipart(Object multiPartContent) {
        this.userData.setMultiPart(new MultiPartSpecBuilder(multiPartContent));
        return this;
    }

    public RestMethod auth(AuthenticationScheme authenticationScheme) {
        this.userData.setAuthScheme(authenticationScheme);
        return this;
    }
}

