/*
 * Decompiled with CFR 0.152.
 */
package com.epam.http.requests;

import com.epam.http.ExceptionHandler;
import com.epam.http.annotations.RetryOnFailure;
import java.util.Arrays;
import java.util.List;
import java.util.concurrent.TimeUnit;
import java.util.stream.Collectors;

public class RetryData {
    private Integer numberOfRetryAttempts;
    private List<Integer> errorCodes;
    private Long delay;
    private TimeUnit unit;

    public RetryData(RetryOnFailure retryData) {
        this.numberOfRetryAttempts = retryData.numberOfRetryAttempts();
        this.errorCodes = this.intArrayToList(retryData);
        this.delay = retryData.delay();
        this.unit = retryData.unit();
    }

    public RetryData merge(RetryOnFailure retryData) {
        this.numberOfRetryAttempts = retryData.numberOfRetryAttempts() == ((Integer)this.getDefaultValueOf("numberOfRetryAttempts")).intValue() ? this.numberOfRetryAttempts.intValue() : retryData.numberOfRetryAttempts();
        this.errorCodes = retryData.errorCodes() == this.getDefaultValueOf("errorCodes") ? this.errorCodes : this.intArrayToList(retryData);
        this.unit = retryData.unit() == this.getDefaultValueOf("unit") ? this.unit : retryData.unit();
        this.delay = retryData.delay() == ((Long)this.getDefaultValueOf("delay")).longValue() ? this.delay.longValue() : retryData.delay();
        return this;
    }

    public Integer getNumberOfRetryAttempts() {
        return this.numberOfRetryAttempts;
    }

    public List<Integer> getErrorCodes() {
        return this.errorCodes;
    }

    public Long getDelay() {
        return this.delay;
    }

    public TimeUnit getUnit() {
        return this.unit;
    }

    private Object getDefaultValueOf(String methodName) {
        try {
            return RetryOnFailure.class.getMethod(methodName, new Class[0]).getDefaultValue();
        }
        catch (NoSuchMethodException e) {
            throw ExceptionHandler.exception("@RetryOnFail doesn't have field " + methodName, new Object[0]);
        }
    }

    private List<Integer> intArrayToList(RetryOnFailure retryData) {
        return Arrays.stream(retryData.errorCodes()).boxed().collect(Collectors.toList());
    }
}

