/*
 * Decompiled with CFR 0.152.
 */
package com.epam.http.requests;

import com.epam.http.ExceptionHandler;
import com.epam.http.JdiHttpSettings;
import com.epam.http.annotations.ContentType;
import com.epam.http.annotations.Cookie;
import com.epam.http.annotations.Cookies;
import com.epam.http.annotations.DELETE;
import com.epam.http.annotations.FormParameter;
import com.epam.http.annotations.FormParameters;
import com.epam.http.annotations.GET;
import com.epam.http.annotations.HEAD;
import com.epam.http.annotations.Header;
import com.epam.http.annotations.Headers;
import com.epam.http.annotations.IgnoreRetry;
import com.epam.http.annotations.MultiPart;
import com.epam.http.annotations.OPTIONS;
import com.epam.http.annotations.PATCH;
import com.epam.http.annotations.POST;
import com.epam.http.annotations.PUT;
import com.epam.http.annotations.Proxy;
import com.epam.http.annotations.QueryParameter;
import com.epam.http.annotations.QueryParameters;
import com.epam.http.annotations.RetryOnFailure;
import com.epam.http.annotations.ServiceDomain;
import com.epam.http.annotations.TrustStore;
import com.epam.http.annotations.URL;
import com.epam.http.requests.MethodData;
import com.epam.http.requests.RestDataMethod;
import com.epam.http.requests.RestMethod;
import com.epam.http.requests.RestMethodTypes;
import com.epam.http.requests.RetryData;
import com.epam.http.requests.ServiceSettings;
import com.epam.http.requests.SoapMethod;
import com.epam.http.requests.errorhandler.ErrorHandler;
import com.jdiai.tools.LinqUtils;
import com.jdiai.tools.ReflectionUtils;
import com.jdiai.tools.func.JAction;
import com.jdiai.tools.map.MapArray;
import com.jdiai.tools.pairs.Pair;
import io.restassured.authentication.AuthenticationScheme;
import io.restassured.mapper.ObjectMapper;
import io.restassured.specification.RequestSpecification;
import java.lang.reflect.Field;
import java.lang.reflect.Modifier;
import java.util.List;
import java.util.regex.Matcher;
import java.util.regex.Pattern;

public class ServiceInit {
    public static MapArray<String, JAction> PRE_INIT = new MapArray((Object)"WebSettings", JdiHttpSettings::init);
    public static boolean initialized = false;

    public static void preInit() {
        if (PRE_INIT == null) {
            return;
        }
        if (!initialized) {
            for (Pair action : PRE_INIT) {
                try {
                    ((JAction)action.value).execute();
                }
                catch (Exception ex) {
                    JdiHttpSettings.logger.error(ex.getMessage(), new Object[0]);
                    throw ExceptionHandler.exception("Preinit '%s' failed. Please correct PageFactory.PRE_INIT function", action.key);
                }
            }
            initialized = true;
        }
    }

    public static <T> T init(Class<T> c) {
        return ServiceInit.init(c, ServiceSettings.builder().build());
    }

    public static <T> T init(Class<T> c, ServiceSettings serviceSettings) {
        ServiceInit.preInit();
        T instance = ServiceInit.getService(c);
        List methods = LinqUtils.where((Object[])c.getDeclaredFields(), f -> ReflectionUtils.isClass(f.getType(), RestMethod.class));
        for (Field method : methods) {
            try {
                method.setAccessible(true);
                Object rm = ServiceInit.getRestMethod(method, c, serviceSettings.getRequestSpecification(), serviceSettings.getObjectMapper(), serviceSettings.getErrorHandler(), serviceSettings.getAuthenticationScheme(), serviceSettings.getDomain());
                if (Modifier.isStatic(method.getModifiers())) {
                    method.set(null, rm);
                    continue;
                }
                method.set(instance, rm);
            }
            catch (Throwable ex) {
                JdiHttpSettings.logger.error(ex.getMessage(), new Object[0]);
                throw ExceptionHandler.exception("Can't init method %s for class %s", method.getName(), c.getName());
            }
        }
        return instance;
    }

    public static <T> T init(Class<T> c, RequestSpecification requestSpecification) {
        return ServiceInit.init(c, ServiceSettings.builder().requestSpecification(requestSpecification).build());
    }

    public static <T> T init(Class<T> c, AuthenticationScheme authenticationScheme) {
        return ServiceInit.init(c, ServiceSettings.builder().authenticationScheme(authenticationScheme).build());
    }

    public static <T> T init(Class<T> c, String domain) {
        return ServiceInit.init(c, ServiceSettings.builder().domain(domain).build());
    }

    private static <T> T getService(Class<T> c) {
        try {
            return c.newInstance();
        }
        catch (IllegalAccessException | InstantiationException ex) {
            throw ExceptionHandler.exception("Can't instantiate class %s, Service class should have empty constructor", c.getSimpleName());
        }
    }

    private static <T> Object getRestMethod(Field field, Class<T> c, RequestSpecification requestSpecification, ObjectMapper objectMapper, ErrorHandler errorHandler, AuthenticationScheme authenticationScheme, String domain) {
        MethodData mtData = ServiceInit.getMethodData(field);
        String url = domain == null ? (field.isAnnotationPresent(URL.class) ? field.getAnnotation(URL.class).value() : ServiceInit.getDomain(c)) : ServiceInit.replaceTemplateVariableInDomain(domain);
        String path = mtData.path;
        RestMethod method = field.getType() == SoapMethod.class ? new SoapMethod(field, c) : (field.getType() == RestDataMethod.class ? new RestDataMethod(field) : new RestMethod());
        method.setup(mtData.type, path, url, requestSpecification);
        method.setObjectMapper(objectMapper);
        method.setErrorHandler(errorHandler);
        method.data.setAuthScheme(authenticationScheme);
        if (field.isAnnotationPresent(ContentType.class)) {
            method.data.setContentType(field.getAnnotation(ContentType.class).value());
        }
        if (field.isAnnotationPresent(Header.class)) {
            method.header.add(field.getAnnotation(Header.class));
        }
        if (field.isAnnotationPresent(Headers.class)) {
            method.header.addAll(field.getAnnotation(Headers.class).value());
        }
        if (field.isAnnotationPresent(Cookie.class)) {
            ServiceInit.setupCookie(method, field.getAnnotation(Cookie.class));
        }
        if (field.isAnnotationPresent(Cookies.class)) {
            for (Cookie cookie : field.getAnnotation(Cookies.class).value()) {
                ServiceInit.setupCookie(method, cookie);
            }
        }
        if (c.isAnnotationPresent(Header.class)) {
            method.header.add(c.getAnnotation(Header.class));
        }
        if (c.isAnnotationPresent(Headers.class)) {
            method.header.addAll(c.getAnnotation(Headers.class).value());
        }
        if (c.isAnnotationPresent(Cookie.class)) {
            ServiceInit.setupCookie(method, c.getAnnotation(Cookie.class));
        }
        if (c.isAnnotationPresent(Cookies.class)) {
            for (Cookie cookie : c.getAnnotation(Cookies.class).value()) {
                ServiceInit.setupCookie(method, cookie);
            }
        }
        if (c.isAnnotationPresent(QueryParameter.class)) {
            method.queryParams.add(c.getAnnotation(QueryParameter.class));
        }
        if (c.isAnnotationPresent(QueryParameters.class)) {
            method.queryParams.addAll(c.getAnnotation(QueryParameters.class).value());
        }
        if (c.isAnnotationPresent(FormParameter.class)) {
            method.formParams.add(c.getAnnotation(FormParameter.class));
        }
        if (c.isAnnotationPresent(FormParameters.class)) {
            method.formParams.addAll(c.getAnnotation(FormParameters.class).value());
        }
        if (c.isAnnotationPresent(TrustStore.class)) {
            method.data.setTrustStore(c.getAnnotation(TrustStore.class));
        }
        if (c.isAnnotationPresent(RetryOnFailure.class)) {
            method.reTryData = new RetryData(c.getAnnotation(RetryOnFailure.class));
        }
        if (field.isAnnotationPresent(QueryParameter.class)) {
            method.queryParams.add(field.getAnnotation(QueryParameter.class));
        }
        if (field.isAnnotationPresent(QueryParameters.class)) {
            method.queryParams.addAll(field.getAnnotation(QueryParameters.class).value());
        }
        if (field.isAnnotationPresent(FormParameter.class)) {
            method.formParams.add(field.getAnnotation(FormParameter.class));
        }
        if (field.isAnnotationPresent(FormParameters.class)) {
            method.formParams.addAll(field.getAnnotation(FormParameters.class).value());
        }
        if (field.isAnnotationPresent(MultiPart.class)) {
            method.addMultiPartParams(field.getAnnotation(MultiPart.class));
        }
        if (field.isAnnotationPresent(Proxy.class)) {
            method.data.setProxySpec(field.getAnnotation(Proxy.class));
        }
        if (field.isAnnotationPresent(TrustStore.class)) {
            method.data.setTrustStore(field.getAnnotation(TrustStore.class));
        }
        if (field.isAnnotationPresent(RetryOnFailure.class)) {
            RetryOnFailure methodRetryData = field.getAnnotation(RetryOnFailure.class);
            RetryData retryData = method.reTryData = method.reTryData != null ? method.reTryData.merge(methodRetryData) : new RetryData(methodRetryData);
        }
        if (field.isAnnotationPresent(IgnoreRetry.class)) {
            method.reTryData = null;
        }
        return method;
    }

    private static <T> Object getRestMethod(Field field, Class<T> c, RequestSpecification requestSpecification, ObjectMapper objectMapper, ErrorHandler errorHandler, AuthenticationScheme authenticationScheme) {
        return ServiceInit.getRestMethod(field, c, requestSpecification, objectMapper, errorHandler, authenticationScheme, null);
    }

    private static void setupCookie(RestMethod method, Cookie cookie) {
        if (cookie.value().equals("[unassigned]")) {
            method.cookies.add(cookie.name());
        } else {
            method.cookies.add(cookie);
        }
        if (!cookie.additionalValues()[0].equals("[unassigned]")) {
            method.cookies.add(cookie.name(), cookie.additionalValues());
        }
    }

    private static MethodData getMethodData(Field method) {
        if (method.isAnnotationPresent(GET.class)) {
            return new MethodData(method.getAnnotation(GET.class).value(), RestMethodTypes.GET);
        }
        if (method.isAnnotationPresent(POST.class)) {
            return new MethodData(method.getAnnotation(POST.class).value(), RestMethodTypes.POST);
        }
        if (method.isAnnotationPresent(PUT.class)) {
            return new MethodData(method.getAnnotation(PUT.class).value(), RestMethodTypes.PUT);
        }
        if (method.isAnnotationPresent(DELETE.class)) {
            return new MethodData(method.getAnnotation(DELETE.class).value(), RestMethodTypes.DELETE);
        }
        if (method.isAnnotationPresent(PATCH.class)) {
            return new MethodData(method.getAnnotation(PATCH.class).value(), RestMethodTypes.PATCH);
        }
        if (method.isAnnotationPresent(HEAD.class)) {
            return new MethodData(method.getAnnotation(HEAD.class).value(), RestMethodTypes.HEAD);
        }
        if (method.isAnnotationPresent(OPTIONS.class)) {
            return new MethodData(method.getAnnotation(OPTIONS.class).value(), RestMethodTypes.OPTIONS);
        }
        return new MethodData(null, RestMethodTypes.GET);
    }

    private static <T> String getDomain(Class<T> c) {
        if (!c.isAnnotationPresent(ServiceDomain.class)) {
            return JdiHttpSettings.getDomain();
        }
        String valueFromAnnotation = c.getAnnotation(ServiceDomain.class).value();
        return ServiceInit.replaceTemplateVariableInDomain(valueFromAnnotation);
    }

    private static <T> String replaceTemplateVariableInDomain(String domain) {
        Matcher m = Pattern.compile("\\$\\{(.*)}").matcher(domain);
        return m.find() ? m.replaceFirst(JdiHttpSettings.getDomain(m.group(1))) : domain;
    }
}

