/*
 * Decompiled with CFR 0.152.
 */
package com.epam.http.requests;

import com.epam.http.ExceptionHandler;
import com.epam.http.annotations.SOAP12;
import com.epam.http.annotations.SOAPAction;
import com.epam.http.annotations.SOAPNamespace;
import com.epam.http.requests.RequestDataFactory;
import com.epam.http.requests.RestMethod;
import com.jdiai.tools.ReflectionUtils;
import jakarta.xml.soap.MessageFactory;
import jakarta.xml.soap.SOAPBody;
import jakarta.xml.soap.SOAPException;
import jakarta.xml.soap.SOAPMessage;
import java.io.ByteArrayInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.StringReader;
import java.io.StringWriter;
import java.io.Writer;
import java.lang.reflect.Field;
import javax.xml.bind.JAXBContext;
import javax.xml.bind.JAXBException;
import javax.xml.bind.Marshaller;
import javax.xml.bind.Unmarshaller;
import javax.xml.stream.XMLInputFactory;
import javax.xml.stream.XMLStreamException;
import javax.xml.stream.XMLStreamReader;
import javax.xml.stream.util.StreamReaderDelegate;

public class SoapMethod<T, S>
extends RestMethod {
    boolean soap12;
    String envelop;
    String soapHeader;
    String action;
    String namespace;
    Class<T> req;
    Class<S> resp;
    Object[][] headers;

    public SoapMethod(Field field, Class<T> c) {
        Object[][] objectArrayArray;
        this.soap12 = field.isAnnotationPresent(SOAP12.class) || c.isAnnotationPresent(SOAP12.class);
        this.soapHeader = "   <soap:Header/>";
        String string = this.action = field.isAnnotationPresent(SOAPAction.class) ? field.getAnnotation(SOAPAction.class).value() : field.getName();
        this.namespace = c.isAnnotationPresent(SOAPNamespace.class) ? " xmlns=\"" + c.getAnnotation(SOAPNamespace.class).value() + "\" \n" : (field.isAnnotationPresent(SOAPNamespace.class) ? " xmlns=\"" + field.getAnnotation(SOAPNamespace.class).value() + "\" \n" : "");
        this.envelop = "<soap:Envelope xmlns:xsi=\"http://www.w3.org/2001/XMLSchema-instance\" \nxmlns:xsd=\"http://www.w3.org/2001/XMLSchema\" \n" + this.namespace + (this.soap12 ? "xmlns:soap=\"http://www.w3.org/2003/05/soap-envelope\">" : "xmlns:soap=\"http://schemas.xmlsoap.org/soap/envelope/\">");
        this.req = (Class)ReflectionUtils.getGenericTypes((Field)field)[0];
        this.resp = (Class)ReflectionUtils.getGenericTypes((Field)field)[1];
        if (this.soap12) {
            Object[][] objectArrayArray2 = new Object[2][];
            objectArrayArray2[0] = new Object[]{"Content-Type", "application/soap+xml;charset=UTF-8"};
            objectArrayArray = objectArrayArray2;
            objectArrayArray2[1] = new Object[]{"Action", this.action};
        } else {
            Object[][] objectArrayArray3 = new Object[2][];
            objectArrayArray3[0] = new Object[]{"Content-Type", "text/xml;charset=UTF-8"};
            objectArrayArray = objectArrayArray3;
            objectArrayArray3[1] = new Object[]{"SOAPAction", this.action};
        }
        this.headers = objectArrayArray;
    }

    public S callSoap(T object) {
        try {
            return this.getResponse(this.restMethod().data(RequestDataFactory.headers().addAll(this.headers).setBody(this.createSoapBody(object))).call().getBody());
        }
        catch (Exception ex) {
            throw ExceptionHandler.exception(ex.toString(), new Object[0]);
        }
    }

    public SoapMethod<T, S> withSoapHeader(Object header) {
        try {
            this.soapHeader = "   <soap:Header>\n   " + this.getXML(header) + "\n   </soap:Header>";
            return this;
        }
        catch (Exception ex) {
            throw ExceptionHandler.exception(ex.getMessage(), new Object[0]);
        }
    }

    private String createSoapBody(T object) throws JAXBException {
        return this.envelop + "\n" + this.soapHeader + "\n   <soap:Body>\n   " + this.getXML(object) + "\n   </soap:Body>\n</soap:Envelope>";
    }

    private String getXML(Object object) throws JAXBException {
        if (object instanceof String) {
            return object.toString();
        }
        JAXBContext context = JAXBContext.newInstance((Class[])new Class[]{object.getClass()});
        Marshaller marshaller = context.createMarshaller();
        StringWriter stringWriter = new StringWriter();
        marshaller.setProperty("jaxb.fragment", (Object)Boolean.TRUE);
        marshaller.marshal(object, (Writer)stringWriter);
        return stringWriter.toString();
    }

    private S getResponse(String body) throws JAXBException, XMLStreamException, SOAPException, IOException {
        ByteArrayInputStream is = new ByteArrayInputStream(body.getBytes());
        SOAPMessage request = MessageFactory.newInstance((String)(this.soap12 ? "SOAP 1.2 Protocol" : "SOAP 1.1 Protocol")).createMessage(null, (InputStream)is);
        SOAPBody soapBody = request.getSOAPBody();
        if (soapBody.hasFault()) {
            throw new SOAPException(soapBody.getFault().getFaultString());
        }
        if (this.resp == String.class) {
            return (S)soapBody.getTextContent().trim();
        }
        XMLStreamReader xsr = XMLInputFactory.newFactory().createXMLStreamReader(new StringReader(body.replaceAll("\\n", "")));
        class XMLReaderWithoutNamespace
        extends StreamReaderDelegate {
            public XMLReaderWithoutNamespace(XMLStreamReader reader) {
                super(reader);
            }

            @Override
            public String getAttributeNamespace(int arg0) {
                return "";
            }

            @Override
            public String getNamespaceURI() {
                return "";
            }
        }
        XMLReaderWithoutNamespace xr = new XMLReaderWithoutNamespace(xsr);
        JAXBContext jc = JAXBContext.newInstance((Class[])new Class[]{this.resp});
        Unmarshaller u = jc.createUnmarshaller();
        while (xr.hasNext()) {
            xr.nextTag();
            if (!xr.getName().getLocalPart().equals(this.resp.getSimpleName())) continue;
            break;
        }
        return (S)u.unmarshal((XMLStreamReader)xr, this.resp).getValue();
    }
}

