/*
 * Decompiled with CFR 0.152.
 */
package com.epam.http.requests.updaters;

import com.epam.http.requests.RequestData;
import com.jdiai.tools.LinqUtils;
import com.jdiai.tools.func.JFunc1;
import com.jdiai.tools.func.JFunc2;
import com.jdiai.tools.map.MapArray;
import java.lang.annotation.Annotation;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Map;

public abstract class SpecUpdater<A extends Annotation, T> {
    JFunc1<Collection<T>, RequestData> store;
    JFunc1<A, T> transform;
    JFunc2<String, String, T> transformNameValue;

    public SpecUpdater(JFunc1<Collection<T>, RequestData> store, JFunc1<A, T> transform, JFunc2<String, String, T> transformNameValue) {
        this.store = store;
        this.transform = transform;
        this.transformNameValue = transformNameValue;
    }

    public RequestData add(A annotation) {
        return this.add((T)this.transform.execute(annotation));
    }

    public RequestData add(T types) {
        return this.addAll((Collection<T>)Collections.singletonList(types));
    }

    public RequestData addAll(A ... annotations) {
        return this.addAll(LinqUtils.map((Object[])annotations, a -> this.transform.execute(a)));
    }

    public RequestData add(String name) {
        return this.add(name, "");
    }

    public RequestData add(String name, String ... values) {
        List list = LinqUtils.map((Object[])values, value -> this.transformNameValue.execute((Object)name, value));
        return this.addAll(list);
    }

    public RequestData addAll(Collection<T> list) {
        return (RequestData)((Object)this.store.execute(list));
    }

    public RequestData addAll(Object[][] array2D) {
        List list = LinqUtils.map((Object[])array2D, pair -> this.transformNameValue.execute((Object)pair[0].toString(), (Object)pair[1].toString()));
        return this.addAll(list);
    }

    public RequestData addAll(Map map) {
        List list = new MapArray(map).map((key, value) -> this.transformNameValue.execute((Object)key.toString(), (Object)value.toString()));
        return this.addAll(list);
    }

    public RequestData addAll(T ... array) {
        return this.addAll((Collection<T>)Arrays.asList(array));
    }
}

