/*
 * Decompiled with CFR 0.152.
 */
package com.epam.http.response;

import com.epam.http.ExceptionHandler;
import com.epam.http.JdiHttpSettings;
import com.epam.http.logger.AllureLogger;
import com.epam.http.response.ResponseStatus;
import com.epam.http.response.ResponseStatusType;
import com.jdiai.tools.StringUtils;
import com.jdiai.tools.func.JAction1;
import com.jdiai.tools.func.JAction2;
import com.jdiai.tools.map.MapArray;
import com.jdiai.tools.pairs.Pair;
import io.restassured.http.Header;
import io.restassured.http.Headers;
import io.restassured.mapper.ObjectMapper;
import io.restassured.response.Response;
import io.restassured.response.ValidatableResponse;
import java.util.Arrays;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.function.Function;
import org.hamcrest.Matcher;

public class RestResponse {
    private final Response raResponse;
    private final long responseTimeMSec;
    private String body = null;
    private ResponseStatus status = null;
    private String contentType = "";
    public static JAction2<RestResponse, String> LOG_RESPONSE = RestResponse::logResponse;
    private static final JAction2<RestResponse, String> LOG_RESPONSE_DEFAULT = LOG_RESPONSE;

    public ResponseStatus getResponseStatus() {
        return this.status;
    }

    public String getContentType() {
        return this.contentType;
    }

    public RestResponse() {
        this.raResponse = null;
        this.responseTimeMSec = 0L;
    }

    public RestResponse(Response raResponse) {
        this.raResponse = raResponse;
        this.responseTimeMSec = raResponse.getTime();
        this.body = raResponse.body().asString();
        this.status = new ResponseStatus(raResponse);
        this.contentType = raResponse.contentType();
    }

    public static void resetLogResponse() {
        LOG_RESPONSE = LOG_RESPONSE_DEFAULT;
    }

    public void logResponse(String uuid) {
        JdiHttpSettings.logger.info(this.toString(), new Object[0]);
        AllureLogger.passStep(this.toString(), uuid);
    }

    public RestResponse set(JAction1<RestResponse> valueFunc) {
        RestResponse thisObj = this;
        valueFunc.execute((Object)thisObj);
        return thisObj;
    }

    public boolean verify(Function<RestResponse, Boolean> validator) {
        return validator.apply(this);
    }

    public ValidatableResponse validate(Function<RestResponse, Boolean> validator) {
        if (!this.verify(validator)) {
            throw ExceptionHandler.exception("Bad raResponse: " + this.toString(), new Object[0]);
        }
        return this.assertThat();
    }

    public ValidatableResponse isOk() {
        return this.isStatus(ResponseStatusType.OK);
    }

    public ValidatableResponse hasErrors() {
        return this.isStatus(ResponseStatusType.CLIENT_ERROR);
    }

    public ValidatableResponse isStatus(ResponseStatusType type) {
        return this.validate(r -> this.status.type == type);
    }

    public String getBody() {
        return this.body;
    }

    public ResponseStatus getStatus() {
        return this.status;
    }

    public ValidatableResponse isEmpty() {
        return this.validate(r -> this.body.isEmpty());
    }

    public ValidatableResponse assertBody(MapArray<String, Matcher<?>> params) {
        ValidatableResponse vr = this.assertThat();
        try {
            for (Pair pair : params) {
                vr.body((String)pair.key, (Matcher)pair.value, new Object[0]);
            }
            return vr;
        }
        catch (Exception ex) {
            throw new RuntimeException("Only <String, Matcher> pairs available for assertBody");
        }
    }

    public ValidatableResponse assertBody(Object[][] params) {
        return this.assertBody(new MapArray(params));
    }

    public String getFromHtml(String path) {
        return this.raResponse.body().htmlPath().getString(path);
    }

    public List<Header> headersAsList() {
        return this.raResponse.getHeaders().asList();
    }

    public Headers headers() {
        return this.raResponse.getHeaders();
    }

    public String header(String name) {
        return this.raResponse.getHeader(name);
    }

    public String cookie(String name) {
        return this.raResponse.getCookie(name);
    }

    public Map<String, String> cookies() {
        return this.raResponse.getCookies();
    }

    public Response getRaResponse() {
        return this.raResponse;
    }

    public long responseTime() {
        return this.responseTimeMSec;
    }

    public ValidatableResponse assertThat() {
        return (ValidatableResponse)this.raResponse.then();
    }

    public <T> T asData(Class<T> cl) {
        this.isOk();
        return (T)this.getRaResponse().as(cl);
    }

    public <T> T asData(Class<T> cl, ObjectMapper objectMapper) {
        this.isOk();
        return (T)this.getRaResponse().as(cl, objectMapper);
    }

    public <T> T asData(Class<T> cl, String responseType) {
        this.isOk();
        switch (responseType) {
            case "List": {
                return (T)Arrays.asList((Object[])this.getRaResponse().as(cl));
            }
            case "Map": {
                return (T)this.getRaResponse().jsonPath().getMap("$", String.class, HashMap.class);
            }
        }
        return (T)this.getRaResponse().as(cl);
    }

    public RestResponse assertStatus(ResponseStatus rs) {
        String errors = "";
        if (this.status.code != rs.code) {
            errors = errors + String.format("Wrong status code %s. Expected: %s", this.status.code, rs.code) + StringUtils.LINE_BREAK;
        }
        if (!this.status.type.equals((Object)rs.type)) {
            errors = errors + String.format("Wrong status type %s. Expected: %s", new Object[]{this.status.type, rs.type}) + StringUtils.LINE_BREAK;
        }
        if (!this.status.text.equals(rs.text)) {
            errors = errors + String.format("Wrong status text %s. Expected: %s", this.status.text, rs.text);
        }
        if (!errors.isEmpty()) {
            throw ExceptionHandler.exception(errors, new Object[0]);
        }
        return this;
    }

    public String toString() {
        return String.format("Response status: %s %s (%s)", new Object[]{this.status.code, this.status.text, this.status.type}) + StringUtils.LINE_BREAK + "Response body: " + this.body;
    }
}

