package com.epam.jdi.light.driver.get;

import static com.epam.jdi.light.common.Exceptions.runtimeException;

/**
 * Created by Roman Iovlev on 26.09.2019
 * Email: roman.iovlev.jdi@gmail.com; Skype: roman.iovlev
 */
public enum DriverTypes {
    CHROME("chrome"),
    FIREFOX("firefox"),
    IE("ie"),
    EDGE("edge"),
    OPERA("opera"),
    SAFARI("safari");

    public final String name;
    public static DriverTypes getByName(String name) {
        switch (name.toLowerCase()) {
            case "chrome": return CHROME;
            case "firefox": return FIREFOX;
            case "ie":
            case "internetexplorer":
                return IE;
            case "edge": return EDGE;
            case "phantom":
            case "opera": return OPERA;
            case "safari": return SAFARI;
            default:
                throw runtimeException("Unknown driver: " + name);
        }
    }

    DriverTypes(String name) {
        this.name = name;
    }

}
