/*
 * Decompiled with CFR 0.152.
 */
package com.epam.jdi.light.actions;

import com.epam.jdi.light.actions.ActionHelper;
import com.epam.jdi.light.actions.ActionOverride;
import com.epam.jdi.light.common.JDIAction;
import com.epam.jdi.light.elements.base.JDIBase;
import com.epam.jdi.light.elements.common.Alerts;
import com.epam.jdi.light.elements.composite.WebPage;
import com.epam.jdi.light.elements.interfaces.base.IBaseElement;
import com.epam.jdi.light.elements.interfaces.base.ICoreElement;
import com.epam.jdi.light.logger.LogLevels;
import com.epam.jdi.light.settings.JDISettings;
import com.jdiai.tools.CacheValue;
import com.jdiai.tools.LinqUtils;
import com.jdiai.tools.PrintUtils;
import com.jdiai.tools.ReflectionUtils;
import com.jdiai.tools.Safe;
import com.jdiai.tools.func.JFunc1;
import java.lang.reflect.Method;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import org.aspectj.lang.JoinPoint;
import org.aspectj.lang.ProceedingJoinPoint;
import org.aspectj.lang.reflect.MethodSignature;

public class ActionObject {
    private JoinPoint jp;
    public ProceedingJoinPoint pjp;
    private String processor;
    private int elementTimeout = -1;
    public String stepUId = "";
    private CacheValue<Object> obj = new CacheValue(() -> this.instance() != null ? this.instance() : this.jp().getSignature().getDeclaringType().getSimpleName());
    private CacheValue<Integer> timeout = new CacheValue(this::getTimeout);
    private CacheValue<JFunc1<Object, Object>> overrideAction = new CacheValue(this::getOverride);
    private static Safe<List<String>> isOverride = new Safe(ArrayList::new);

    private ActionObject(String name) {
        this.processor = name;
    }

    public ActionObject(JoinPoint joinPoint, String name) {
        this(name);
        this.jp = joinPoint;
    }

    public ActionObject(ProceedingJoinPoint joinPoint, String name) {
        this(name);
        this.pjp = joinPoint;
    }

    private int elementTimeout() {
        if (this.elementTimeout > -1) {
            return this.elementTimeout;
        }
        try {
            this.elementTimeout = this.isBase() ? this.element().getTimeout() : JDISettings.TIMEOUTS.element.get();
        }
        catch (Throwable throwable) {
            this.elementTimeout = 10;
        }
        return this.elementTimeout;
    }

    public JoinPoint jp() {
        return this.pjp != null ? this.pjp : this.jp;
    }

    public Object execute() throws Throwable {
        return this.pjp().proceed();
    }

    public ProceedingJoinPoint pjp() {
        return this.pjp;
    }

    public boolean topLevel() {
        return ActionHelper.aroundCount() == 1;
    }

    public LogLevels logLevel() {
        return ActionHelper.logLevel(this.jp());
    }

    public Object object() {
        return this.obj.get();
    }

    public Object instance() {
        return ActionHelper.getJpInstance(this.jp());
    }

    public JDIBase element() {
        try {
            IBaseElement element;
            if (this.instance() != null && ReflectionUtils.isInterface(ActionHelper.getJpClass(this.jp()), IBaseElement.class) && (element = (IBaseElement)this.instance()).base() != null) {
                return element.base();
            }
            return null;
        }
        catch (Throwable throwable) {
            return null;
        }
    }

    public boolean isBase() {
        return this.element() != null;
    }

    public boolean isPage() {
        return this.instance() != null && ReflectionUtils.isClass(this.instance().getClass(), WebPage.class);
    }

    public boolean isCore() {
        return this.core() != null;
    }

    public WebPage page() {
        return (WebPage)this.instance();
    }

    public ICoreElement core() {
        try {
            ICoreElement element;
            if (this.instance() != null && ReflectionUtils.isInterface(ActionHelper.getJpClass(this.jp()), ICoreElement.class) && (element = (ICoreElement)this.instance()).core() != null) {
                return element;
            }
            return null;
        }
        catch (Throwable throwable) {
            return null;
        }
    }

    public int timeout() {
        return (Integer)this.timeout.get();
    }

    public int realTimeout() {
        int timeout = this.timeout();
        if (timeout != 0) {
            return timeout;
        }
        JDIAction ja = this.jp() != null ? this.jdiAnnotation() : null;
        return ja != null && ja.timeout() == 0 ? this.timeoutFromArgs() : timeout;
    }

    private int timeoutFromArgs() {
        int index = 0;
        boolean hasTimeoutParam = false;
        String[] stringArray = ActionHelper.getJpMethod(this.jp()).getParameterNames();
        int n = stringArray.length;
        int n2 = 0;
        while (n2 < n) {
            String name = stringArray[n2];
            if (name.contains("timeout")) {
                hasTimeoutParam = true;
                break;
            }
            ++index;
            ++n2;
        }
        if (hasTimeoutParam) {
            try {
                return (Integer)ActionHelper.getArgs(this.jp())[index];
            }
            catch (Throwable throwable) {}
        }
        return 0;
    }

    private int getTimeout() {
        JDIAction ja = this.jp() != null ? this.jdiAnnotation() : null;
        return ja != null && ja.timeout() != -1 ? ja.timeout() : this.elementTimeout();
    }

    public JDIAction jdiAnnotation() {
        return ActionHelper.getJdiAction(this.jp());
    }

    public boolean isAssertAnnotation() {
        JDIAction ja = ActionHelper.getJdiAction(this.jp());
        return ja != null && ja.isAssert();
    }

    private void resetElementTimeout() {
        if (this.isBase()) {
            this.element().waitSec(this.elementTimeout());
        }
    }

    public void setElementTimeout() {
        if (!this.isBase()) {
            return;
        }
        this.elementTimeout = this.element().getTimeout();
        this.element().waitSec(this.timeout());
    }

    public JFunc1<Object, Object> overrideAction() {
        return (JFunc1)this.overrideAction.get();
    }

    private JFunc1<Object, Object> getOverride() {
        String name = this.jp().getSignature().getName();
        if (((List)isOverride.get()).contains(name)) {
            return null;
        }
        JFunc1<Object, Object> override = ActionOverride.getOverrideAction(this.jp());
        if (override != null) {
            ((List)isOverride.get()).add(name);
        }
        return override;
    }

    public void clear() {
        this.resetElementTimeout();
        ((List)isOverride.get()).clear();
    }

    public Method jpMethod() {
        return ((MethodSignature)this.jp().getSignature()).getMethod();
    }

    public Class<?> jpClass() {
        return ActionHelper.getJpClass(this.jp());
    }

    public boolean isAssert() {
        return ReflectionUtils.isClass(this.jpClass(), Alerts.class);
    }

    public String methodName() {
        return ActionHelper.getMethodName(this.jp());
    }

    public String className() {
        return ActionHelper.getJpClass(this.jp()).getSimpleName();
    }

    public String methodFullName() {
        return ActionHelper.getClassMethodName(this.jp());
    }

    public String print() {
        String result = this.processor;
        try {
            result = String.valueOf(result) + "[" + ActionHelper.aroundCount() + "]: ";
        }
        catch (Throwable throwable) {}
        try {
            result = String.valueOf(result) + this.className() + "." + this.methodName() + "(";
            Object[] args = ActionHelper.getArgs(this.jp());
            if (args.length > 0) {
                result = String.valueOf(result) + PrintUtils.print((Collection)LinqUtils.map((Object[])args, o -> o.getClass().getSimpleName()));
            }
            result = String.valueOf(result) + "); ";
        }
        catch (Throwable throwable) {}
        try {
            if (this.isBase()) {
                result = String.valueOf(result) + "Element: " + this.element().toString() + "; ";
            }
        }
        catch (Throwable throwable) {}
        return result;
    }
}

