/*
 * Decompiled with CFR 0.152.
 */
package com.epam.jdi.light.actions;

import com.epam.jdi.light.actions.ActionHelper;
import com.epam.jdi.light.actions.ActionObject;
import com.epam.jdi.light.common.Exceptions;
import com.epam.jdi.light.settings.WebSettings;
import com.jdiai.tools.LinqUtils;
import com.jdiai.tools.Safe;
import java.util.ArrayList;
import java.util.List;
import org.aspectj.lang.JoinPoint;
import org.aspectj.lang.NoAspectBoundException;
import org.aspectj.lang.ProceedingJoinPoint;
import org.aspectj.lang.annotation.Around;
import org.aspectj.lang.annotation.Aspect;
import org.aspectj.lang.annotation.Before;
import org.aspectj.lang.annotation.Pointcut;

@Aspect
public class ActionProcessor {
    public static Safe<List<ActionObject>> jStack = new Safe(new ArrayList());
    public static Safe<Boolean> isTop = new Safe((Object)true);
    private static /* synthetic */ Throwable ajc$initFailureCause;
    public static /* synthetic */ ActionProcessor ajc$perSingletonInstance;

    static {
        try {
            ActionProcessor.ajc$perSingletonInstance = new ActionProcessor();
        }
        catch (Throwable throwable) {
            ajc$initFailureCause = throwable;
        }
    }

    @Pointcut(value="within(com.epam.jdi.light..*) && @annotation(com.epam.jdi.light.common.JDIAction)")
    protected /* synthetic */ void jdiPointcut() {
    }

    @Pointcut(value="execution(* *(..)) && @annotation(io.qameta.allure.Step)")
    protected /* synthetic */ void stepPointcut() {
    }

    @Pointcut(value="execution(* *(..)) && @annotation(com.epam.jdi.light.common.JDebug)")
    protected /* synthetic */ void debugPointcut() {
    }

    @Around(value="jdiPointcut()")
    public Object jdiAround(ProceedingJoinPoint jp) {
        String classMethod = "";
        try {
            classMethod = String.valueOf(ActionHelper.getJpClass((JoinPoint)jp).getSimpleName()) + "." + ActionHelper.getMethodName((JoinPoint)jp);
            WebSettings.logger.trace("<>@AO: " + classMethod, new Object[0]);
        }
        catch (Exception exception) {
        }
        ActionObject jInfo = ActionHelper.newInfo(jp, "AO");
        ActionHelper.failedMethods.clear();
        try {
            ActionHelper.BEFORE_JDI_ACTION.execute((Object)jInfo);
            Object result = (Boolean)isTop.get() != false ? ActionHelper.stableAction(jInfo) : ActionHelper.defaultAction(jInfo);
            WebSettings.logger.trace("<>@AO: %s >>> %s", classMethod, result == null ? "NO RESULT" : result);
            ActionHelper.AFTER_JDI_ACTION.execute((Object)jInfo, result);
            Object object = result;
            return object;
        }
        catch (Throwable ex) {
            WebSettings.logger.debug("<>@AO exception:" + LinqUtils.safeException((Throwable)ex), new Object[0]);
            throw (RuntimeException)ActionHelper.ACTION_FAILED.execute((Object)jInfo, (Object)ex);
        }
        finally {
            if (jInfo != null) {
                jInfo.clear();
            }
        }
    }

    @Around(value="debugPointcut()")
    public Object debugAround(ProceedingJoinPoint jp) {
        String classMethod = String.valueOf(ActionHelper.getJpClass((JoinPoint)jp).getSimpleName()) + "." + ActionHelper.getMethodName((JoinPoint)jp);
        WebSettings.logger.debug("<>@JDebug: " + classMethod, new Object[0]);
        try {
            ActionHelper.newInfo(jp, "JDebug");
            Object result = jp.proceed();
            WebSettings.logger.debug("<>@JDebug: %s >>> %s", classMethod, result == null ? "NO RESULT" : result);
            return result;
        }
        catch (Throwable ex) {
            WebSettings.logger.debug("debugAround exception:" + LinqUtils.safeException((Throwable)ex), new Object[0]);
            throw Exceptions.exception(ex, LinqUtils.safeException((Throwable)ex), new Object[0]);
        }
    }

    @Before(value="stepPointcut()")
    public void stepAround(JoinPoint jp) {
        ActionObject jInfo = null;
        try {
            try {
                String classMethod = String.valueOf(ActionHelper.getJpClass(jp).getSimpleName()) + ":" + ActionHelper.getMethodName(jp);
                WebSettings.logger.debug("<>@Step: " + classMethod, new Object[0]);
                jInfo = ActionHelper.newInfo(jp, "AO");
                ActionHelper.beforeStepAction(jInfo);
            }
            catch (Throwable ex) {
                WebSettings.logger.debug("StepProcessor exception:" + LinqUtils.safeException((Throwable)ex), new Object[0]);
                throw (RuntimeException)ActionHelper.ACTION_FAILED.execute((Object)jInfo, (Object)ex);
            }
        }
        finally {
            if (jInfo != null) {
                jInfo.clear();
            }
        }
    }

    public static ActionProcessor aspectOf() {
        if (ajc$perSingletonInstance == null) {
            throw new NoAspectBoundException("com.epam.jdi.light.actions.ActionProcessor", ajc$initFailureCause);
        }
        return ajc$perSingletonInstance;
    }

    public static boolean hasAspect() {
        return ajc$perSingletonInstance != null;
    }
}

